/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser.scanner;

import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.internal.core.parser.scanner.AbstractCharArray;

public abstract class LazyCharArray
extends AbstractCharArray {
    private static final int CHUNK_BITS = 16;
    protected static final int CHUNK_SIZE = 65536;
    private int fLength = -1;
    private List<Chunk> fChunks = new ArrayList<Chunk>();

    protected LazyCharArray() {
    }

    public final int tryGetLength() {
        return this.fLength;
    }

    public final int getLength() {
        this.readUpTo(Integer.MAX_VALUE);
        return this.fLength;
    }

    public final boolean isValidOffset(int offset) {
        if (offset < 0) {
            return false;
        }
        this.readUpTo(offset);
        if (this.fLength >= 0) {
            return offset < this.fLength;
        }
        assert (offset < this.fChunks.size() << 16);
        return true;
    }

    private void readUpTo(int offset) {
        if (this.fLength >= 0) {
            return;
        }
        int chunkOffset = offset >> 16;
        this.getChunkData(chunkOffset);
    }

    public final char get(int offset) {
        int chunkOffset = offset >> 16;
        char[] data = this.getChunkData(chunkOffset);
        return data[offset & 0xFFFF];
    }

    public final void arraycopy(int offset, char[] destination, int destinationPos, int length) {
        int chunkOffset = offset >> 16;
        int loffset = offset & 0xFFFF;
        char[] data = this.getChunkData(chunkOffset);
        int canCopy = data.length - loffset;
        if (length <= canCopy) {
            System.arraycopy(data, loffset, destination, destinationPos, length);
            return;
        }
        System.arraycopy(data, loffset, destination, destinationPos, canCopy);
        this.arraycopy(offset + canCopy, destination, destinationPos + canCopy, length - canCopy);
    }

    private char[] getChunkData(int chunkOffset) {
        Chunk chunk = this.getChunk(chunkOffset);
        if (chunk != null) {
            char[] data = (char[])chunk.fData.get();
            if (data != null) {
                return data;
            }
            return this.loadChunkData(chunk);
        }
        return null;
    }

    private Chunk getChunk(int chunkOffset) {
        int chunkCount = this.fChunks.size();
        if (chunkOffset < chunkCount) {
            return this.fChunks.get(chunkOffset);
        }
        if (this.fLength >= 0) {
            return null;
        }
        return this.createChunk(chunkOffset);
    }

    protected Chunk createChunk(int chunkOffset) {
        int chunkCount = this.fChunks.size();
        long fileOffset = chunkCount == 0 ? 0L : this.fChunks.get((int)(chunkCount - 1)).fFileEndOffset;
        try {
            int i = chunkCount;
            while (i <= chunkOffset) {
                long[] fileEndOffset = new long[1];
                char[] data = this.readChunkData(fileOffset, fileEndOffset);
                int charCount = data.length;
                if (charCount == 0) {
                    this.fLength = this.fChunks.size() * 65536;
                    break;
                }
                Chunk chunk = new Chunk(fileOffset, fileEndOffset[0], data);
                this.fChunks.add(chunk);
                if (charCount < 65536) {
                    this.fLength = (this.fChunks.size() - 1) * 65536 + charCount;
                    break;
                }
                fileOffset = fileEndOffset[0];
                ++i;
            }
        }
        catch (Exception exception) {
            return null;
        }
        if (chunkOffset < this.fChunks.size()) {
            return this.fChunks.get(chunkOffset);
        }
        return null;
    }

    private char[] loadChunkData(Chunk chunk) {
        char[] result = new char[chunk.fDataLength];
        this.rereadChunkData(chunk.fFileOffset, chunk.fFileEndOffset, result);
        chunk.fData = new SoftReference<char[]>(result);
        return result;
    }

    protected abstract char[] readChunkData(long var1, long[] var3) throws Exception;

    protected abstract void rereadChunkData(long var1, long var3, char[] var5);

    protected static class Chunk {
        final int fDataLength;
        final long fFileOffset;
        final long fFileEndOffset;
        private SoftReference<char[]> fData;

        private Chunk(long fileOffset, long fileEndOffset, char[] data) {
            this.fDataLength = data.length;
            this.fFileOffset = fileOffset;
            this.fFileEndOffset = fileEndOffset;
            this.fData = new SoftReference<char[]>(data);
        }
    }
}

