/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.dom;

import org.eclipse.cdt.core.dom.ILinkage;
import org.eclipse.cdt.core.dom.ast.ASTNodeProperty;
import org.eclipse.cdt.core.dom.ast.ASTTypeUtil;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.ExpansionOverlapsBoundaryException;
import org.eclipse.cdt.core.dom.ast.IASTCompletionContext;
import org.eclipse.cdt.core.dom.ast.IASTFileLocation;
import org.eclipse.cdt.core.dom.ast.IASTImageLocation;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTNodeLocation;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.ICompositeType;
import org.eclipse.cdt.core.dom.ast.IEnumeration;
import org.eclipse.cdt.core.dom.ast.IEnumerator;
import org.eclipse.cdt.core.dom.ast.IField;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPBase;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPBinding;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPConstructor;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPField;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMethod;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateParameter;
import org.eclipse.cdt.core.index.IIndexBinding;
import org.eclipse.cdt.core.parser.IToken;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNotImplementedError;
import org.eclipse.core.runtime.CoreException;

public class PDOMASTAdapter {
    public static IBinding getAdapterForAnonymousASTBinding(IBinding binding) {
        char[] name;
        if (binding != null && !(binding instanceof IIndexBinding) && (name = binding.getNameCharArray()).length == 0) {
            if (binding instanceof IEnumeration) {
                name = ASTTypeUtil.createNameForAnonymous(binding);
                if (name != null) {
                    if (binding instanceof ICPPBinding) {
                        return new AnonymousCPPEnumeration(name, (IEnumeration)binding);
                    }
                    return new AnonymousEnumeration(name, (IEnumeration)binding);
                }
            } else if (binding instanceof ICPPClassType) {
                name = ASTTypeUtil.createNameForAnonymous(binding);
                if (name != null) {
                    return new AnonymousClassType(name, (ICPPClassType)binding);
                }
            } else if (binding instanceof ICompositeType) {
                name = ASTTypeUtil.createNameForAnonymous(binding);
                if (name != null) {
                    return new AnonymousCompositeType(name, (ICompositeType)binding);
                }
            } else if (binding instanceof ICPPTemplateParameter) {
                return binding;
            }
            return null;
        }
        return binding;
    }

    public static IASTName getAdapterIfAnonymous(IASTName name) {
        if (name.getLookupKey().length == 0 && name.getFileLocation() == null) {
            IASTFileLocation loc;
            IASTNode parent = name.getParent();
            if (parent != null && (loc = parent.getFileLocation()) != null) {
                return new AnonymousASTName(name, loc);
            }
            return null;
        }
        return name;
    }

    private static class AnonymousASTName
    implements IASTName {
        private IASTName fDelegate;
        private IASTFileLocation fLocation;

        public AnonymousASTName(IASTName name, final IASTFileLocation loc) {
            this.fDelegate = name;
            this.fLocation = new IASTFileLocation(){

                public int getEndingLineNumber() {
                    return loc.getStartingLineNumber();
                }

                public String getFileName() {
                    return loc.getFileName();
                }

                public int getStartingLineNumber() {
                    return loc.getStartingLineNumber();
                }

                public IASTFileLocation asFileLocation() {
                    return loc.asFileLocation();
                }

                public int getNodeLength() {
                    return 0;
                }

                public int getNodeOffset() {
                    return loc.getNodeOffset();
                }
            };
        }

        public boolean accept(ASTVisitor visitor) {
            return this.fDelegate.accept(visitor);
        }

        public boolean contains(IASTNode node) {
            return this.fDelegate.contains(node);
        }

        public IBinding getBinding() {
            return this.fDelegate.getBinding();
        }

        public IBinding getPreBinding() {
            return this.fDelegate.getPreBinding();
        }

        public String getContainingFilename() {
            return this.fLocation.getFileName();
        }

        public IASTFileLocation getFileLocation() {
            return this.fLocation;
        }

        public ILinkage getLinkage() {
            return this.fDelegate.getLinkage();
        }

        public IASTNodeLocation[] getNodeLocations() {
            return this.fDelegate.getNodeLocations();
        }

        public IASTNode getParent() {
            return this.fDelegate.getParent();
        }

        public IASTNode[] getChildren() {
            return this.fDelegate.getChildren();
        }

        public ASTNodeProperty getPropertyInParent() {
            return this.fDelegate.getPropertyInParent();
        }

        public String getRawSignature() {
            return this.fDelegate.getRawSignature();
        }

        public IASTTranslationUnit getTranslationUnit() {
            return this.fDelegate.getTranslationUnit();
        }

        public int getRoleOfName(boolean allowResolution) {
            return this.fDelegate.getRoleOfName(allowResolution);
        }

        public boolean isDeclaration() {
            return this.fDelegate.isDeclaration();
        }

        public boolean isDefinition() {
            return this.fDelegate.isDefinition();
        }

        public boolean isReference() {
            return this.fDelegate.isReference();
        }

        public IBinding resolveBinding() {
            return this.fDelegate.resolveBinding();
        }

        public IBinding resolvePreBinding() {
            return this.fDelegate.resolvePreBinding();
        }

        public IASTCompletionContext getCompletionContext() {
            return this.fDelegate.getCompletionContext();
        }

        public void setBinding(IBinding binding) {
            this.fDelegate.setBinding(binding);
        }

        public void setParent(IASTNode node) {
            this.fDelegate.setParent(node);
        }

        public void setPropertyInParent(ASTNodeProperty property) {
            this.fDelegate.setPropertyInParent(property);
        }

        public char[] toCharArray() {
            return this.fDelegate.toCharArray();
        }

        public char[] getSimpleID() {
            return this.fDelegate.getSimpleID();
        }

        public char[] getLookupKey() {
            return this.fDelegate.getLookupKey();
        }

        public IASTImageLocation getImageLocation() {
            return null;
        }

        public boolean isPartOfTranslationUnitFile() {
            return this.fLocation.getFileName().equals(this.fDelegate.getTranslationUnit().getFilePath());
        }

        public String toString() {
            return this.fDelegate.toString();
        }

        public IASTName getLastName() {
            return this;
        }

        public IToken getSyntax() throws ExpansionOverlapsBoundaryException, UnsupportedOperationException {
            return this.fDelegate.getSyntax();
        }

        public IToken getLeadingSyntax() throws ExpansionOverlapsBoundaryException, UnsupportedOperationException {
            return this.fDelegate.getLeadingSyntax();
        }

        public IToken getTrailingSyntax() throws ExpansionOverlapsBoundaryException, UnsupportedOperationException {
            return this.fDelegate.getTrailingSyntax();
        }

        public boolean isFrozen() {
            return this.fDelegate.isFrozen();
        }

        public boolean isActive() {
            return this.fDelegate.isFrozen();
        }

        public IASTName copy() {
            throw new UnsupportedOperationException();
        }
    }

    private static class AnonymousCPPBinding
    implements ICPPBinding {
        protected ICPPBinding fDelegate;
        private char[] fName;

        public AnonymousCPPBinding(char[] name, ICPPBinding delegate) {
            this.fName = name;
            this.fDelegate = delegate;
        }

        public Object clone() {
            throw new PDOMNotImplementedError();
        }

        public String getName() {
            return new String(this.fName);
        }

        public char[] getNameCharArray() {
            return this.fName;
        }

        public String[] getQualifiedName() throws DOMException {
            String[] qn = this.fDelegate.getQualifiedName();
            if (qn.length < 1) {
                qn = new String[1];
            }
            qn[qn.length - 1] = new String(this.fName);
            return qn;
        }

        public char[][] getQualifiedNameCharArray() throws DOMException {
            Object qn = this.fDelegate.getQualifiedNameCharArray();
            if (((char[][])qn).length < 1) {
                qn = new char[1][];
            }
            qn[((char[][])qn).length - 1] = this.fName;
            return qn;
        }

        public Object getAdapter(Class adapter) {
            return this.fDelegate.getAdapter(adapter);
        }

        public ILinkage getLinkage() throws CoreException {
            return this.fDelegate.getLinkage();
        }

        public IScope getScope() throws DOMException {
            return this.fDelegate.getScope();
        }

        public boolean isGloballyQualified() throws DOMException {
            return this.fDelegate.isGloballyQualified();
        }

        public IBinding getOwner() throws DOMException {
            return this.fDelegate.getOwner();
        }
    }

    private static class AnonymousCPPEnumeration
    extends AnonymousCPPBinding
    implements IEnumeration {
        public AnonymousCPPEnumeration(char[] name, IEnumeration delegate) {
            super(name, (ICPPBinding)((Object)delegate));
        }

        public IEnumerator[] getEnumerators() throws DOMException {
            return ((IEnumeration)((Object)this.fDelegate)).getEnumerators();
        }

        public boolean isSameType(IType type) {
            return ((IEnumeration)((Object)this.fDelegate)).isSameType(type);
        }

        public long getMinValue() {
            return ((IEnumeration)((Object)this.fDelegate)).getMinValue();
        }

        public long getMaxValue() {
            return ((IEnumeration)((Object)this.fDelegate)).getMaxValue();
        }
    }

    private static class AnonymousClassType
    extends AnonymousCPPBinding
    implements ICPPClassType {
        public AnonymousClassType(char[] name, ICPPClassType delegate) {
            super(name, delegate);
        }

        public IField findField(String name) throws DOMException {
            return ((ICPPClassType)this.fDelegate).findField(name);
        }

        public ICPPMethod[] getAllDeclaredMethods() throws DOMException {
            return ((ICPPClassType)this.fDelegate).getAllDeclaredMethods();
        }

        public ICPPBase[] getBases() throws DOMException {
            return ((ICPPClassType)this.fDelegate).getBases();
        }

        public IScope getCompositeScope() throws DOMException {
            return ((ICPPClassType)this.fDelegate).getCompositeScope();
        }

        public ICPPConstructor[] getConstructors() throws DOMException {
            return ((ICPPClassType)this.fDelegate).getConstructors();
        }

        public ICPPField[] getDeclaredFields() throws DOMException {
            return ((ICPPClassType)this.fDelegate).getDeclaredFields();
        }

        public ICPPMethod[] getDeclaredMethods() throws DOMException {
            return ((ICPPClassType)this.fDelegate).getDeclaredMethods();
        }

        public IField[] getFields() throws DOMException {
            return ((ICPPClassType)this.fDelegate).getFields();
        }

        public IBinding[] getFriends() throws DOMException {
            return ((ICPPClassType)this.fDelegate).getFriends();
        }

        public int getKey() throws DOMException {
            return ((ICPPClassType)this.fDelegate).getKey();
        }

        public ICPPMethod[] getMethods() throws DOMException {
            return ((ICPPClassType)this.fDelegate).getMethods();
        }

        public ICPPClassType[] getNestedClasses() throws DOMException {
            return ((ICPPClassType)this.fDelegate).getNestedClasses();
        }

        public boolean isSameType(IType type) {
            return ((ICPPClassType)this.fDelegate).isSameType(type);
        }

        public boolean isAnonymous() throws DOMException {
            return ((ICPPClassType)this.fDelegate).isAnonymous();
        }
    }

    private static class AnonymousCompositeType
    implements ICompositeType {
        protected ICompositeType fDelegate;
        private char[] fName;

        public AnonymousCompositeType(char[] name, ICompositeType delegate) {
            this.fName = name;
            this.fDelegate = delegate;
        }

        public Object clone() {
            throw new PDOMNotImplementedError();
        }

        public IField findField(String name) throws DOMException {
            return this.fDelegate.findField(name);
        }

        public Object getAdapter(Class adapter) {
            return this.fDelegate.getAdapter(adapter);
        }

        public IScope getCompositeScope() throws DOMException {
            return this.fDelegate.getCompositeScope();
        }

        public IField[] getFields() throws DOMException {
            return this.fDelegate.getFields();
        }

        public int getKey() throws DOMException {
            return this.fDelegate.getKey();
        }

        public ILinkage getLinkage() throws CoreException {
            return this.fDelegate.getLinkage();
        }

        public String getName() {
            return new String(this.fName);
        }

        public char[] getNameCharArray() {
            return this.fName;
        }

        public IScope getScope() throws DOMException {
            return this.fDelegate.getScope();
        }

        public boolean isSameType(IType type) {
            return this.fDelegate.isSameType(type);
        }

        public IBinding getOwner() throws DOMException {
            return this.fDelegate.getOwner();
        }

        public boolean isAnonymous() throws DOMException {
            return this.fDelegate.isAnonymous();
        }
    }

    private static class AnonymousEnumeration
    implements IEnumeration {
        private IEnumeration fDelegate;
        private char[] fName;

        public AnonymousEnumeration(char[] name, IEnumeration delegate) {
            this.fName = name;
            this.fDelegate = delegate;
        }

        public Object clone() {
            throw new PDOMNotImplementedError();
        }

        public Object getAdapter(Class adapter) {
            return this.fDelegate.getAdapter(adapter);
        }

        public IEnumerator[] getEnumerators() throws DOMException {
            return this.fDelegate.getEnumerators();
        }

        public ILinkage getLinkage() throws CoreException {
            return this.fDelegate.getLinkage();
        }

        public String getName() {
            return new String(this.fName);
        }

        public char[] getNameCharArray() {
            return this.fName;
        }

        public IScope getScope() throws DOMException {
            return this.fDelegate.getScope();
        }

        public boolean isSameType(IType type) {
            return this.fDelegate.isSameType(type);
        }

        public IBinding getOwner() throws DOMException {
            return this.fDelegate.getOwner();
        }

        public long getMinValue() {
            return this.fDelegate.getMinValue();
        }

        public long getMaxValue() {
            return this.fDelegate.getMaxValue();
        }
    }
}

