/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.core.model;

import java.util.LinkedList;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.internal.core.model.Parent;
import org.eclipse.cdt.internal.core.model.TranslationUnit;
import org.eclipse.photran.internal.core.lexer.IToken;
import org.eclipse.photran.internal.core.lexer.Token;
import org.eclipse.photran.internal.core.model.FortranElement;
import org.eclipse.photran.internal.core.model.FortranModelBuilder;
import org.eclipse.photran.internal.core.parser.ASTBlockDataSubprogramNode;
import org.eclipse.photran.internal.core.parser.ASTComponentDeclNode;
import org.eclipse.photran.internal.core.parser.ASTDataComponentDefStmtNode;
import org.eclipse.photran.internal.core.parser.ASTDerivedTypeDefNode;
import org.eclipse.photran.internal.core.parser.ASTExternalNameListNode;
import org.eclipse.photran.internal.core.parser.ASTExternalStmtNode;
import org.eclipse.photran.internal.core.parser.ASTFunctionSubprogramNode;
import org.eclipse.photran.internal.core.parser.ASTGenericBindingNode;
import org.eclipse.photran.internal.core.parser.ASTGenericSpecNode;
import org.eclipse.photran.internal.core.parser.ASTInterfaceBlockNode;
import org.eclipse.photran.internal.core.parser.ASTIntrinsicListNode;
import org.eclipse.photran.internal.core.parser.ASTIntrinsicStmtNode;
import org.eclipse.photran.internal.core.parser.ASTMainProgramNode;
import org.eclipse.photran.internal.core.parser.ASTModuleNode;
import org.eclipse.photran.internal.core.parser.ASTSpecificBindingNode;
import org.eclipse.photran.internal.core.parser.ASTStmtFunctionStmtNode;
import org.eclipse.photran.internal.core.parser.ASTSubmoduleNode;
import org.eclipse.photran.internal.core.parser.ASTSubroutineSubprogramNode;
import org.eclipse.photran.internal.core.parser.Parser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FortranModelBuildingVisitor
extends Parser.GenericASTVisitor {
    private TranslationUnit translationUnit;
    private FortranModelBuilder modelBuilder;
    private LinkedList<Parser.IASTNode> parentParseTreeNodeStack = new LinkedList();
    private LinkedList<FortranElement> parentElementStack = new LinkedList();

    public FortranModelBuildingVisitor(TranslationUnit translationUnit, FortranModelBuilder modelBuilder) {
        this.translationUnit = translationUnit;
        this.modelBuilder = modelBuilder;
    }

    private Parent getCurrentParent() {
        if (this.parentElementStack.isEmpty()) {
            return this.translationUnit;
        }
        return (Parent)this.parentElementStack.getLast();
    }

    private boolean isCurrentParent(Parser.IASTNode node) {
        if (this.parentParseTreeNodeStack.isEmpty()) {
            return false;
        }
        return node == this.parentParseTreeNodeStack.getLast();
    }

    private void addToModel(Parser.IASTNode parseTreeNode, FortranElement element) {
        try {
            this.modelBuilder.addF90Element(element);
            this.beginAddingChildrenFor(parseTreeNode, element);
        }
        catch (CModelException cModelException) {}
    }

    private void addToModelNoChildren(FortranElement element) {
        try {
            this.modelBuilder.addF90Element(element);
        }
        catch (CModelException cModelException) {}
    }

    private void beginAddingChildrenFor(Parser.IASTNode parseTreeNode, FortranElement element) {
        this.parentParseTreeNodeStack.addLast(parseTreeNode);
        this.parentElementStack.addLast(element);
    }

    private void doneAddingChildrenFor(Parser.IASTNode node) {
        if (this.isCurrentParent(node)) {
            this.parentParseTreeNodeStack.removeLast();
            this.parentElementStack.removeLast();
        }
    }

    public void visitASTNode(Parser.IASTNode node) {
        this.traverseChildren(node);
        this.doneAddingChildrenFor(node);
    }

    private <T extends FortranElement> T setPos(T element, Parser.IASTNode astNode) {
        Token first = astNode.findFirstToken();
        Token last = astNode.findLastToken();
        if (first != null && last != null) {
            element.setPos(first.getFileOffset(), last.getFileOffset() + last.getLength() - first.getFileOffset());
            element.setLines(first.getLine(), last.getLine());
        }
        return element;
    }

    public void visitASTMainProgramNode(ASTMainProgramNode node) {
        Token token = node.getProgramStmt() == null ? null : node.getProgramStmt().getProgramName().getProgramName();
        this.addToModel((Parser.IASTNode)node, (FortranElement)this.setPos(new FortranElement.MainProgram(this.getCurrentParent(), (IToken)token), (Parser.IASTNode)node));
    }

    public void visitASTModuleNode(ASTModuleNode node) {
        Token token = node.getModuleStmt().getModuleName().getModuleName();
        this.addToModel((Parser.IASTNode)node, (FortranElement)this.setPos(new FortranElement.Module(this.getCurrentParent(), (IToken)token), (Parser.IASTNode)node));
    }

    public void visitASTSubmoduleNode(ASTSubmoduleNode node) {
        Token token = node.getSubmoduleStmt().getSubmoduleName().getModuleName();
        this.addToModel((Parser.IASTNode)node, (FortranElement)this.setPos(new FortranElement.Submodule(this.getCurrentParent(), (IToken)token), (Parser.IASTNode)node));
    }

    public void visitASTFunctionSubprogramNode(ASTFunctionSubprogramNode node) {
        Token token = node.getFunctionStmt().getFunctionName().getFunctionName();
        this.addToModel((Parser.IASTNode)node, (FortranElement)this.setPos(new FortranElement.Function(this.getCurrentParent(), (IToken)token), (Parser.IASTNode)node));
    }

    public void visitASTSubroutineSubprogramNode(ASTSubroutineSubprogramNode node) {
        Token token = node.getSubroutineStmt().getSubroutineName().getSubroutineName();
        this.addToModel((Parser.IASTNode)node, (FortranElement)this.setPos(new FortranElement.Subroutine(this.getCurrentParent(), (IToken)token), (Parser.IASTNode)node));
    }

    public void visitASTSpecificBindingNode(ASTSpecificBindingNode node) {
        Token token = node.getBindingName();
        this.addToModel((Parser.IASTNode)node, (FortranElement)this.setPos(new FortranElement.Subroutine(this.getCurrentParent(), (IToken)token), (Parser.IASTNode)node));
    }

    public void visitASTGenericBindingNode(ASTGenericBindingNode node) {
        ASTGenericSpecNode spec;
        Token token = node.getGenericName() != null ? node.getGenericName().getGenericName() : ((spec = node.getGenericSpec()).isAssignmentOperator() ? spec.getEqualsToken() : (spec.isDefinedOperator() ? spec.getDefinedOperator().findFirstToken() : spec.findFirstToken()));
        this.addToModel((Parser.IASTNode)node, (FortranElement)this.setPos(new FortranElement.Subroutine(this.getCurrentParent(), (IToken)token), (Parser.IASTNode)node));
    }

    public void visitASTBlockDataSubprogramNode(ASTBlockDataSubprogramNode node) {
        Token token = node.getBlockDataStmt().getBlockDataName() == null ? null : node.getBlockDataStmt().getBlockDataName().getBlockDataName();
        this.addToModel((Parser.IASTNode)node, (FortranElement)this.setPos(new FortranElement.BlockData(this.getCurrentParent(), (IToken)token), (Parser.IASTNode)node));
    }

    public void visitASTDerivedTypeDefNode(ASTDerivedTypeDefNode node) {
        Token token = node.getDerivedTypeStmt().getTypeName();
        this.addToModel((Parser.IASTNode)node, (FortranElement)this.setPos(new FortranElement.DerivedType(this.getCurrentParent(), (IToken)token), (Parser.IASTNode)node));
    }

    public void visitASTDataComponentDefStmtNode(ASTDataComponentDefStmtNode node) {
        for (ASTComponentDeclNode decl : node.getComponentDeclList()) {
            this.addToModelNoChildren((FortranElement)this.setPos(new FortranElement.Variable(this.getCurrentParent(), (IToken)decl.getComponentName().getComponentName()), (Parser.IASTNode)node));
        }
    }

    public void visitASTExternalStmtNode(ASTExternalStmtNode node) {
        Parser.IASTListNode list = node.getExternalNameList();
        int i = 0;
        while (i < list.size()) {
            this.addToModel((Parser.IASTNode)node, (FortranElement)this.setPos(new FortranElement.Variable(this.getCurrentParent(), (IToken)((ASTExternalNameListNode)list.get(i)).getExternalName()), (Parser.IASTNode)node));
            ++i;
        }
    }

    public void visitASTInterfaceBlockNode(ASTInterfaceBlockNode node) {
        Token token = node.getInterfaceStmt().getGenericName() == null ? null : node.getInterfaceStmt().getGenericName().getGenericName();
        this.addToModel((Parser.IASTNode)node, (FortranElement)this.setPos(new FortranElement.Variable(this.getCurrentParent(), (IToken)token), (Parser.IASTNode)node));
    }

    public void visitASTIntrinsicStmtNode(ASTIntrinsicStmtNode node) {
        Parser.IASTListNode list = node.getIntrinsicList();
        int i = 0;
        while (i < list.size()) {
            this.addToModel((Parser.IASTNode)node, (FortranElement)this.setPos(new FortranElement.Variable(this.getCurrentParent(), (IToken)((ASTIntrinsicListNode)list.get(i)).getIntrinsicProcedureName()), (Parser.IASTNode)node));
            ++i;
        }
    }

    public void visitASTStmtFunctionStmtNode(ASTStmtFunctionStmtNode node) {
        this.addToModel((Parser.IASTNode)node, (FortranElement)this.setPos(new FortranElement.Variable(this.getCurrentParent(), (IToken)node.getName().getName()), (Parser.IASTNode)node));
    }
}

