/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rephraserengine.core.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;

public class StringUtil {
    private StringUtil() {
    }

    public static long countLines(String s) {
        if (s.length() == 0) {
            return 0L;
        }
        long numLines = 1L;
        int lastIndex = 0;
        int nextIndex = s.indexOf(10);
        while (nextIndex >= 0) {
            ++numLines;
            lastIndex = nextIndex;
            nextIndex = lastIndex + 1 >= s.length() ? -1 : s.indexOf(10, lastIndex + 1);
        }
        return numLines;
    }

    public static String read(Reader in) throws IOException {
        StringBuilder sb = new StringBuilder();
        int ch = in.read();
        while (ch >= 0) {
            sb.append((char)ch);
            ch = in.read();
        }
        in.close();
        return sb.toString();
    }

    public static String read(InputStream in) throws IOException {
        return StringUtil.read(new InputStreamReader(in));
    }

    public static String read(IFile file) throws IOException, CoreException {
        return StringUtil.read(file.getContents(true));
    }

    public static String read(File file) throws IOException {
        return StringUtil.read(new BufferedReader(new FileReader(file)));
    }

    public static String readOrReturnNull(IFile file) {
        try {
            return StringUtil.read(file);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static int offsetOf(int line, int col, String string) {
        assert (line >= 1 && col >= 1 && string != null);
        int offset = StringUtil.offsetOfLine(line, string);
        if (offset < 0) {
            return -1;
        }
        return offset + col - 1;
    }

    public static int offsetOfLine(int line, String string) {
        assert (line >= 1 && string != null);
        if (line == 1) {
            return 0;
        }
        int precedingLF = -1;
        int curLine = 1;
        while (precedingLF >= 0 || curLine == 1) {
            precedingLF = string.indexOf(10, precedingLF + 1);
            if (++curLine != line) continue;
            return precedingLF < 0 ? -1 : precedingLF + 1;
        }
        return -1;
    }

    public static String stripNonASCIICharsAndCRs(String s) {
        return StringUtil.stripNonASCIIChars(s, true);
    }

    public static String stripNonASCIIChars(String s) {
        return StringUtil.stripNonASCIIChars(s, false);
    }

    protected static String stripNonASCIIChars(String s, boolean stripCRs) {
        StringBuilder sb = new StringBuilder(s.length());
        int i = 0;
        int len = s.length();
        while (i < len) {
            char ch = s.charAt(i);
            if (!stripCRs || i != 13) {
                if (i < 256) {
                    sb.append(ch);
                } else {
                    sb.append('?');
                }
            }
            ++i;
        }
        return sb.toString();
    }
}

