/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.utils.core.file;

import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.Stack;
import org.eclipse.ptp.utils.core.file.FileEnumeration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileRecursiveEnumeration
implements Enumeration<File> {
    private Stack<File> roots;
    private FileEnumeration currentDirectory;
    private File nextFile;
    private LinkedList<Exception> exceptionList = new LinkedList();

    public static void main(String[] args) {
        FileRecursiveEnumeration enumeration = new FileRecursiveEnumeration("c:/command/gs");
        while (enumeration.hasMoreElements()) {
        }
    }

    public FileRecursiveEnumeration(File root) {
        if (!root.exists()) {
            throw new IllegalArgumentException();
        }
        this.roots = new Stack();
        this.roots.add(root);
        this.fetchNextFile();
    }

    public FileRecursiveEnumeration(String root) {
        this(new File(root));
    }

    @Override
    public boolean hasMoreElements() {
        return this.nextFile != null;
    }

    public boolean hasMoreExceptions() {
        return this.exceptionList.size() > 0;
    }

    @Override
    public File nextElement() {
        File result = this.nextFile;
        this.fetchNextFile();
        return result;
    }

    public Exception nextException() {
        if (this.exceptionList.size() == 0) {
            throw new NoSuchElementException();
        }
        return this.exceptionList.removeFirst();
    }

    private void fetchNextFile() {
        this.nextFile = null;
        while (true) {
            if (this.currentDirectory == null) {
                if (this.roots.empty()) {
                    return;
                }
                File root = this.roots.pop();
                try {
                    this.currentDirectory = new FileEnumeration(root);
                }
                catch (IOException e) {
                    this.exceptionList.addLast(e);
                }
                continue;
            }
            if (this.currentDirectory.hasMoreElements()) {
                this.nextFile = this.currentDirectory.nextElement();
                if (this.nextFile.isDirectory()) {
                    this.roots.add(this.nextFile);
                }
                return;
            }
            this.currentDirectory = null;
        }
    }
}

