/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.pbs.ui;

import org.eclipse.core.runtime.Preferences;
import org.eclipse.ptp.core.PTPCorePlugin;
import org.eclipse.ptp.core.elementcontrols.IPUniverseControl;
import org.eclipse.ptp.core.elementcontrols.IResourceManagerControl;
import org.eclipse.ptp.rm.core.rmsystem.AbstractRemoteResourceManagerServiceProvider;
import org.eclipse.ptp.rm.pbs.core.PBSPreferenceManager;
import org.eclipse.ptp.rm.pbs.core.rmsystem.IPBSResourceManagerConfiguration;
import org.eclipse.ptp.rm.pbs.core.rmsystem.PBSResourceManager;
import org.eclipse.ptp.rmsystem.IResourceManagerConfiguration;
import org.eclipse.ptp.services.core.IServiceProvider;
import org.eclipse.ptp.services.core.IServiceProviderWorkingCopy;

public class PBSServiceProvider
extends AbstractRemoteResourceManagerServiceProvider
implements IPBSResourceManagerConfiguration {
    private static final String TAG_PBSD_PATH = "pbsdPath";
    private static final String TAG_PBSD_ARGS = "pbsdArgs";
    private static final String TAG_PBSD_DEFAULTS = "pbsdDefaults";
    public static final String EMPTY_STRING = "";
    private final Preferences preferences = PBSPreferenceManager.getPreferences();

    public PBSServiceProvider() {
        this.setDescription("PBS Resource Manager");
    }

    public PBSServiceProvider(IServiceProvider provider) {
        super(provider);
    }

    public IServiceProviderWorkingCopy copy() {
        return new PBSServiceProvider((IServiceProvider)this);
    }

    public IResourceManagerControl createResourceManager() {
        IPUniverseControl universe = (IPUniverseControl)PTPCorePlugin.getDefault().getUniverse();
        return new PBSResourceManager(Integer.valueOf(universe.getNextResourceManagerId()), universe, (IResourceManagerConfiguration)this);
    }

    public String getPBSdArgs() {
        return this.getString(TAG_PBSD_ARGS, this.preferences.getString(EMPTY_STRING));
    }

    public String getPBSdPath() {
        return this.getString(TAG_PBSD_PATH, this.preferences.getString(EMPTY_STRING));
    }

    public String getResourceManagerId() {
        return this.getId();
    }

    public boolean getUseDefaults() {
        return this.getBoolean(TAG_PBSD_DEFAULTS, true);
    }

    public boolean isConfigured() {
        return true;
    }

    public void setDefaultNameAndDesc() {
        String name = "PBS";
        String conn = this.getConnectionName();
        if (conn != null && !conn.equals(EMPTY_STRING)) {
            name = String.valueOf(name) + "@" + conn;
        }
        this.setName(name);
        this.setDescription("PBS Resource Manager");
    }

    public void setPBSdArgs(String pbsdArgs) {
        this.putString(TAG_PBSD_ARGS, pbsdArgs);
    }

    public void setPBSdPath(String pbsdPath) {
        this.putString(TAG_PBSD_PATH, pbsdPath);
    }

    public void setUseDefaults(boolean useDefaults) {
        this.putBoolean(TAG_PBSD_DEFAULTS, useDefaults);
    }
}

