/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.pbs.ui.dialogs;

import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ScrollingEditableMessageDialog
extends MessageDialog {
    public static final int DEFAULT_INDEX = 0;
    public static final String[] DEFAULT_LABELS = new String[]{"Close"};
    protected Button okButton;
    protected Text scrollable;
    protected String title;
    protected String value;

    public ScrollingEditableMessageDialog(Shell parentShell, String name, String value) {
        this(parentShell, name, value, name, null, 0, DEFAULT_LABELS, 0);
    }

    public ScrollingEditableMessageDialog(Shell parentShell, String name, String value, String dialogTitle, Image dialogTitleImage, int dialogImageType, String[] dialogButtonLabels, int defaultIndex) {
        super(parentShell, dialogTitle, dialogTitleImage, name, dialogImageType, dialogButtonLabels, defaultIndex);
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public int open() {
        this.createDialogArea((Composite)this.getParentShell());
        return super.open();
    }

    protected void buttonPressed(int buttonId) {
        this.value = buttonId == 0 ? this.scrollable.getText() : null;
        super.buttonPressed(buttonId);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        if (this.title != null) {
            shell.setText(this.title);
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.okButton = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        this.scrollable.setFocus();
        if (this.value != null) {
            this.scrollable.setText(this.value);
            this.scrollable.selectAll();
        }
    }

    protected Control createDialogArea(Composite parent) {
        Control c = super.createDialogArea(parent);
        GridData data = new GridData(272);
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = true;
        data.heightHint = 550;
        data.widthHint = this.convertWidthInCharsToPixels(160);
        this.scrollable = new Text(parent, 2882);
        this.scrollable.setLayoutData((Object)data);
        this.scrollable.setEditable(true);
        Display d = Display.getCurrent();
        FontData[][] f = new FontData[][]{d.getFontList("Courier", true), d.getFontList("Courier", false), d.getFontList("Courier", true), d.getFontList("Courier", false), d.getFontList("Courier", true), d.getFontList("Courier", false)};
        int i = 0;
        while (i < f.length) {
            if (f[i].length > 0) {
                this.scrollable.setFont(new Font((Device)d, f[i]));
                break;
            }
            ++i;
        }
        if (i == f.length) {
            ScrollingEditableMessageDialog.applyDialogFont((Control)this.scrollable);
        }
        return c;
    }
}

