/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.pbs.ui.launch;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.ptp.core.attributes.IAttribute;
import org.eclipse.ptp.core.attributes.IAttributeDefinition;
import org.eclipse.ptp.core.attributes.IllegalValueException;
import org.eclipse.ptp.core.elements.IPQueue;
import org.eclipse.ptp.core.elements.IResourceManager;
import org.eclipse.ptp.launch.ui.extensions.RMLaunchValidation;
import org.eclipse.ptp.rm.pbs.core.PBSJobAttributes;
import org.eclipse.ptp.rm.pbs.ui.AttributePlaceholder;
import org.eclipse.ptp.rm.pbs.ui.messages.Messages;
import org.eclipse.ptp.rm.pbs.ui.utils.WidgetUtils;
import org.eclipse.ptp.rm.pbs.ui.wizards.DynamicTabWizardPage;
import org.eclipse.ptp.rm.ui.launch.BaseRMLaunchConfigurationDynamicTab;
import org.eclipse.ptp.rm.ui.launch.RMLaunchConfigurationDynamicTabDataSource;
import org.eclipse.ptp.rm.ui.launch.RMLaunchConfigurationDynamicTabWidgetListener;
import org.eclipse.ptp.rm.ui.utils.DataSource;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PBSRMLaunchConfigurationDynamicTab
extends BaseRMLaunchConfigurationDynamicTab {
    private Composite control;
    private PBSRMLaunchDataSource dataSource;
    private PBSRMLaunchWidgetListener listener;
    private Map<Control, AttributePlaceholder> valueWidgets;
    private DynamicTabWizardPage wizardPage;

    public void createControl(Composite parent, IResourceManager rm, IPQueue queue) throws CoreException {
        this.control = WidgetUtils.createContainer(parent, null, false, 110);
        this.valueWidgets = new HashMap<Control, AttributePlaceholder>();
        this.wizardPage = new DynamicTabWizardPage(this.valueWidgets, this.getListener());
        this.wizardPage.createControl(this.control);
    }

    public IAttribute<?, ?, ?>[] getAttributes(IResourceManager rm, IPQueue queue, ILaunchConfiguration configuration, String mode) throws CoreException {
        ArrayList<IAttribute> attrs = new ArrayList<IAttribute>();
        Map configAttr = configuration.getAttributes();
        Map defs = PBSJobAttributes.getAttributeDefinitionMap();
        try {
            for (Map.Entry e : configAttr.entrySet()) {
                Object value = e.getValue();
                IAttributeDefinition def = (IAttributeDefinition)defs.get(e.getKey());
                if (def == null || value == null) continue;
                attrs.add(((IAttributeDefinition)defs.get(e.getKey())).create(value.toString()));
            }
        }
        catch (IllegalValueException e) {
            throw new CoreException((IStatus)new Status(2, "org.eclipse.ptp.utils.ui", "getAttributes", (Throwable)e));
        }
        return attrs.toArray(new IAttribute[attrs.size()]);
    }

    public Control getControl() {
        return this.control;
    }

    public Image getImage() {
        return null;
    }

    public String getText() {
        return Messages.BasicPBSConfigurationWizardPage_title;
    }

    public RMLaunchValidation performApply(ILaunchConfigurationWorkingCopy configuration, IResourceManager rm, IPQueue queue) {
        this.dataSource.toggleSave();
        RMLaunchValidation validation = super.performApply(configuration, rm, queue);
        this.dataSource.toggleSave();
        return validation;
    }

    public RMLaunchValidation setDefaults(ILaunchConfigurationWorkingCopy configuration, IResourceManager rm, IPQueue queue) {
        return new RMLaunchValidation(true, null);
    }

    public void updateControls() {
    }

    protected synchronized RMLaunchConfigurationDynamicTabDataSource createDataSource() {
        if (this.dataSource == null) {
            this.dataSource = new PBSRMLaunchDataSource(this);
        }
        return this.dataSource;
    }

    protected synchronized RMLaunchConfigurationDynamicTabWidgetListener createListener() {
        if (this.listener == null) {
            this.listener = new PBSRMLaunchWidgetListener(this);
        }
        return this.listener;
    }

    class PBSRMLaunchDataSource
    extends RMLaunchConfigurationDynamicTabDataSource {
        private boolean save;

        protected PBSRMLaunchDataSource(BaseRMLaunchConfigurationDynamicTab page) {
            super(page);
            this.save = false;
        }

        protected void copyFromFields() throws DataSource.ValidationException {
            this.toggleSave();
            for (Map.Entry e : PBSRMLaunchConfigurationDynamicTab.this.valueWidgets.entrySet()) {
                Control c = (Control)e.getKey();
                AttributePlaceholder ap = (AttributePlaceholder)e.getValue();
                Object value = null;
                if (c instanceof Text) {
                    value = this.extractText((Text)c);
                } else if (c instanceof Spinner) {
                    value = ((Spinner)c).getSelection();
                } else if (c instanceof Button) {
                    value = ((Button)c).getSelection();
                }
                if (value == null) continue;
                try {
                    ap.getAttribute().setValueAsString(value.toString());
                }
                catch (IllegalValueException t) {
                    throw new DataSource.ValidationException((DataSource)this, t.toString());
                }
            }
            this.toggleSave();
        }

        protected void copyToFields() {
            for (Map.Entry e : PBSRMLaunchConfigurationDynamicTab.this.valueWidgets.entrySet()) {
                Control c = (Control)e.getKey();
                AttributePlaceholder ap = (AttributePlaceholder)e.getValue();
                Object value = ap.getAttribute().getValue();
                if (value == null) continue;
                if (c instanceof Text) {
                    this.applyText((Text)c, (String)value);
                    continue;
                }
                if (c instanceof Spinner) {
                    ((Spinner)c).setSelection(((Integer)value).intValue());
                    continue;
                }
                if (!(c instanceof Button)) continue;
                ((Button)c).setSelection(((Boolean)value).booleanValue());
            }
        }

        protected void copyToStorage() {
            ILaunchConfigurationWorkingCopy config = this.getConfigurationWorkingCopy();
            for (AttributePlaceholder ap : PBSRMLaunchConfigurationDynamicTab.this.valueWidgets.values()) {
                IAttribute<?, ?, ?> attr = ap.getAttribute();
                String id = attr.getDefinition().getId();
                Object value = attr.getValue();
                if (value instanceof Boolean) {
                    config.setAttribute(id, ((Boolean)value).booleanValue());
                    continue;
                }
                if (value instanceof Integer) {
                    config.setAttribute(id, ((Integer)value).intValue());
                    continue;
                }
                if (!(value instanceof String)) continue;
                config.setAttribute(id, (String)value);
            }
        }

        protected void loadDefault() {
        }

        protected void loadFromStorage() {
            ILaunchConfigurationWorkingCopy config = this.getConfigurationWorkingCopy();
            if (config == null) {
                config = this.getConfiguration();
            }
            if (config == null) {
                return;
            }
            for (Map.Entry e : PBSRMLaunchConfigurationDynamicTab.this.valueWidgets.entrySet()) {
                Control c = (Control)e.getKey();
                AttributePlaceholder ap = (AttributePlaceholder)e.getValue();
                IAttribute<?, ?, ?> attr = ap.getAttribute();
                String id = attr.getDefinition().getId();
                Object value = null;
                try {
                    if (c instanceof Text) {
                        value = config.getAttribute(id, "");
                    } else if (c instanceof Button) {
                        value = config.getAttribute(id, false);
                    } else if (c instanceof Spinner) {
                        value = config.getAttribute(id, 1);
                    }
                    if (value == null) continue;
                    attr.setValueAsString(value.toString());
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        }

        protected void validateLocal() throws DataSource.ValidationException {
            if (!this.save()) {
                for (AttributePlaceholder ap : PBSRMLaunchConfigurationDynamicTab.this.valueWidgets.values()) {
                    Object value = ap.getAttribute().getValue();
                    if (value != null && !"".equals(value.toString().trim())) continue;
                    throw new DataSource.ValidationException((DataSource)this, String.valueOf(ap.getName()) + ": VALUE NOT SET");
                }
            } else {
                for (Control c : PBSRMLaunchConfigurationDynamicTab.this.valueWidgets.keySet()) {
                    String value;
                    if (!(c instanceof Text) || (value = ((Text)c).getText().trim()) != null && !"".equals(value)) continue;
                    AttributePlaceholder ap = (AttributePlaceholder)PBSRMLaunchConfigurationDynamicTab.this.valueWidgets.get(c);
                    throw new DataSource.ValidationException((DataSource)this, String.valueOf(ap.getName()) + ": VALUE NOT SET");
                }
            }
        }

        private synchronized boolean save() {
            return this.save;
        }

        private synchronized void toggleSave() {
            this.save = !this.save;
        }
    }

    class PBSRMLaunchWidgetListener
    extends RMLaunchConfigurationDynamicTabWidgetListener {
        public PBSRMLaunchWidgetListener(BaseRMLaunchConfigurationDynamicTab dynamicTab) {
            super(dynamicTab);
        }
    }
}

