/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.pbs.ui.preferences;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.TreeMap;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.ptp.core.attributes.IAttributeDefinition;
import org.eclipse.ptp.core.attributes.IllegalValueException;
import org.eclipse.ptp.rm.pbs.core.PBSJobAttributes;
import org.eclipse.ptp.rm.pbs.core.PBSPreferenceManager;
import org.eclipse.ptp.rm.pbs.ui.AttributePlaceholder;
import org.eclipse.ptp.rm.pbs.ui.dialogs.ComboEntryDialog;
import org.eclipse.ptp.rm.pbs.ui.dialogs.ScrollingEditableMessageDialog;
import org.eclipse.ptp.rm.pbs.ui.providers.AttributeContentProvider;
import org.eclipse.ptp.rm.pbs.ui.providers.AttributeLabelProvider;
import org.eclipse.ptp.rm.pbs.ui.utils.ConfigurationUtils;
import org.eclipse.ptp.rm.pbs.ui.utils.WidgetUtils;
import org.eclipse.ptp.rm.ui.preferences.AbstractRemoteRMPreferencePage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.IWorkbench;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PBSPreferencePage
extends AbstractRemoteRMPreferencePage {
    private static final String FEATURE_PLUGIN = "org.eclipse.ptp.rm.pbs-feature";
    private static final String CONFIG_DIR = "attrconf";
    private static Map<String, AttributePlaceholder> selectedAttributes;
    private TemplateComboModifyListener comboListener;
    private CheckboxTableViewer preferences;
    private Map<String, AttributePlaceholder> templateAttributes;
    private Combo templates;

    public Preferences getPreferences() {
        return PBSPreferenceManager.getPreferences();
    }

    public void init(IWorkbench workbench) {
        this.templateAttributes = new TreeMap<String, AttributePlaceholder>();
    }

    public void performApply() {
        this.doApply();
    }

    public void performDefaults() {
        this.defaultSetting();
        this.updateApplyButton();
    }

    public boolean performOk() {
        this.savePreferences();
        return true;
    }

    public void savePreferences() {
        PBSPreferenceManager.setTemplatePreference((String)this.templates.getText().trim());
        StringBuffer selected = new StringBuffer();
        Map<String, Boolean> map = this.getSelectedFromTable();
        Iterator<Map.Entry<String, Boolean>> i = map.entrySet().iterator();
        while (i.hasNext()) {
            if (selected.length() > 0) {
                selected.append(",");
            }
            Map.Entry<String, Boolean> e = i.next();
            selected.append(e.getKey()).append("=").append(e.getValue());
        }
        PBSPreferenceManager.setSelectedAttributes((String)selected.toString());
        PBSPreferenceManager.savePreferences();
    }

    protected Control createContents(Composite parent) {
        Group templateContainer = WidgetUtils.createFillingGroup(parent, "ATTRIBUTE CONFIGURATION", 4, 1, false);
        this.comboListener = new TemplateComboModifyListener();
        this.templates = WidgetUtils.createItemCombo((Composite)templateContainer, "TYPE", this.getAvailableTemplates(), "", "Select a template for the attributes to be displayed", this.comboListener, 1);
        WidgetUtils.createButton((Composite)templateContainer, "Edit", null, 8, 1, new EditConfigurationSelectionAdapter());
        WidgetUtils.createButton((Composite)templateContainer, "Delete", null, 8, 1, new DeleteConfigurationSelectionAdapter());
        Group preferencesContainer = WidgetUtils.createFillingGroup(parent, "DISPLAY PBS ATTRIBUTES", 1, 1, false);
        Table t = WidgetUtils.createFillingTable((Composite)preferencesContainer, 2, 300, 1, 65570);
        this.preferences = new CheckboxTableViewer(t);
        this.preferences.setContentProvider((IContentProvider)new AttributeContentProvider());
        this.preferences.setLabelProvider((IBaseLabelProvider)new AttributeLabelProvider());
        WidgetUtils.addTableColumn((TableViewer)this.preferences, "NAME", 16384);
        WidgetUtils.addTableColumn((TableViewer)this.preferences, "TOOL TIP", 16384);
        this.preferences.getTable().setHeaderVisible(true);
        this.loadSaved(true);
        this.updatePreferencePage();
        return parent;
    }

    protected boolean isValidSetting() {
        return true;
    }

    protected void updatePreferencePage() {
        this.preferences.setInput(this.templateAttributes);
        this.setCheckedFromModel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doApply() {
        Class<PBSPreferencePage> clazz = PBSPreferencePage.class;
        synchronized (PBSPreferencePage.class) {
            if (selectedAttributes == null) {
                selectedAttributes = new TreeMap<String, AttributePlaceholder>();
            } else {
                selectedAttributes.clear();
            }
            selectedAttributes.putAll(this.templateAttributes);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private void fireModifyTemplateChoice(String choice) {
        this.loadTemplateAttributes(choice, this.templateAttributes);
        this.updateSelectedAttributes(this.getSelectedFromTable());
        this.updatePreferencePage();
    }

    private String[] getAvailableTemplates() {
        ArrayList<String> templateNames = new ArrayList<String>();
        try {
            File attrconf = this.getTemplateDir();
            ConfigurationUtils.SuffixFilter filter = new ConfigurationUtils.SuffixFilter(".properties");
            File[] properties = attrconf.listFiles(filter);
            int i = 0;
            while (i < properties.length) {
                templateNames.add(properties[i].getName());
                ++i;
            }
        }
        catch (URISyntaxException t) {
            t.printStackTrace();
        }
        return templateNames.toArray(new String[0]);
    }

    private Map<String, Boolean> getSelectedFromStore() {
        HashMap<String, Boolean> selected = new HashMap<String, Boolean>();
        String choices = PBSPreferenceManager.getSelectedAttributes();
        if (choices != null) {
            String[] properties = choices.split(",");
            int i = 0;
            while (i < properties.length) {
                String[] nvp = properties[i].split("=");
                Boolean v = nvp.length == 1 ? false : new Boolean(nvp[1]);
                selected.put(nvp[0], v);
                ++i;
            }
        }
        return selected;
    }

    private Map<String, Boolean> getSelectedFromTable() {
        HashMap<String, Boolean> selected = new HashMap<String, Boolean>();
        Object[] ap = this.preferences.getCheckedElements();
        if (ap != null) {
            int i = 0;
            while (i < ap.length) {
                AttributePlaceholder chosenAttr = (AttributePlaceholder)ap[i];
                chosenAttr.setChecked(true);
                selected.put(chosenAttr.getName(), true);
                ++i;
            }
        }
        return selected;
    }

    private File getTemplateDir() throws URISyntaxException {
        return new File(ConfigurationUtils.findFeatureDir(FEATURE_PLUGIN), CONFIG_DIR);
    }

    private void loadSaved(boolean display) {
        String choice = PBSPreferenceManager.getTemplatePreference();
        if (choice != null && display) {
            String[] items = this.templates.getItems();
            int i = 0;
            while (i < items.length) {
                if (choice.equals(items[i])) {
                    this.comboListener.toggleIgnore();
                    this.templates.select(i);
                    this.comboListener.toggleIgnore();
                    break;
                }
                ++i;
            }
        }
        this.loadTemplateAttributes(choice, this.templateAttributes);
        this.updateSelectedAttributes(this.getSelectedFromStore());
    }

    private String loadTemplateAttributes(String choice, Map<String, AttributePlaceholder> map) {
        if (choice == null) {
            map.clear();
            return "";
        }
        StringBuffer sb = new StringBuffer();
        String lineSeparator = System.getProperty("line.separator");
        try {
            File f = new File(this.getTemplateDir(), choice);
            if (!f.exists()) {
                return sb.toString();
            }
            Properties p = new Properties();
            p.load(new FileInputStream(f));
            TreeMap<Object, Object> sorted = new TreeMap<Object, Object>();
            sorted.putAll(p);
            if (map != null) {
                map.clear();
            }
            AttributePlaceholder ap = null;
            for (Map.Entry e : sorted.entrySet()) {
                String key = (String)e.getKey();
                String value = (String)e.getValue();
                ap = new AttributePlaceholder();
                ap.setName(key);
                ap.setToolTip(value);
                if (map != null) {
                    map.put(key, ap);
                    continue;
                }
                sb.append(key).append("=").append(value).append(lineSeparator);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return sb.toString();
    }

    private void setCheckedFromModel() {
        for (AttributePlaceholder ap : this.templateAttributes.values()) {
            this.preferences.setChecked((Object)ap, ap.getChecked());
        }
    }

    private void setCheckedOnModel(Map<String, Boolean> selected) {
        for (AttributePlaceholder attr : this.templateAttributes.values()) {
            Boolean chosen = selected.get(attr.getName());
            if (chosen != null && chosen.booleanValue()) {
                attr.setChecked(true);
                continue;
            }
            attr.setChecked(false);
        }
    }

    private void updateAvailableTemplates() {
        this.comboListener.toggleIgnore();
        String text = this.templates.getText();
        this.templates.setItems(this.getAvailableTemplates());
        this.templates.setText(text);
        this.comboListener.toggleIgnore();
    }

    private void updateSelectedAttributes(Map<String, Boolean> selected) {
        Map defs = PBSJobAttributes.getAttributeDefinitionMap();
        for (Map.Entry<String, AttributePlaceholder> e : this.templateAttributes.entrySet()) {
            String key = e.getKey();
            IAttributeDefinition def = (IAttributeDefinition)defs.get(key);
            if (def == null) continue;
            AttributePlaceholder ap = e.getValue();
            try {
                ap.setAttribute(def.create());
            }
            catch (IllegalValueException t) {
                t.printStackTrace();
            }
        }
        this.setCheckedOnModel(selected);
    }

    private void validateContents(String contents) throws Throwable {
        Map defs = PBSJobAttributes.getAttributeDefinitionMap();
        Properties p = new Properties();
        p.load(new ByteArrayInputStream(contents.getBytes()));
        for (String string : p.keySet()) {
            if (defs.containsKey(string)) continue;
            throw new NoSuchElementException("cannot find definition for " + string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, AttributePlaceholder> getSelectedAttributes() {
        Class<PBSPreferencePage> clazz = PBSPreferencePage.class;
        synchronized (PBSPreferencePage.class) {
            if (selectedAttributes == null) {
                PBSPreferencePage tempPage = new PBSPreferencePage();
                tempPage.init(null);
                tempPage.loadSaved(false);
                selectedAttributes = new TreeMap<String, AttributePlaceholder>();
                selectedAttributes.putAll(tempPage.templateAttributes);
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return selectedAttributes;
        }
    }

    private class DeleteConfigurationSelectionAdapter
    implements SelectionListener {
        private DeleteConfigurationSelectionAdapter() {
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.widgetSelected(e);
        }

        public void widgetSelected(SelectionEvent e) {
            try {
                Shell shell = PBSPreferencePage.this.getShell();
                String[] availableTemplates = PBSPreferencePage.this.getAvailableTemplates();
                ComboEntryDialog comboDialog = new ComboEntryDialog(shell, "Choose Configuration to Delete", availableTemplates);
                if (comboDialog.open() == 1) {
                    return;
                }
                String name = comboDialog.getChoice();
                File configFile = new File(PBSPreferencePage.this.getTemplateDir(), name);
                if (configFile.exists()) {
                    configFile.delete();
                }
                PBSPreferencePage.this.updateAvailableTemplates();
                if (name.equals(PBSPreferencePage.this.templates.getText())) {
                    PBSPreferencePage.this.comboListener.toggleIgnore();
                    PBSPreferencePage.this.templates.deselectAll();
                    PBSPreferencePage.this.comboListener.toggleIgnore();
                    PBSPreferencePage.this.fireModifyTemplateChoice(null);
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
                WidgetUtils.errorMessage(PBSPreferencePage.this.getShell(), t, "Cannot delete configuration: " + t.getMessage(), "DELETE ATTRIBUTE CONFIGURATION ERROR", false);
            }
        }
    }

    private class EditConfigurationSelectionAdapter
    implements SelectionListener {
        private EditConfigurationSelectionAdapter() {
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.widgetSelected(e);
        }

        public void widgetSelected(SelectionEvent e) {
            OutputStreamWriter fw = null;
            try {
                Shell shell = PBSPreferencePage.this.getShell();
                String newName = null;
                String oldName = null;
                String[] availableTemplates = PBSPreferencePage.this.getAvailableTemplates();
                ComboEntryDialog comboDialog = new ComboEntryDialog(shell, "EDIT/COPY CONFIGURATION", availableTemplates);
                if (comboDialog.open() == 1) {
                    return;
                }
                oldName = comboDialog.getChoice();
                InputDialog nameDialog = new InputDialog(shell, "NEW CONFIGURATION?", "Name [.properties]", null, null);
                if (nameDialog.open() == 1) {
                    newName = oldName;
                } else {
                    newName = nameDialog.getValue();
                    if (newName.length() == 0) {
                        throw new IllegalArgumentException("Click 'Cancel' to edit the same file, or provide a non-empty string as name");
                    }
                    if (!newName.endsWith(".properties")) {
                        newName = String.valueOf(newName) + ".properties";
                    }
                }
                String contents = PBSPreferencePage.this.loadTemplateAttributes(oldName, null);
                ScrollingEditableMessageDialog dialog = new ScrollingEditableMessageDialog(PBSPreferencePage.this.getShell(), "EDIT ATTRIBUTES", contents);
                if (dialog.open() == 1) {
                    return;
                }
                try {
                    contents = dialog.getValue();
                    PBSPreferencePage.this.validateContents(contents);
                    File configFile = new File(PBSPreferencePage.this.getTemplateDir(), newName);
                    if (configFile.exists()) {
                        configFile.delete();
                    }
                    fw = new FileWriter(configFile, false);
                    fw.write(dialog.getValue());
                    fw.flush();
                    PBSPreferencePage.this.updateAvailableTemplates();
                    if (newName.equals(PBSPreferencePage.this.templates.getText())) {
                        PBSPreferencePage.this.fireModifyTemplateChoice(newName);
                    }
                }
                catch (Throwable t) {
                    t.printStackTrace();
                    WidgetUtils.errorMessage(PBSPreferencePage.this.getShell(), t, "Cannot edit configuration: " + t.getMessage(), "EDIT ATTRIBUTE CONFIGURATION ERROR", false);
                }
            }
            finally {
                if (fw != null) {
                    try {
                        fw.close();
                    }
                    catch (IOException t) {
                        t.printStackTrace();
                    }
                }
            }
        }
    }

    private class TemplateComboModifyListener
    implements ModifyListener {
        private boolean ignore = false;

        private TemplateComboModifyListener() {
        }

        public void modifyText(ModifyEvent e) {
            if (!this.ignore()) {
                Combo source = (Combo)e.getSource();
                String choice = source.getText();
                PBSPreferencePage.this.fireModifyTemplateChoice(choice);
            }
        }

        private synchronized boolean ignore() {
            return this.ignore;
        }

        private synchronized void toggleIgnore() {
            this.ignore = !this.ignore;
        }
    }
}

