/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.pbs.ui.utils;

import java.io.File;
import java.io.FilenameFilter;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.service.datalocation.Location;

public class ConfigurationUtils {
    private static VersionSorter vs = new VersionSorter();

    private ConfigurationUtils() {
    }

    public static File findFeatureDir(String prefix) throws URISyntaxException {
        Location loc = Platform.getInstallLocation();
        File dir = new File(new URI(loc.getURL().toString()));
        PrefixFilter pf = new PrefixFilter(prefix);
        File[] features = (dir = new File(dir, "features")).listFiles(pf);
        if (features.length == 0) {
            return null;
        }
        Arrays.sort(features, vs);
        return features[0];
    }

    public static class PrefixFilter
    implements FilenameFilter {
        private final String prefix;

        public PrefixFilter(String prefix) {
            this.prefix = prefix;
        }

        public boolean accept(File dir, String name) {
            return name.startsWith(this.prefix);
        }
    }

    public static class SuffixFilter
    implements FilenameFilter {
        private final String suffix;

        public SuffixFilter(String suffix) {
            this.suffix = suffix;
        }

        public boolean accept(File dir, String name) {
            return name.endsWith(this.suffix);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class VersionSorter
    implements Comparator<File> {
        private VersionSorter() {
        }

        @Override
        public int compare(File s1, File s2) {
            return s1.getName().compareTo(s2.getName()) * -1;
        }
    }
}

