/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.pbs.ui.utils;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;

public class WidgetUtils {
    private WidgetUtils() {
    }

    public static TableColumn addTableColumn(TableViewer viewer, String columnName, int style) {
        Table t = viewer.getTable();
        TableColumn c = new TableColumn(t, style);
        c.setText(columnName);
        return c;
    }

    public static Button createButton(Composite parent, String buttonText, Image image, int style, int colSpan, SelectionListener l) {
        Button button = new Button(parent, style);
        button.setText(buttonText);
        if (image != null) {
            button.setImage(image);
        }
        if (l != null) {
            button.addSelectionListener(l);
        }
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.horizontalSpan = colSpan;
        button.setLayoutData((Object)data);
        return button;
    }

    public static Composite createComposite(Composite parent, int cols, int x, int y) {
        ScrolledComposite scroller = new ScrolledComposite(parent, 2816);
        scroller.setLayoutData((Object)new GridData(1808));
        scroller.setExpandHorizontal(true);
        scroller.setExpandVertical(true);
        Composite main = new Composite((Composite)scroller, 0);
        GridData data = new GridData(256);
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        data.horizontalSpan = 1;
        data.verticalAlignment = 16384;
        data.grabExcessVerticalSpace = false;
        main.setLayoutData((Object)data);
        GridLayout layout = new GridLayout();
        main.setLayout((Layout)layout);
        layout.numColumns = cols;
        layout.verticalSpacing = 1;
        scroller.setContent((Control)main);
        scroller.setMinSize(x, y);
        return main;
    }

    public static Composite createContainer(Composite parent, String name, boolean fill, int minHeight) {
        Group container = new Group(parent, 0);
        if (name != null) {
            container.setText(name);
        }
        GridData data = new GridData(256);
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        data.minimumHeight = minHeight;
        data.heightHint = minHeight;
        if (fill) {
            data.verticalAlignment = 4;
            data.grabExcessVerticalSpace = true;
        } else {
            data.verticalAlignment = 0x1000000;
        }
        container.setLayoutData((Object)data);
        GridLayout layout = new GridLayout();
        container.setLayout((Layout)layout);
        layout.numColumns = 1;
        layout.verticalSpacing = 9;
        return container;
    }

    public static Group createFillingGroup(Composite parent, String text, int columns, int colSpan, boolean verticalFill) {
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.verticalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = verticalFill;
        if (colSpan != -1) {
            data.horizontalSpan = colSpan;
        }
        GridLayout layout = new GridLayout();
        layout.numColumns = columns;
        layout.verticalSpacing = 9;
        Group group = new Group(parent, 32);
        if (text != null) {
            group.setText(text);
        }
        group.setLayout((Layout)layout);
        group.setLayoutData((Object)data);
        return group;
    }

    public static Table createFillingTable(Composite parent, int numColumns, int suggestedWidth, int colSpan, int tableStyle) {
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.verticalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = true;
        data.widthHint = 200;
        data.horizontalSpan = colSpan;
        data.heightHint = 150;
        Table t = new Table(parent, tableStyle);
        t.setHeaderVisible(true);
        t.setLinesVisible(true);
        t.setLayoutData((Object)data);
        TableLayout layout = new TableLayout();
        int i = 0;
        while (i < numColumns) {
            layout.addColumnData((ColumnLayoutData)new ColumnPixelData(suggestedWidth / numColumns));
            ++i;
        }
        t.setLayout((Layout)layout);
        return t;
    }

    public static Combo createItemCombo(Composite container, String labelString, String[] items, String initial, String tooltip, ModifyListener listener, int colSpan) {
        if (labelString != null) {
            Label label = new Label(container, 0);
            label.setText(labelString);
            if (tooltip != null) {
                label.setToolTipText(tooltip);
            }
        }
        GridData data = new GridData(768);
        data.horizontalSpan = colSpan;
        Combo combo = new Combo(container, 2048);
        combo.setItems(items);
        combo.setLayoutData((Object)data);
        if (initial != null) {
            combo.setText(initial);
        }
        if (listener != null) {
            combo.addModifyListener(listener);
        }
        return combo;
    }

    public static Label createLabel(Composite container, String text, int style, int colSpan) {
        GridData data = new GridData();
        data.horizontalSpan = colSpan;
        Label label = new Label(container, style);
        if (text == null) {
            text = "";
        }
        label.setText(text.trim());
        label.setLayoutData((Object)data);
        return label;
    }

    public static Text createLabelledText(Composite container, String labelString, String initialValue, int colSpan, ModifyListener listener, Color color) {
        Label label = new Label(container, 0);
        label.setText(labelString);
        if (color != null) {
            label.setBackground(color);
        }
        GridData data = new GridData(768);
        data.horizontalSpan = colSpan;
        Text text = new Text(container, 2048);
        if (color != null) {
            text.setBackground(color);
        }
        text.setLayoutData((Object)data);
        if (initialValue != null) {
            text.setText(initialValue);
        }
        if (listener != null) {
            text.addModifyListener(listener);
        }
        return text;
    }

    public static Spinner createSpinner(Composite container, String labelString, int min, int max, int initial, int colSpan, ModifyListener listener) {
        GridData data;
        if (labelString != null) {
            data = new GridData();
            Label label = new Label(container, 0);
            label.setText(labelString);
            label.setLayoutData((Object)data);
        }
        data = new GridData(768);
        data.horizontalSpan = colSpan;
        Spinner s = new Spinner(container, 0);
        s.setMaximum(max);
        s.setMinimum(min);
        s.setSelection(initial);
        s.setLayoutData((Object)data);
        if (listener != null) {
            s.addModifyListener(listener);
        }
        return s;
    }

    public static Text createText(Composite container, String initialValue, ModifyListener listener, Color color) {
        GridData data = new GridData(768);
        Text text = new Text(container, 2048);
        if (color != null) {
            text.setBackground(color);
        }
        text.setLayoutData((Object)data);
        if (initialValue != null) {
            text.setText(initialValue);
        }
        if (listener != null) {
            text.addModifyListener(listener);
        }
        return text;
    }

    public static void errorMessage(Shell s, Throwable e, String message, String title, boolean causeTrace) {
        Throwable t = e.getCause();
        String lineSep = System.getProperty("line.separator");
        String append = "";
        if (causeTrace) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            if (t != null) {
                t.printStackTrace(pw);
                append = sw.toString();
            }
        } else if (t != null) {
            append = t.getMessage();
        }
        MessageDialog.openError((Shell)s, (String)title, (String)(String.valueOf(message) + lineSep + e.getMessage() + lineSep + append));
    }
}

