/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.pbs.ui.wizards;

import java.util.Map;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.ptp.core.attributes.BooleanAttribute;
import org.eclipse.ptp.core.attributes.IAttribute;
import org.eclipse.ptp.core.attributes.IntegerAttribute;
import org.eclipse.ptp.rm.pbs.ui.AttributePlaceholder;
import org.eclipse.ptp.rm.pbs.ui.messages.Messages;
import org.eclipse.ptp.rm.pbs.ui.preferences.PBSPreferencePage;
import org.eclipse.ptp.rm.pbs.ui.utils.WidgetUtils;
import org.eclipse.ptp.rm.ui.launch.RMLaunchConfigurationDynamicTabWidgetListener;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DynamicTabWizardPage
extends WizardPage {
    private static final Color DKBL = Display.getDefault().getSystemColor(10);
    private static final Color DKMG = Display.getDefault().getSystemColor(12);
    private static final Color DKRD = Display.getDefault().getSystemColor(4);
    private final RMLaunchConfigurationDynamicTabWidgetListener listener;
    private final Map<Control, AttributePlaceholder> valueWidgets;

    public DynamicTabWizardPage(Map<Control, AttributePlaceholder> valueWidgets, RMLaunchConfigurationDynamicTabWidgetListener listener) {
        super("");
        this.valueWidgets = valueWidgets;
        this.listener = listener;
    }

    public void createControl(Composite parent) {
        Composite container = WidgetUtils.createComposite(parent, 6, 110, 200);
        WidgetUtils.createLabel(container, Messages.DynamicTabWizardPage_ATTRIBUTE, 16384, 1).setForeground(DKMG);
        WidgetUtils.createLabel(container, Messages.DynamicTabWizardPage_DESCRIPTION, 16384, 2).setForeground(DKMG);
        WidgetUtils.createLabel(container, Messages.DynamicTabWizardPage_TOOLTIP, 16384, 2).setForeground(DKMG);
        WidgetUtils.createLabel(container, Messages.DynamicTabWizardPage_VALUE, 16384, 1).setForeground(DKMG);
        for (AttributePlaceholder ap : PBSPreferencePage.getSelectedAttributes().values()) {
            if (!ap.getChecked()) continue;
            IAttribute<?, ?, ?> attr = ap.getAttribute();
            String name = ap.getName();
            String descr = attr.getDefinition().getDescription();
            String toolTip = ap.getToolTip();
            WidgetUtils.createLabel(container, name, 16384, 1);
            WidgetUtils.createLabel(container, descr, 16384, 2).setForeground(DKBL);
            WidgetUtils.createLabel(container, toolTip, 16384, 2).setForeground(DKBL);
            this.valueWidgets.put(this.getValueWidget(container, attr), ap);
        }
        this.setControl((Control)container);
    }

    private Control getValueWidget(Composite container, IAttribute<?, ?, ?> attr) {
        String name = attr.getDefinition().getName();
        String value = attr.getValueAsString();
        Object c = null;
        if (attr instanceof BooleanAttribute) {
            Button b = WidgetUtils.createButton(container, name, null, 32, 1, (SelectionListener)this.listener);
            if ("true".equals(value)) {
                b.setSelection(true);
            }
            c = b;
        } else {
            c = attr instanceof IntegerAttribute ? WidgetUtils.createSpinner(container, null, 1, Integer.MAX_VALUE, Integer.parseInt(value), 1, (ModifyListener)this.listener) : WidgetUtils.createText(container, value, (ModifyListener)this.listener, null);
        }
        c.setForeground(DKRD);
        return c;
    }
}

