/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.ui.preferences;

import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ptp.rm.ui.preferences.PreferenceDataSource;
import org.eclipse.ptp.rm.ui.preferences.PreferenceWidgetListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public abstract class AbstractPreferencePage
extends PreferencePage {
    private final PreferenceWidgetListener listener = this.createListener();
    private final PreferenceDataSource dataSource = this.createDataSource();

    public AbstractPreferencePage() {
    }

    public AbstractPreferencePage(String title) {
        super(title);
    }

    public AbstractPreferencePage(String title, ImageDescriptor image) {
        super(title, image);
    }

    protected PreferenceWidgetListener getListener() {
        return this.listener;
    }

    protected PreferenceDataSource getDataSource() {
        return this.dataSource;
    }

    public abstract Preferences getPreferences();

    public abstract void savePreferences();

    protected abstract PreferenceWidgetListener createListener();

    protected abstract PreferenceDataSource createDataSource();

    public boolean performOk() {
        this.resetErrorMessages();
        this.dataSource.storeAndValidate();
        return true;
    }

    protected void performDefaults() {
        this.resetErrorMessages();
        this.listener.disable();
        this.dataSource.loadDefaultsAndUpdate();
        this.listener.enable();
    }

    protected void performApply() {
        this.resetErrorMessages();
        this.dataSource.storeAndValidate();
    }

    protected void resetErrorMessages() {
        this.setErrorMessage(null);
        this.setMessage(null);
        this.setValid(true);
    }

    protected Control createContents(Composite parent) {
        this.listener.disable();
        Composite contents = this.doCreateContents(parent);
        this.resetErrorMessages();
        this.dataSource.loadAndUpdate();
        this.listener.enable();
        this.updateControls();
        return contents;
    }

    protected abstract void updateControls();

    protected abstract Composite doCreateContents(Composite var1);
}

