/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.core.analysis.binding;

import java.util.List;
import org.eclipse.photran.internal.core.analysis.binding.BindingCollector;
import org.eclipse.photran.internal.core.analysis.binding.Definition;
import org.eclipse.photran.internal.core.analysis.binding.ScopingNode;
import org.eclipse.photran.internal.core.parser.ASTAccessStmtNode;
import org.eclipse.photran.internal.core.parser.ASTGenericNameNode;
import org.eclipse.photran.internal.core.parser.IAccessId;
import org.eclipse.photran.internal.core.parser.Parser;
import org.eclipse.photran.internal.core.vpg.PhotranTokenRef;

public abstract class VisibilityCollector
extends BindingCollector {
    public void visitASTAccessStmtNode(ASTAccessStmtNode node) {
        super.traverseChildren(node);
        Parser.IASTListNode<IAccessId> list = node.getAccessIdList();
        if (list == null) {
            return;
        }
        ScopingNode enclosingScope = node.findNearestAncestor(ScopingNode.class);
        int i = 0;
        while (i < list.size()) {
            if (list.get(i) instanceof ASTGenericNameNode) {
                List<PhotranTokenRef> bindings = this.bindNoImplicits(((ASTGenericNameNode)list.get(i)).getGenericName());
                try {
                    for (PhotranTokenRef tr : bindings) {
                        Definition def = this.vpg.getDefinitionFor(tr);
                        def.setVisibility(node.getAccessSpec(), enclosingScope);
                        this.vpg.setDefinitionFor(tr, def);
                    }
                }
                catch (Exception e) {
                    throw new Error(e);
                }
            }
            ++i;
        }
    }
}

