/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.core.analysis.dependence;

import java.util.ArrayList;
import org.eclipse.photran.internal.core.analysis.dependence.VariableReference;
import org.eclipse.photran.internal.core.analysis.loops.ASTProperLoopConstructNode;
import org.eclipse.photran.internal.core.parser.ASTIntConstNode;
import org.eclipse.photran.internal.core.parser.IExecutionPartConstruct;
import org.eclipse.photran.internal.core.parser.IExpr;
import org.eclipse.photran.internal.core.parser.Parser;
import org.eclipse.photran.internal.core.vpg.PhotranVPG;
import org.eclipse.rephraserengine.core.analysis.dependence.DependenceTestFailure;
import org.eclipse.rephraserengine.core.analysis.dependence.Direction;
import org.eclipse.rephraserengine.core.analysis.dependence.IDependenceTester;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PerfectLoopNest {
    private ArrayList<ASTProperLoopConstructNode> loopNest;
    private int n;
    private int[] L;
    private int[] U;

    public PerfectLoopNest(ASTProperLoopConstructNode perfectLoopNest) {
        this.constructLoopNest(perfectLoopNest);
        this.n = this.loopNest.size();
        this.setBounds();
    }

    private void setBounds() {
        this.L = new int[this.n];
        this.U = new int[this.n];
        int i = 0;
        while (i < this.n) {
            this.L[i] = this.lb(this.loopNest.get(i));
            this.U[i] = this.ub(this.loopNest.get(i));
            ++i;
        }
    }

    private void constructLoopNest(ASTProperLoopConstructNode perfectLoopNest) {
        this.loopNest = new ArrayList();
        ASTProperLoopConstructNode thisLoop = perfectLoopNest;
        do {
            this.loopNest.add(thisLoop);
        } while ((thisLoop = thisLoop.getBody().size() == 1 && thisLoop.getBody().get(0) instanceof ASTProperLoopConstructNode ? (ASTProperLoopConstructNode)thisLoop.getBody().get(0) : null) != null);
    }

    private int lb(ASTProperLoopConstructNode loop) {
        return this.intConstValueOr(Integer.MIN_VALUE, loop.getLoopHeader().getLoopControl().getLb());
    }

    private int ub(ASTProperLoopConstructNode loop) {
        return this.intConstValueOr(Integer.MAX_VALUE, loop.getLoopHeader().getLoopControl().getUb());
    }

    private int intConstValueOr(int defaultValue, IExpr expr) {
        if (expr instanceof ASTIntConstNode) {
            return Integer.parseInt(((ASTIntConstNode)expr).getIntConst().getText());
        }
        return defaultValue;
    }

    public ASTProperLoopConstructNode outermostLoop() {
        return this.loopNest.get(0);
    }

    public ASTProperLoopConstructNode innermostLoop() {
        return this.loopNest.get(this.loopNest.size() - 1);
    }

    public Parser.IASTListNode<IExecutionPartConstruct> getBody() {
        return this.innermostLoop().getBody();
    }

    public int getNumberOfLoops() {
        return this.loopNest.size();
    }

    public boolean containsDoWhileLoops() {
        int i = 0;
        while (i < this.loopNest.size()) {
            if (this.loopNest.get(i).isDoWhileLoop()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public String getIndexVariable(int i) {
        if (i <= 0 || i > this.getNumberOfLoops()) {
            throw new IllegalArgumentException("Cannot retrieve index variable for loop " + i + " in a " + this.getNumberOfLoops() + "-loop nest");
        }
        ASTProperLoopConstructNode targetLoop = this.loopNest.get(i - 1);
        if (targetLoop.isDoWhileLoop()) {
            return null;
        }
        return PhotranVPG.canonicalizeIdentifier(targetLoop.getIndexVariable().getText());
    }

    public boolean testForDependenceUsing(IDependenceTester[] testers, VariableReference from, VariableReference to, Direction[] direction) {
        int[] a = this.coefficients(from);
        int[] b = this.coefficients(to);
        IDependenceTester.Result result = IDependenceTester.Result.POSSIBLE_DEPENDENCE;
        IDependenceTester[] iDependenceTesterArray = testers;
        int n = testers.length;
        int n2 = 0;
        while (n2 < n) {
            IDependenceTester test = iDependenceTesterArray[n2];
            result = test.test(this.n, this.L, this.U, a, b, direction);
            if (result.isDefinite()) break;
            ++n2;
        }
        return result.dependenceMightExist();
    }

    private int[] coefficients(VariableReference var) {
        if (var.indices.length > 1) {
            throw new DependenceTestFailure("Only single subscripts are currently supported");
        }
        VariableReference.LinearFunction fn = var.indices[0];
        int targetLoop = this.loopWithIndexVariable(fn.variable);
        if (targetLoop == 0) {
            throw new DependenceTestFailure("Linear function of non-index variable");
        }
        int[] result = new int[this.n + 1];
        result[0] = fn.y_intercept;
        result[targetLoop] = fn.slope;
        return result;
    }

    private int loopWithIndexVariable(String variable) {
        int i = 1;
        while (i <= this.n) {
            if (variable.equals(this.getIndexVariable(i))) {
                return i;
            }
            ++i;
        }
        return 0;
    }
}

