/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.core.lexer;

import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.photran.internal.core.FortranCorePlugin;
import org.eclipse.photran.internal.core.lexer.ASTTokenFactory;
import org.eclipse.photran.internal.core.lexer.FixedFormLexerPhase2;
import org.eclipse.photran.internal.core.lexer.FreeFormLexerPhase1;
import org.eclipse.photran.internal.core.lexer.FreeFormLexerPhase2;
import org.eclipse.photran.internal.core.lexer.IAccumulatingLexer;
import org.eclipse.photran.internal.core.lexer.ILexer;
import org.eclipse.photran.internal.core.lexer.LexerPhase3;
import org.eclipse.photran.internal.core.lexer.TokenFactory;
import org.eclipse.photran.internal.core.lexer.preprocessor.fortran_include.IncludeLoaderCallback;
import org.eclipse.photran.internal.core.lexer.preprocessor.fortran_include.PreprocessingFreeFormLexerPhase1;

public abstract class SourceForm {
    public static final SourceForm UNPREPROCESSED_FREE_FORM = new SourceForm(){

        public IAccumulatingLexer createLexer(InputStream in, IFile file, String filename, boolean accumulateWhitetext) throws IOException {
            return new LexerPhase3((ILexer)new FreeFormLexerPhase2((ILexer)new FreeFormLexerPhase1(in, file, filename, (TokenFactory)ASTTokenFactory.getInstance(), accumulateWhitetext)));
        }

        public String getDescription(String filename) {
            return "Free Form";
        }
    };
    public static final SourceForm FIXED_FORM = new SourceForm(){

        public IAccumulatingLexer createLexer(InputStream in, IFile file, String filename, boolean accumulateWhitetext) throws IOException {
            return new LexerPhase3((ILexer)new FixedFormLexerPhase2(in, file, filename, (TokenFactory)ASTTokenFactory.getInstance()));
        }

        public String getDescription(String filename) {
            return "Fixed Form";
        }
    };
    public static final SourceForm AUTO_DETECT_SOURCE_FORM = UNPREPROCESSED_FREE_FORM;
    public static final String SOURCE_FORM_EXTENSION_POINT_ID = "org.eclipse.photran.core.vpg.sourceform";

    protected SourceForm() {
    }

    public abstract IAccumulatingLexer createLexer(InputStream var1, IFile var2, String var3, boolean var4) throws IOException;

    public abstract String getDescription(String var1);

    public static SourceForm preprocessedFreeForm(final IncludeLoaderCallback callback) {
        return new SourceForm(){

            public IAccumulatingLexer createLexer(InputStream in, IFile file, String filename, boolean accumulateWhitetext) throws IOException {
                SourceForm sf = SourceForm.findPreferredSourceForm(filename);
                if (sf != null) {
                    return sf.createLexer(in, file, filename, accumulateWhitetext);
                }
                return new LexerPhase3((ILexer)new FreeFormLexerPhase2((ILexer)new PreprocessingFreeFormLexerPhase1(in, file, filename, callback, accumulateWhitetext)));
            }

            public String getDescription(String filename) {
                SourceForm sf = SourceForm.findPreferredSourceForm(filename);
                if (sf != null) {
                    return sf.getDescription(filename);
                }
                return "Free Form";
            }
        };
    }

    private static SourceForm findPreferredSourceForm(String filename) {
        IContentType ct;
        block5: {
            ct = FortranCorePlugin.findContentType((String)filename);
            if (ct != null) break block5;
            return null;
        }
        try {
            IConfigurationElement[] configs = Platform.getExtensionRegistry().getConfigurationElementsFor(SOURCE_FORM_EXTENSION_POINT_ID);
            int i = 0;
            while (i < configs.length) {
                if (configs[i].getAttribute("contentType").equals(ct.getId())) {
                    return (SourceForm)configs[i].createExecutableExtension("class");
                }
                ++i;
            }
            return null;
        }
        catch (CoreException e) {
            e.printStackTrace();
            return null;
        }
    }
}

