/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.core.vpg;

import java.io.PrintStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeSet;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.photran.core.IFortranAST;
import org.eclipse.photran.internal.core.FortranCorePlugin;
import org.eclipse.photran.internal.core.analysis.binding.Definition;
import org.eclipse.photran.internal.core.analysis.binding.ScopingNode;
import org.eclipse.photran.internal.core.analysis.types.Type;
import org.eclipse.photran.internal.core.lexer.Token;
import org.eclipse.photran.internal.core.parser.ASTExecutableProgramNode;
import org.eclipse.photran.internal.core.parser.ASTExternalNameListNode;
import org.eclipse.photran.internal.core.parser.ASTExternalStmtNode;
import org.eclipse.photran.internal.core.parser.ASTFunctionStmtNode;
import org.eclipse.photran.internal.core.parser.ASTFunctionSubprogramNode;
import org.eclipse.photran.internal.core.parser.ASTSubroutineStmtNode;
import org.eclipse.photran.internal.core.parser.ASTSubroutineSubprogramNode;
import org.eclipse.photran.internal.core.parser.IProgramUnit;
import org.eclipse.photran.internal.core.parser.Parser;
import org.eclipse.photran.internal.core.preferences.FortranPreferences;
import org.eclipse.photran.internal.core.properties.SearchPathProperties;
import org.eclipse.photran.internal.core.util.LRUCache;
import org.eclipse.photran.internal.core.vpg.PhotranTokenRef;
import org.eclipse.photran.internal.core.vpg.PhotranVPGBuilder;
import org.eclipse.photran.internal.core.vpg.PhotranVPGDB;
import org.eclipse.photran.internal.core.vpg.PhotranVPGLog;
import org.eclipse.rephraserengine.core.vpg.VPGDB;
import org.eclipse.rephraserengine.core.vpg.VPGLog;
import org.eclipse.rephraserengine.core.vpg.eclipse.EclipseVPG;
import org.eclipse.rephraserengine.core.vpg.eclipse.EclipseVPGLog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PhotranVPG
extends EclipseVPG<IFortranAST, Token, PhotranTokenRef, PhotranVPGDB, PhotranVPGLog> {
    private static final int MODULE_SYMTAB_CACHE_SIZE = 5;
    public static final int DEFINED_IN_SCOPE_EDGE_TYPE = 0;
    public static final int BINDING_EDGE_TYPE = 2;
    public static final int RENAMED_BINDING_EDGE_TYPE = 3;
    public static final int DEFINITION_IS_PRIVATE_IN_SCOPE_EDGE_TYPE = 4;
    public static final int ILLEGAL_SHADOWING_EDGE_TYPE = 5;
    private static final String[] edgeTypeDescriptions = new String[]{"Definition-scope relationship", "Definition-scope relationship due to module import", "Name binding", "Renamed binding", "Definition is private in scope", "Illegal shadowing"};
    public static final int SCOPE_DEFAULT_VISIBILITY_IS_PRIVATE_ANNOTATION_TYPE = 0;
    public static final int SCOPE_IS_INTERNAL_ANNOTATION_TYPE = 1;
    public static final int SCOPE_IMPLICIT_SPEC_ANNOTATION_TYPE = 2;
    public static final int DEFINITION_ANNOTATION_TYPE = 3;
    public static final int TYPE_ANNOTATION_TYPE = 4;
    public static final int MODULE_TOKENREF_ANNOTATION_TYPE = 5;
    public static final int MODULE_SYMTAB_ENTRY_COUNT_ANNOTATION_TYPE = 6;
    public static final int MODULE_SYMTAB_ENTRY_ANNOTATION_TYPE = 7;
    private static final String[] annotationTypeDescriptions = new String[]{"Default visibility for scope is private", "Scope is internal", "Implicit spec for scope", "Definition", "Type", "Module TokenRef", "Module symbol table entry count", "Module symbol table entry"};
    private static PhotranVPG instance = null;
    public PhotranVPGDB db = null;
    protected Parser parser = new Parser();
    protected LRUCache<String, List<Definition>> moduleSymTabCache = new LRUCache(5);
    protected long moduleSymTabCacheHits = 0L;
    protected long moduleSymTabCacheMisses = 0L;
    private List<IMarker> errorLogMarkers = null;
    private boolean isDefinitionCachingEnabled = false;

    public static PhotranVPG getInstance() {
        if (instance == null) {
            instance = FortranPreferences.ENABLE_VPG_LOGGING.getValue() ? new PhotranVPGBuilder(){

                public void debug(String message, String filename) {
                    System.out.println(String.valueOf(message) + " - " + 1.lastSegmentOfFilename((String)filename));
                }
            } : new PhotranVPGBuilder();
        }
        return instance;
    }

    public static PhotranVPGDB getDatabase() {
        return PhotranVPG.getInstance().db;
    }

    public void debug(String message, String filename) {
    }

    protected void debug(long parseTimeMillisec, long computeEdgesAndAnnotationsMillisec, String filename) {
    }

    public void start() {
        if (!FortranCorePlugin.inTestingMode()) {
            super.start();
        }
    }

    protected PhotranVPG() {
        super((EclipseVPGLog)new PhotranVPGLog(), (VPGDB)new PhotranVPGDB(), "Photran indexer", 2);
        this.db = (PhotranVPGDB)((EclipseVPG)this).db;
    }

    public String describeEdgeType(int edgeType) {
        return edgeTypeDescriptions[edgeType];
    }

    public String describeAnnotationType(int annotationType) {
        return annotationTypeDescriptions[annotationType];
    }

    protected String describeToken(String filename, int offset, int length) {
        block4: {
            try {
                if (offset != -1 || length != 0) break block4;
                return "global scope";
            }
            catch (Exception exception) {
                return this.db.describeToken(filename, offset, length);
            }
        }
        Token token = ((IFortranAST)this.acquireTransientAST(filename)).findTokenByStreamOffsetLength(offset, length);
        if (token == null) {
            return this.db.describeToken(filename, offset, length);
        }
        return String.valueOf(token.getText()) + " (offset " + offset + ")";
    }

    public Token findToken(PhotranTokenRef tokenRef) {
        IFortranAST ast = (IFortranAST)this.acquireTransientAST(tokenRef.getFilename());
        if (ast == null) {
            return null;
        }
        return ast.findTokenByStreamOffsetLength(tokenRef.getOffset(), tokenRef.getLength());
    }

    public boolean shouldProcessFile(IFile file) {
        String filename = file.getName();
        return FortranCorePlugin.hasFixedFormContentType((String)filename) || FortranCorePlugin.hasFreeFormContentType((String)filename) || FortranCorePlugin.hasCppFixedFormContentType((String)filename) || FortranCorePlugin.hasCppFreeFormContentType((String)filename);
    }

    public boolean shouldProcessProject(IProject project) {
        block5: {
            block4: {
                try {
                    if (project.isAccessible()) break block4;
                    return false;
                }
                catch (CoreException e) {
                    throw new Error(e);
                }
            }
            if (project.hasNature("org.eclipse.cdt.core.cnature") || project.hasNature("org.eclipse.cdt.core.ccnature")) break block5;
            return false;
        }
        return FortranCorePlugin.inTestingMode() || SearchPathProperties.getProperty(project, "EnableVPG").equals("true");
    }

    public String describeWhyCannotProcessProject(IProject project) {
        try {
            if (!project.isAccessible()) {
                return "The project " + project.getName() + " is not accessible.  " + "Please make sure that it is open and that the permissions are set correctly.";
            }
            if (!project.hasNature("org.eclipse.cdt.core.cnature") && !project.hasNature("org.eclipse.cdt.core.ccnature")) {
                return "The project " + project.getName() + " is not a Fortran, C, or C++ project.  " + "Plase convert it to a Fortran, C, or C++ project and enable analysis and " + "refactoring in the project properties.";
            }
            if (!SearchPathProperties.getProperty(project, "EnableVPG").equals("true")) {
                return "Please enable analysis and refactoring in the project properties for " + project.getName() + ".";
            }
            return null;
        }
        catch (CoreException e) {
            throw new Error(e);
        }
    }

    public String describeWhyCannotProcessFile(IFile file) {
        if (file.getProject() == null) {
            return "The file " + file.getName() + " is not located in a Fortran, C, or C++ project.";
        }
        if (!this.shouldProcessProject(file.getProject())) {
            return this.describeWhyCannotProcessProject(file.getProject());
        }
        if (!this.shouldProcessFile(file)) {
            return "The file " + file.getName() + "'s filename extension (" + file.getFileExtension() + ") indicates that this is not a Fortran source file.\n\nIf you believe that this " + "is incorrect, please see the Photran User's Guide for instructions on how to " + "change the file's content type in the workbench preferences.";
        }
        return null;
    }

    protected PhotranTokenRef getTokenRef(Token forToken) {
        return forToken.getTokenRef();
    }

    public static String canonicalizeIdentifier(String identifier) {
        return identifier.trim().toLowerCase().replaceAll("[ \t\r\n]", "");
    }

    private List<IFile> getOutgoingDependenciesFrom(String targetFilename) {
        LinkedList<IFile> files = new LinkedList<IFile>();
        for (String filename : this.db.getOutgoingDependenciesFrom(targetFilename)) {
            IFile file = PhotranVPG.getIFileForFilename((String)filename);
            if (file == null) continue;
            files.add(file);
        }
        return files;
    }

    private List<IFile> getIncomingDependenciesTo(String targetFilename) {
        LinkedList<IFile> files = new LinkedList<IFile>();
        for (String filename : this.db.getIncomingDependenciesTo(targetFilename)) {
            files.add(PhotranVPG.getIFileForFilename((String)filename));
        }
        return files;
    }

    public ArrayList<Definition> findAllExternalSubprogramsNamed(String name) {
        ArrayList<Definition> result = new ArrayList<Definition>();
        for (IFile file : this.findFilesThatExportSubprogram(name)) {
            result.addAll(this.findSubprograms(name, file));
        }
        return result;
    }

    private ArrayList<Definition> findSubprograms(String name, IFile file) {
        ArrayList<Definition> result = new ArrayList<Definition>();
        String cname = PhotranVPG.canonicalizeIdentifier(name);
        IFortranAST ast = (IFortranAST)this.acquireTransientAST(file);
        if (ast != null) {
            ASTExecutableProgramNode node = ast.getRoot();
            for (IProgramUnit pu : node.getProgramUnitList()) {
                Definition d;
                PhotranTokenRef tr = this.attemptToMatch(cname, pu);
                if (tr == null || (d = this.getDefinitionFor(tr)) == null) continue;
                result.add(d);
            }
        }
        return result;
    }

    private PhotranTokenRef attemptToMatch(String cname, IProgramUnit pu) {
        if (pu instanceof ASTSubroutineSubprogramNode) {
            return this.attemptToMatch(cname, ((ASTSubroutineSubprogramNode)pu).getSubroutineStmt());
        }
        if (pu instanceof ASTFunctionSubprogramNode) {
            return this.attemptToMatch(cname, ((ASTFunctionSubprogramNode)pu).getFunctionStmt());
        }
        return null;
    }

    private PhotranTokenRef attemptToMatch(String cname, ASTSubroutineStmtNode functionStmt) {
        return this.attemptToMatch(cname, functionStmt.getSubroutineName().getSubroutineName());
    }

    private PhotranTokenRef attemptToMatch(String cname, ASTFunctionStmtNode functionStmt) {
        return this.attemptToMatch(cname, functionStmt.getFunctionName().getFunctionName());
    }

    private PhotranTokenRef attemptToMatch(String cname, Token nameToken) {
        String thisSub = PhotranVPG.canonicalizeIdentifier(nameToken.getText());
        if (thisSub.equals(cname)) {
            return nameToken.getTokenRef();
        }
        return null;
    }

    public ArrayList<Definition> findAllDeclarationsInInterfacesForExternalSubprogram(String name) {
        ArrayList<Definition> result = new ArrayList<Definition>();
        for (IFile file : this.findFilesThatImportSubprogram(name)) {
            result.addAll(this.findInterfaceSubprograms(name, file));
        }
        return result;
    }

    private ArrayList<Definition> findInterfaceSubprograms(String name, IFile file) {
        ArrayList<Definition> result = new ArrayList<Definition>();
        IFortranAST ast = (IFortranAST)this.acquireTransientAST(file);
        if (ast != null) {
            ast.accept(new InterfaceVisitor(result, PhotranVPG.canonicalizeIdentifier(name)));
        }
        return result;
    }

    public ArrayList<Definition> findAllDeclarationsInExternalStmts(String name) {
        ArrayList<Definition> result = new ArrayList<Definition>();
        for (IFile file : this.findFilesThatImportSubprogram(name)) {
            result.addAll(this.findExternalStmts(name, file));
        }
        return result;
    }

    private ArrayList<Definition> findExternalStmts(String name, IFile file) {
        ArrayList<Definition> result = new ArrayList<Definition>();
        IFortranAST ast = (IFortranAST)this.acquireTransientAST(file);
        if (ast != null) {
            ast.accept(new ExternalStmtVisitor(result, PhotranVPG.canonicalizeIdentifier(name)));
        }
        return result;
    }

    public List<IFile> findFilesThatExportSubprogram(String subprogramName) {
        return this.getOutgoingDependenciesFrom("subprogram:" + PhotranVPG.canonicalizeIdentifier(subprogramName));
    }

    public List<IFile> findFilesThatImportSubprogram(String subprogramName) {
        return this.getIncomingDependenciesTo("subprogram:" + PhotranVPG.canonicalizeIdentifier(subprogramName));
    }

    public List<IFile> findFilesThatExportModule(String moduleName) {
        return this.getOutgoingDependenciesFrom("module:" + PhotranVPG.canonicalizeIdentifier(moduleName));
    }

    public List<IFile> findFilesThatUseCommonBlock(String commonBlockName) {
        if (commonBlockName == null) {
            commonBlockName = "";
        }
        return this.getIncomingDependenciesTo("common:" + PhotranVPG.canonicalizeIdentifier(commonBlockName));
    }

    public Iterable<String> listAllModules() {
        return this.listAllStartingWith("module:");
    }

    public Iterable<String> listAllSubprograms() {
        return this.listAllStartingWith("subprogram:");
    }

    public Iterable<String> listAllCommonBlocks() {
        return this.listAllStartingWith("common:");
    }

    private Iterable<String> listAllStartingWith(String prefix) {
        TreeSet<String> result = new TreeSet<String>();
        for (String name : this.db.listAllDependentFilenames()) {
            if (!name.startsWith(prefix)) continue;
            result.add(name.substring(prefix.length()));
        }
        return result;
    }

    public Definition getDefinitionFor(PhotranTokenRef tokenRef) {
        return (Definition)this.db.getAnnotation(tokenRef, 3);
    }

    public Type getTypeFor(PhotranTokenRef tokenRef) {
        return (Type)this.db.getAnnotation(tokenRef, 4);
    }

    public Definition.Visibility getVisibilityFor(Definition def, ScopingNode visibilityInScope) {
        PhotranTokenRef targetScope = visibilityInScope.getRepresentativeToken();
        for (PhotranTokenRef privateScope : this.db.getOutgoingEdgeTargets(def.getTokenRef(), 4)) {
            if (!privateScope.equals(targetScope)) continue;
            return Definition.Visibility.PRIVATE;
        }
        return Definition.Visibility.PUBLIC;
    }

    public PhotranTokenRef getModuleTokenRef(String moduleName) {
        String filename = "module:" + PhotranVPG.canonicalizeIdentifier(moduleName);
        PhotranTokenRef tokenRef = (PhotranTokenRef)this.createTokenRef(filename, 0, 0);
        return (PhotranTokenRef)this.db.getAnnotation(tokenRef, 5);
    }

    public List<Definition> getModuleSymbolTable(String moduleName) {
        if (this.moduleSymTabCache.contains(moduleName)) {
            ++this.moduleSymTabCacheHits;
            return this.moduleSymTabCache.get(moduleName);
        }
        ++this.moduleSymTabCacheMisses;
        int entries = this.countModuleSymbolTableEntries(moduleName);
        if (entries == 0) {
            return new LinkedList<Definition>();
        }
        String filename = "module:" + PhotranVPG.canonicalizeIdentifier(moduleName);
        ArrayList<Definition> result = new ArrayList<Definition>(entries);
        int i = 0;
        while (i < entries) {
            PhotranTokenRef tokenRef = (PhotranTokenRef)this.createTokenRef(filename, i, 0);
            Serializable entry = this.db.getAnnotation(tokenRef, 7);
            if (entry != null && entry instanceof Definition) {
                result.add((Definition)entry);
            }
            ++i;
        }
        this.moduleSymTabCache.cache(moduleName, result);
        return result;
    }

    protected int countModuleSymbolTableEntries(String canonicalizedModuleName) {
        String filename = "module:" + canonicalizedModuleName;
        PhotranTokenRef tokenRef = (PhotranTokenRef)this.createTokenRef(filename, 0, 0);
        Serializable result = this.db.getAnnotation(tokenRef, 6);
        return result == null || !(result instanceof Integer) ? 0 : (Integer)result;
    }

    public void printModuleSymTabCacheStatisticsOn(PrintStream out) {
        out.println("Module Symbol Table Cache Statistics:");
        long edgeTotal = this.moduleSymTabCacheHits + this.moduleSymTabCacheMisses;
        float edgeHitRatio = edgeTotal == 0L ? 0.0f : (float)this.moduleSymTabCacheHits / (float)edgeTotal * 100.0f;
        out.println("    Hit Ratio:        " + this.moduleSymTabCacheHits + "/" + edgeTotal + " (" + (long)Math.round(edgeHitRatio) + "%)");
    }

    public void resetStatistics() {
        this.moduleSymTabCacheMisses = 0L;
        this.moduleSymTabCacheHits = 0L;
    }

    public List<IMarker> recomputeErrorLogMarkers() {
        this.deleteExistingErrorMarkers();
        this.populateErrorLogMarkers();
        return this.errorLogMarkers;
    }

    private void deleteExistingErrorMarkers() {
        if (this.errorLogMarkers != null) {
            for (IMarker marker : this.errorLogMarkers) {
                try {
                    marker.delete();
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            }
            this.errorLogMarkers = null;
        }
    }

    private void populateErrorLogMarkers() {
        List errorLog = this.log.getEntries();
        this.errorLogMarkers = new ArrayList<IMarker>(errorLog.size());
        for (VPGLog.Entry entry : errorLog) {
            try {
                this.errorLogMarkers.add(this.createMarkerFrom(entry));
            }
            catch (CoreException coreException) {}
        }
    }

    private IMarker createMarkerFrom(VPGLog.Entry entry) throws CoreException {
        IMarker marker = this.createMarkerOnResource(entry);
        if (marker != null) {
            this.setMarkerAttributes(marker, entry);
        }
        return marker;
    }

    private IMarker createMarkerOnResource(VPGLog.Entry entry) throws CoreException {
        PhotranTokenRef tr = (PhotranTokenRef)entry.getTokenRef();
        IFile file = tr == null ? null : tr.getFile();
        IFile res = file == null ? ResourcesPlugin.getWorkspace().getRoot() : file;
        return res.createMarker(this.determineMarkerType(entry));
    }

    private String determineMarkerType(VPGLog.Entry entry) {
        if (entry.isWarning()) {
            return "org.eclipse.photran.core.vpg.warningMarker";
        }
        return "org.eclipse.photran.core.vpg.errorMarker";
    }

    private void setMarkerAttributes(IMarker marker, VPGLog.Entry entry) throws CoreException {
        HashMap<String, Object> attribs = new HashMap<String, Object>(5);
        PhotranTokenRef tr = (PhotranTokenRef)entry.getTokenRef();
        if (tr != null) {
            attribs.put("charStart", tr.getOffset());
            attribs.put("charEnd", tr.getEndOffset());
        }
        attribs.put("message", entry.getMessage());
        attribs.put("userEditable", false);
        attribs.put("severity", 2);
        marker.setAttributes(attribs);
    }

    public boolean doesProjectHaveRefactoringEnabled(IFile file) {
        if (FortranCorePlugin.inTestingMode()) {
            return true;
        }
        String vpgEnabledProperty = SearchPathProperties.getProperty(file, "EnableVPG");
        return vpgEnabledProperty != null && vpgEnabledProperty.equals("true");
    }

    public void enableDefinitionCaching() {
        this.isDefinitionCachingEnabled = true;
    }

    public void disableDefinitionCaching() {
        this.isDefinitionCachingEnabled = false;
    }

    public boolean isDefinitionCachingEnabled() {
        return this.isDefinitionCachingEnabled;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class ExternalStmtVisitor
    extends Parser.GenericASTVisitor {
        private final ArrayList<Definition> result;
        private final String canonicalizedName;

        public ExternalStmtVisitor(ArrayList<Definition> result, String canonicalizedName) {
            this.result = result;
            this.canonicalizedName = canonicalizedName;
        }

        @Override
        public void visitASTExternalStmtNode(ASTExternalStmtNode node) {
            super.traverseChildren(node);
            Parser.IASTListNode<ASTExternalNameListNode> list = node.getExternalNameList();
            int i = 0;
            while (i < list.size()) {
                this.add(PhotranVPG.this.attemptToMatch(this.canonicalizedName, ((ASTExternalNameListNode)list.get(i)).getExternalName()));
                ++i;
            }
        }

        private void add(PhotranTokenRef tr) {
            Definition def;
            Definition definition = def = tr == null ? null : PhotranVPG.this.getDefinitionFor(tr);
            if (def != null) {
                this.result.add(def);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class InterfaceVisitor
    extends Parser.GenericASTVisitor {
        private final ArrayList<Definition> result;
        private final String canonicalizedName;

        public InterfaceVisitor(ArrayList<Definition> result, String canonicalizedName) {
            this.result = result;
            this.canonicalizedName = canonicalizedName;
        }

        @Override
        public void visitASTFunctionStmtNode(ASTFunctionStmtNode node) {
            this.addIfDefinedInInterface(PhotranVPG.this.attemptToMatch(this.canonicalizedName, node));
        }

        @Override
        public void visitASTSubroutineStmtNode(ASTSubroutineStmtNode node) {
            this.addIfDefinedInInterface(PhotranVPG.this.attemptToMatch(this.canonicalizedName, node));
        }

        private void addIfDefinedInInterface(PhotranTokenRef tr) {
            Definition def;
            Definition definition = def = tr == null ? null : PhotranVPG.this.getDefinitionFor(tr);
            if (def != null && def.isExternalSubprogramReferenceInInterfaceBlock()) {
                this.result.add(def);
            }
        }
    }
}

