/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.etfw.tau;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.StringTokenizer;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class TAUPortalUploadDialog
extends Dialog {
    private static final int RESET_ID = 22;
    private Text urlField;
    private Text usernameField;
    private Text passwordField;
    private Label portalStatus;
    private Combo workspaceCombo;
    private String url = "";
    private String uname = "";
    private String pwd = "";
    private File ppk = null;

    public TAUPortalUploadDialog(Shell parentShell, File ppk) {
        super(parentShell);
        this.ppk = ppk;
    }

    protected Control createDialogArea(Composite parent) {
        Composite comp = (Composite)super.createDialogArea(parent);
        GridLayout layout = (GridLayout)comp.getLayout();
        layout.numColumns = 2;
        Label pwdLabel = new Label(comp, 131072);
        pwdLabel.setText("TAU Portal URL: ");
        this.urlField = new Text(comp, 2052);
        GridData data = new GridData(768);
        this.urlField.setLayoutData((Object)data);
        this.urlField.setText("https://tau.nic.uoregon.edu");
        Label usernameLabel = new Label(comp, 131072);
        usernameLabel.setText("TAU Portal Username: ");
        this.usernameField = new Text(comp, 2052);
        data = new GridData(768);
        this.usernameField.setLayoutData((Object)data);
        Label passwordLabel = new Label(comp, 131072);
        passwordLabel.setText("TAU Portal Password: ");
        this.passwordField = new Text(comp, 0x400804);
        data = new GridData(768);
        this.passwordField.setLayoutData((Object)data);
        SelectionAdapter subListen = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TAUPortalUploadDialog.this.url = TAUPortalUploadDialog.this.urlField.getText();
                TAUPortalUploadDialog.this.uname = TAUPortalUploadDialog.this.usernameField.getText();
                TAUPortalUploadDialog.this.pwd = TAUPortalUploadDialog.this.passwordField.getText();
                if (TAUPortalUploadDialog.this.uname.length() == 0 || TAUPortalUploadDialog.this.pwd.length() == 0) {
                    TAUPortalUploadDialog.this.portalStatus.setText("Submit a valid user name and password");
                    TAUPortalUploadDialog.this.workspaceCombo.clearSelection();
                    TAUPortalUploadDialog.this.workspaceCombo.setEnabled(false);
                    return;
                }
                String workspaces = TAUPortalUploadDialog.getWorkspaces(TAUPortalUploadDialog.this.url, TAUPortalUploadDialog.this.uname, TAUPortalUploadDialog.this.pwd);
                if (workspaces.equals("NO_VALID_WORKSPACES")) {
                    TAUPortalUploadDialog.this.portalStatus.setText("Unknown login error.  Try again.");
                    TAUPortalUploadDialog.this.workspaceCombo.clearSelection();
                    TAUPortalUploadDialog.this.workspaceCombo.setEnabled(false);
                    return;
                }
                if (workspaces.indexOf(44) == -1) {
                    TAUPortalUploadDialog.this.portalStatus.setText(workspaces);
                    TAUPortalUploadDialog.this.workspaceCombo.clearSelection();
                    TAUPortalUploadDialog.this.workspaceCombo.setEnabled(false);
                    return;
                }
                workspaces = workspaces.trim();
                StringTokenizer tz = new StringTokenizer(workspaces, ",", false);
                String[] wSArray = new String[tz.countTokens()];
                int i = 0;
                while (tz.hasMoreTokens()) {
                    wSArray[i++] = tz.nextToken().trim();
                }
                TAUPortalUploadDialog.this.workspaceCombo.setItems(wSArray);
                TAUPortalUploadDialog.this.workspaceCombo.setEnabled(true);
                TAUPortalUploadDialog.this.workspaceCombo.select(0);
                TAUPortalUploadDialog.this.portalStatus.setText("Select a workspace");
            }
        };
        Button login = new Button(comp, 0x1000008);
        login.setText("Submit Login");
        login.addSelectionListener((SelectionListener)subListen);
        this.portalStatus = new Label(comp, 16384);
        this.portalStatus.setText("Submit a valid user name and password             ");
        Label workspaceLabel = new Label(comp, 131072);
        workspaceLabel.setText("Select Workspace: ");
        this.workspaceCombo = new Combo(comp, 8);
        data = new GridData(768);
        this.workspaceCombo.setLayoutData((Object)data);
        this.workspaceCombo.setEnabled(false);
        return comp;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.createButton(parent, 22, "Reset All", false);
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 22) {
            this.usernameField.setText("");
            this.passwordField.setText("");
        } else {
            if (buttonId == 0) {
                if (!this.workspaceCombo.getEnabled()) {
                    this.portalStatus.setText("Error: No workspace selected");
                    return;
                }
                if (this.workspaceCombo.getSelectionIndex() == -1) {
                    this.portalStatus.setText("Error: No workspace selected");
                    return;
                }
                try {
                    String success = TAUPortalUploadDialog.uploadPPK(this.url, this.uname, this.pwd, this.workspaceCombo.getItem(this.workspaceCombo.getSelectionIndex()), this.ppk);
                    if (success.indexOf("ERROR") >= 0) {
                        this.portalStatus.setText(success);
                        return;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.portalStatus.setText("Unknown upload error.  Try again.");
                    return;
                }
            }
            super.buttonPressed(buttonId);
        }
    }

    private static String convertToHex(byte[] data) {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < data.length) {
            int halfbyte = data[i] >>> 4 & 0xF;
            int two_halfs = 0;
            do {
                if (halfbyte >= 0 && halfbyte <= 9) {
                    buf.append((char)(48 + halfbyte));
                } else {
                    buf.append((char)(97 + (halfbyte - 10)));
                }
                halfbyte = data[i] & 0xF;
            } while (two_halfs++ < 1);
            ++i;
        }
        return buf.toString();
    }

    private static String SHA1(String text) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        MessageDigest md = MessageDigest.getInstance("SHA-1");
        byte[] sha1hash = new byte[40];
        md.update(text.getBytes("iso-8859-1"), 0, text.length());
        sha1hash = md.digest();
        return TAUPortalUploadDialog.convertToHex(sha1hash);
    }

    private static void trustHttpsCertificates() throws Exception {
        Class<?> sslProvider = null;
        boolean goodProvider = true;
        try {
            sslProvider = Class.forName("com.sun.net.ssl.internal.ssl.Provider");
        }
        catch (ClassNotFoundException classNotFoundException) {
            goodProvider = false;
        }
        if (!goodProvider) {
            sslProvider = Class.forName("com.ibm.jsse.IBMJSSEProvider");
        }
        Security.addProvider((Provider)sslProvider.newInstance());
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            }

            public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            }
        }};
        SSLContext sc = SSLContext.getInstance("SSL");
        sc.init(null, trustAllCerts, new SecureRandom());
        HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
        HostnameVerifier hv = new HostnameVerifier(){

            public boolean verify(String urlHostName, SSLSession session) {
                if (!urlHostName.equalsIgnoreCase(session.getPeerHost())) {
                    System.out.println("Warning: URL host '" + urlHostName + "' is different to SSLSession host '" + session.getPeerHost() + "'.");
                }
                return true;
            }
        };
        HttpsURLConnection.setDefaultHostnameVerifier(hv);
    }

    private static String getWorkspaces(String url, String uname, String pwd) {
        try {
            String pwd2 = TAUPortalUploadDialog.SHA1(pwd);
            String portalURL = String.valueOf(url) + "/trial/list_workspaces";
            String data = String.valueOf(URLEncoder.encode("username", "UTF-8")) + "=" + URLEncoder.encode(uname, "UTF-8");
            data = String.valueOf(data) + "&" + URLEncoder.encode("password", "UTF-8") + "=" + URLEncoder.encode(pwd2, "UTF-8");
            String workspaces = TAUPortalUploadDialog.portalAccess(portalURL, data);
            return workspaces;
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "NO_VALID_WORKSPACES";
    }

    private static String uploadPPK(String url, String usr, String pwd, String workspace, File ppkFile) throws Exception {
        String pwd2 = TAUPortalUploadDialog.SHA1(pwd);
        String portalURL = String.valueOf(url) + "/trial/batch_upload";
        String ppkName = ppkFile.getName();
        ppkName = ppkName.substring(0, ppkName.lastIndexOf(46));
        RandomAccessFile rfile = new RandomAccessFile(ppkFile, "r");
        byte[] barr = new byte[(int)rfile.length()];
        rfile.read(barr);
        String ppkString = new String(barr, "ISO-8859-1");
        ppkString = URLEncoder.encode(ppkString, "ISO-8859-1");
        String data = String.valueOf(URLEncoder.encode("username", "UTF-8")) + "=" + URLEncoder.encode(usr, "UTF-8");
        data = String.valueOf(data) + "&" + URLEncoder.encode("password", "UTF-8") + "=" + URLEncoder.encode(pwd2, "UTF-8");
        data = String.valueOf(data) + "&" + URLEncoder.encode(ppkName, "UTF-8") + "=" + ppkString;
        data = String.valueOf(data) + "&" + URLEncoder.encode("workspace", "UTF-8") + "=" + URLEncoder.encode(workspace, "UTF-8");
        return TAUPortalUploadDialog.portalAccess(portalURL, data);
    }

    private static String portalAccess(String portalURL, String data) throws Exception {
        URL url = new URL(portalURL);
        TAUPortalUploadDialog.trustHttpsCertificates();
        URLConnection conn = url.openConnection();
        ((HttpsURLConnection)conn).setHostnameVerifier(new HostnameVerifier(){

            public boolean verify(String hostname, SSLSession session) {
                return true;
            }
        });
        conn.setDoOutput(true);
        OutputStreamWriter wr = new OutputStreamWriter(conn.getOutputStream());
        wr.write(data);
        wr.flush();
        String line = "";
        BufferedReader rd = new BufferedReader(new InputStreamReader(conn.getInputStream()));
        String result = "";
        while ((line = rd.readLine()) != null) {
            result = String.valueOf(result) + line;
        }
        wr.close();
        return result;
    }
}

