/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.proxy.runtime.server;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import org.eclipse.ptp.proxy.command.IProxyCommand;
import org.eclipse.ptp.proxy.command.IProxyCommandListener;
import org.eclipse.ptp.proxy.command.IProxyQuitCommand;
import org.eclipse.ptp.proxy.event.IProxyEvent;
import org.eclipse.ptp.proxy.messages.Messages;
import org.eclipse.ptp.proxy.packet.ProxyPacket;
import org.eclipse.ptp.proxy.runtime.command.IProxyRuntimeInitCommand;
import org.eclipse.ptp.proxy.runtime.command.IProxyRuntimeModelDefCommand;
import org.eclipse.ptp.proxy.runtime.command.IProxyRuntimeStartEventsCommand;
import org.eclipse.ptp.proxy.runtime.command.IProxyRuntimeSubmitJobCommand;
import org.eclipse.ptp.proxy.runtime.command.IProxyRuntimeTerminateJobCommand;
import org.eclipse.ptp.proxy.runtime.command.ProxyRuntimeCommandFactory;
import org.eclipse.ptp.proxy.runtime.event.IProxyRuntimeEventFactory;
import org.eclipse.ptp.proxy.runtime.server.ElementIDGenerator;
import org.eclipse.ptp.proxy.server.AbstractProxyServer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractProxyRuntimeServer
extends AbstractProxyServer
implements IProxyCommandListener {
    private final LinkedBlockingQueue<IProxyCommand> fCommands = new LinkedBlockingQueue();
    protected final IProxyRuntimeEventFactory fEventFactory;
    public int fEventLoopTransID;
    protected Thread fEventThread;
    protected Thread eventThread;

    protected static Map<String, Object> parseArguments(String[] args) {
        int port = -1;
        String host = null;
        int i = 0;
        while (i < args.length) {
            if (args[i].startsWith("--port")) {
                try {
                    port = new Integer(args[i].substring(7));
                }
                catch (NumberFormatException numberFormatException) {
                    System.err.println(String.valueOf(Messages.AbstractProxyRuntimeServer_0) + args[i + 1].substring(7));
                }
            } else if (args[i].startsWith("--host")) {
                host = args[i].substring(7);
            }
            ++i;
        }
        if (port == -1) {
            System.err.println(Messages.AbstractProxyRuntimeServer_1);
            return null;
        }
        if (host == null) {
            System.err.println(Messages.AbstractProxyRuntimeServer_2);
            return null;
        }
        HashMap<String, Object> ret = new HashMap<String, Object>();
        ret.put("port", port);
        ret.put("host", host);
        return ret;
    }

    public AbstractProxyRuntimeServer(String host, int port, IProxyRuntimeEventFactory eventFactory) {
        super(host, port, new ProxyRuntimeCommandFactory());
        this.fEventFactory = eventFactory;
        this.addListener(this);
        try {
            this.connect();
            this.start();
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
    }

    protected IProxyRuntimeEventFactory getEventFactory() {
        return this.fEventFactory;
    }

    protected Thread getEventThread() {
        return this.fEventThread;
    }

    @Override
    public void handleCommand(IProxyCommand c) {
        this.fCommands.add(c);
    }

    @Override
    protected void runStateMachine() throws InterruptedException, IOException {
        while (this.state != AbstractProxyServer.ServerState.SHUTDOWN) {
            System.out.println("runStateMachine: state: " + (Object)((Object)this.state));
            switch (this.state) {
                case INIT: {
                    IProxyEvent event;
                    IProxyCommand command = this.fCommands.take();
                    int base_ID = Integer.parseInt(command.getArguments()[1].split("=")[1]);
                    new ElementIDGenerator(base_ID);
                    int transID = command.getTransactionID();
                    System.out.println("runStateMachine: command: " + command.getCommandID() + " (" + transID + ")");
                    if (command instanceof IProxyRuntimeInitCommand) {
                        event = this.fEventFactory.newOKEvent(transID);
                        this.sendEvent(event);
                        this.state = AbstractProxyServer.ServerState.DISCOVERY;
                        break;
                    }
                    System.err.println("unexpected command (INIT): " + command);
                    break;
                }
                case DISCOVERY: {
                    IProxyEvent event;
                    IProxyCommand command = this.fCommands.take();
                    int transID = command.getTransactionID();
                    System.out.println("runStateMachine: command: " + command.getCommandID() + " (" + transID + ")");
                    if (command instanceof IProxyRuntimeModelDefCommand) {
                        event = this.fEventFactory.newOKEvent(transID);
                        this.sendEvent(event);
                        this.state = AbstractProxyServer.ServerState.NORMAL;
                        break;
                    }
                    System.err.println("unexpected command (DISC): " + command);
                    break;
                }
                case NORMAL: {
                    IProxyEvent event;
                    IProxyCommand command = this.fCommands.take();
                    int transID = command.getTransactionID();
                    System.out.println("runStateMachine: command: " + command.getCommandID() + " (" + transID + ")");
                    if (command instanceof IProxyRuntimeStartEventsCommand) {
                        if (this.fEventThread != null) break;
                        this.fEventLoopTransID = transID;
                        this.startEventThread(transID);
                        break;
                    }
                    if (command instanceof IProxyQuitCommand) {
                        event = this.fEventFactory.newShutdownEvent(transID);
                        this.sendEvent(event);
                        this.state = AbstractProxyServer.ServerState.SHUTDOWN;
                        break;
                    }
                    if (command instanceof IProxyRuntimeTerminateJobCommand) {
                        this.terminateJob(transID, command.getArguments());
                        break;
                    }
                    if (command instanceof IProxyRuntimeSubmitJobCommand) {
                        this.submitJob(transID, command.getArguments());
                        break;
                    }
                    System.err.println("unexpected command (NORM): " + command);
                }
            }
        }
    }

    public void sendEvent(IProxyEvent event) throws IOException {
        ProxyPacket packet = new ProxyPacket(event);
        packet.send(this.sessOutput);
    }

    protected void setEventThread(Thread thread) {
        this.fEventThread = thread;
    }

    protected abstract void startEventThread(int var1);

    protected abstract void submitJob(int var1, String[] var2);

    protected abstract void terminateJob(int var1, String[] var2);
}

