/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.remote.rse.core;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.dstore.core.model.DataStore;
import org.eclipse.ptp.remote.core.IRemoteConnection;
import org.eclipse.ptp.remote.core.IRemoteConnectionChangeEvent;
import org.eclipse.ptp.remote.core.IRemoteConnectionChangeListener;
import org.eclipse.ptp.remote.core.IRemoteServices;
import org.eclipse.ptp.remote.core.exception.RemoteConnectionException;
import org.eclipse.ptp.remote.core.exception.UnableToForwardPortException;
import org.eclipse.ptp.remote.rse.core.messages.Messages;
import org.eclipse.rse.connectorservice.dstore.DStoreConnectorService;
import org.eclipse.rse.connectorservice.dstore.DStoreConnectorServiceManager;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.subsystems.CommunicationsEvent;
import org.eclipse.rse.core.subsystems.ICommunicationsListener;
import org.eclipse.rse.core.subsystems.IConnectorService;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.services.clientserver.messages.SystemMessageException;
import org.eclipse.rse.services.dstore.IDStoreService;
import org.eclipse.rse.services.shells.IShellService;
import org.eclipse.rse.subsystems.files.core.model.RemoteFileUtility;
import org.eclipse.rse.subsystems.files.core.servicesubsystem.IFileServiceSubSystem;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFileSubSystem;
import org.eclipse.rse.subsystems.shells.core.subsystems.servicesubsystem.IShellServiceSubSystem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RSEConnection
implements IRemoteConnection {
    private IShellService fShellService = null;
    private ISubSystem fSubSystem = null;
    private Map<String, String> fEnv = null;
    private Map<String, String> fProperties = null;
    private IPath fWorkingDir = null;
    private final IHost fRseHost;
    private final IRemoteConnection fConnection = this;
    private final IRemoteServices fRemoteServices;
    private final ListenerList fListeners = new ListenerList();
    private ICommunicationsListener commsListener = new ICommunicationsListener(){

        public void communicationsStateChange(CommunicationsEvent event) {
            switch (event.getState()) {
                case 2: {
                    RSEConnection.this.fireConnectionChangeEvent(2);
                    break;
                }
                case 4: {
                    RSEConnection.this.fireConnectionChangeEvent(1);
                    break;
                }
                case 5: {
                    RSEConnection.this.fireConnectionChangeEvent(4);
                }
            }
        }

        public boolean isPassiveCommunicationsListener() {
            return true;
        }
    };

    public RSEConnection(IHost host, IRemoteServices services) {
        this.fRseHost = host;
        this.fRemoteServices = services;
    }

    public void addConnectionChangeListener(IRemoteConnectionChangeListener listener) {
        this.fListeners.add((Object)listener);
    }

    public void close() {
        if (this.fSubSystem != null && this.fSubSystem.isConnected()) {
            try {
                this.fSubSystem.disconnect();
            }
            catch (Exception exception) {}
        }
    }

    public void forwardLocalPort(int localPort, String fwdAddress, int fwdPort) throws RemoteConnectionException {
        throw new UnableToForwardPortException(Messages.RSEConnection_noPortFwd);
    }

    public int forwardLocalPort(String fwdAddress, int fwdPort, IProgressMonitor monitor) throws RemoteConnectionException {
        throw new UnableToForwardPortException(Messages.RSEConnection_noPortFwd);
    }

    public void forwardRemotePort(int remotePort, String fwdAddress, int fwdPort) throws RemoteConnectionException {
        throw new UnableToForwardPortException(Messages.RSEConnection_noPortFwd);
    }

    public int forwardRemotePort(String fwdAddress, int fwdPort, IProgressMonitor monitor) throws RemoteConnectionException {
        throw new UnableToForwardPortException(Messages.RSEConnection_noPortFwd);
    }

    public String getAddress() {
        return this.fRseHost.getHostName();
    }

    public Map<String, String> getAttributes() {
        return new HashMap<String, String>();
    }

    public DataStore getDataStore() {
        IConnectorService connector = DStoreConnectorServiceManager.getInstance().getConnectorService(this.fRseHost, IDStoreService.class);
        if (connector != null && connector instanceof DStoreConnectorService) {
            return ((DStoreConnectorService)connector).getDataStore();
        }
        return null;
    }

    public Map<String, String> getEnv() {
        if (this.fEnv == null) {
            this.fEnv = new HashMap<String, String>();
            try {
                String[] env;
                String[] stringArray = env = this.fShellService.getHostEnvironment();
                int n = env.length;
                int n2 = 0;
                while (n2 < n) {
                    String var = stringArray[n2];
                    String[] kv = var.split("=");
                    if (kv.length == 2) {
                        this.fEnv.put(kv[0], kv[1]);
                    }
                    ++n2;
                }
            }
            catch (SystemMessageException systemMessageException) {}
        }
        return this.fEnv;
    }

    public String getEnv(String name) {
        if (this.fEnv == null) {
            this.getEnv();
        }
        return this.fEnv.get(name);
    }

    public IHost getHost() {
        return this.fRseHost;
    }

    public String getName() {
        return this.fRseHost.getAliasName();
    }

    public String getProperty(String key) {
        this.loadProperties();
        return this.fProperties.get(key);
    }

    public IRemoteServices getRemoteServices() {
        return this.fRemoteServices;
    }

    public IShellService getRemoteShellService() {
        return this.fShellService;
    }

    public String getUsername() {
        return this.fRseHost.getDefaultUserId();
    }

    public String getWorkingDirectory() {
        if (this.fWorkingDir == null) {
            IFileServiceSubSystem fileService = this.getFileServiceSubSystem(this.getHost());
            this.fWorkingDir = fileService != null ? new Path(fileService.getFileService().getUserHome().getAbsolutePath()) : new Path("/");
        }
        return this.fWorkingDir.toString();
    }

    public boolean isOpen() {
        return this.fSubSystem != null && this.fSubSystem.isConnected();
    }

    public void open(IProgressMonitor monitor) throws RemoteConnectionException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        if (!this.fSubSystem.isConnected()) {
            try {
                SubMonitor subMon = SubMonitor.convert((IProgressMonitor)monitor);
                this.fSubSystem.connect((IProgressMonitor)subMon.newChild(1), false);
            }
            catch (Exception e) {
                throw new RemoteConnectionException(e.getMessage());
            }
            if (!this.fSubSystem.isConnected()) {
                throw new RemoteConnectionException(Messages.RSEConnection_noShellService);
            }
        }
    }

    public void removeConnectionChangeListener(IRemoteConnectionChangeListener listener) {
        this.fListeners.remove((Object)listener);
    }

    public void setAddress(String address) {
        this.fRseHost.setHostName(address);
    }

    public void setName(String name) {
        this.fRseHost.setAliasName(name);
    }

    public void setUsername(String username) {
        this.fRseHost.setDefaultUserId(username);
    }

    public void setWorkingDirectory(String pathStr) {
        Path path = new Path(pathStr);
        if (path.isAbsolute()) {
            this.fWorkingDir = path;
        }
    }

    public boolean supportsTCPPortForwarding() {
        return false;
    }

    private void fireConnectionChangeEvent(final int type) {
        IRemoteConnectionChangeEvent event = new IRemoteConnectionChangeEvent(){

            public IRemoteConnection getConnection() {
                return RSEConnection.this.fConnection;
            }

            public int getType() {
                return type;
            }
        };
        Object[] objectArray = this.fListeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((IRemoteConnectionChangeListener)listener).connectionChanged(event);
            ++n2;
        }
    }

    private IFileServiceSubSystem getFileServiceSubSystem(IHost host) {
        IRemoteFileSubSystem[] fileSubsystems;
        IRemoteFileSubSystem[] iRemoteFileSubSystemArray = fileSubsystems = RemoteFileUtility.getFileSubSystems((IHost)host);
        int n = fileSubsystems.length;
        int n2 = 0;
        while (n2 < n) {
            IRemoteFileSubSystem subsystem = iRemoteFileSubSystemArray[n2];
            if (subsystem instanceof IFileServiceSubSystem && subsystem.isConnected()) {
                return (IFileServiceSubSystem)subsystem;
            }
            ++n2;
        }
        return null;
    }

    private void loadProperties() {
        if (this.fProperties == null) {
            this.fProperties = new HashMap<String, String>();
            this.fProperties.put("file.separator", "/");
            this.fProperties.put("path.separator", ":");
            this.fProperties.put("line.separator", "\n");
        }
    }

    protected void dispose() {
        this.fSubSystem.getConnectorService().removeCommunicationsListener(this.commsListener);
    }

    protected boolean initialize() {
        if (this.fSubSystem == null) {
            ISubSystem[] subSystems;
            ISubSystem[] iSubSystemArray = subSystems = this.fRseHost.getSubSystems();
            int n = subSystems.length;
            int n2 = 0;
            while (n2 < n) {
                ISubSystem sub = iSubSystemArray[n2];
                if (sub instanceof IShellServiceSubSystem) {
                    this.fSubSystem = sub;
                    break;
                }
                ++n2;
            }
            if (this.fSubSystem == null) {
                return false;
            }
            this.fSubSystem.getConnectorService().addCommunicationsListener(this.commsListener);
            this.fShellService = ((IShellServiceSubSystem)this.fSubSystem).getShellService();
        }
        return true;
    }
}

