/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rephraserengine.internal.core.preservation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.rephraserengine.core.preservation.PreservationRule;
import org.eclipse.rephraserengine.core.vpg.TokenRef;
import org.eclipse.rephraserengine.core.vpg.VPG;
import org.eclipse.rephraserengine.core.vpg.VPGEdge;
import org.eclipse.rephraserengine.core.vpg.eclipse.EclipseVPG;
import org.eclipse.rephraserengine.internal.core.preservation.Interval;
import org.eclipse.rephraserengine.internal.core.preservation.ModelDiff;
import org.eclipse.rephraserengine.internal.core.preservation.PrimitiveOp;
import org.eclipse.rephraserengine.internal.core.preservation.PrimitiveOpList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Model {
    private String name;
    private EclipseVPG<?, ?, ?, ?, ?> vpg;
    private List<String> files;
    private Set<String> filesWithNoEdges;
    private Set<Entry> edges;

    public Model(String name, IProgressMonitor pm, int ticks, EclipseVPG<?, ?, ?, ?, ?> vpg, String ... filenames) {
        this(name, pm, ticks, vpg, Arrays.asList(filenames));
    }

    public Model(String name, IProgressMonitor pm, int ticks, EclipseVPG<?, ?, ?, ?, ?> vpg, List<String> filenames) {
        this.name = name;
        this.vpg = vpg;
        pm.subTask("Preparing to compute " + name);
        this.files = vpg.sortFilesAccordingToDependencies(new ArrayList<String>(filenames), (IProgressMonitor)new NullProgressMonitor());
        this.filesWithNoEdges = new TreeSet<String>();
        pm = new SubProgressMonitor(pm, ticks, 4);
        pm.beginTask("Computing " + name + ":", this.files.size());
        this.edges = new TreeSet<Entry>();
        for (String thisFile : this.files) {
            pm.subTask(VPG.lastSegmentOfFilename(thisFile));
            this.addEdges(thisFile, pm);
            pm.worked(1);
        }
        pm.done();
    }

    private void addEdges(String filename, IProgressMonitor pm) {
        int count = 0;
        for (VPGEdge edge : this.vpg.db.getAllEdgesFor(filename)) {
            Object source = edge.getSource();
            Object sink = edge.getSink();
            this.edges.add(new Entry(((TokenRef)source).getFilename(), new Interval(((TokenRef)source).getOffset(), ((TokenRef)source).getEndOffset()), ((TokenRef)sink).getFilename(), new Interval(((TokenRef)sink).getOffset(), ((TokenRef)sink).getEndOffset()), edge.getType()));
            ++count;
        }
        if (count == 0) {
            this.filesWithNoEdges.add(filename);
        }
    }

    public List<String> getFiles() {
        return this.files;
    }

    public void inormalize(PrimitiveOpList primitiveOps, Set<PreservationRule> preserveEdgeTypes, IProgressMonitor pm) {
        pm = new SubProgressMonitor(pm, 0, 4);
        pm.beginTask("Normalizing " + this.name, this.edges.size());
        TreeSet<Entry> revisedList = new TreeSet<Entry>();
        for (Entry entry : this.edges) {
            if (entry.shouldPreserveAccordingTo(preserveEdgeTypes, primitiveOps, true)) {
                entry.source = primitiveOps.inorm(entry.sourceFilename, entry.source);
                entry.sink = primitiveOps.inorm(entry.sinkFilename, entry.sink);
                revisedList.add(entry);
            }
            pm.worked(1);
        }
        this.edges = revisedList;
        pm.done();
    }

    public void dnormalize(PrimitiveOpList primitiveOps, Set<PreservationRule> preserveEdgeTypes, IProgressMonitor pm) {
        pm = new SubProgressMonitor(pm, 0, 4);
        pm.beginTask("Normalizing " + this.name, this.edges.size());
        TreeSet<Entry> revisedList = new TreeSet<Entry>();
        for (Entry entry : this.edges) {
            if (entry.shouldPreserveAccordingTo(preserveEdgeTypes, primitiveOps, false)) {
                entry.source = primitiveOps.dnorm(entry.sourceFilename, entry.source);
                entry.sink = primitiveOps.dnorm(entry.sinkFilename, entry.sink);
                revisedList.add(entry);
            }
            pm.worked(1);
        }
        this.edges = revisedList;
        pm.done();
    }

    public ModelDiff compareAgainst(Model that, IProgressMonitor pm) {
        pm = new SubProgressMonitor(pm, 0, 4);
        pm.beginTask("Differencing " + this.name + " and " + that.name, this.edges.size() + that.edges.size());
        ModelDiff diff = new ModelDiff();
        for (Entry entry : this.edges) {
            if (!that.edges.contains(entry)) {
                Entry otherEntry = this.findEntryWithNewSink(entry, that.edges);
                if (otherEntry != null) {
                    that.edges.remove(otherEntry);
                    diff.add(new ModelDiff.EdgeSinkChanged(entry.sourceFilename, entry.source, entry.sinkFilename, entry.sink, otherEntry.sinkFilename, otherEntry.sink, entry.edgeType));
                } else if (that.filesWithNoEdges.contains(entry.sourceFilename)) {
                    diff.recordFileWithNoEdges(entry.sourceFilename);
                } else if (that.filesWithNoEdges.contains(entry.sinkFilename)) {
                    diff.recordFileWithNoEdges(entry.sinkFilename);
                } else {
                    diff.add(new ModelDiff.EdgeDeleted(entry.sourceFilename, entry.origSource, entry.sinkFilename, entry.sink, entry.edgeType));
                }
            }
            pm.worked(1);
        }
        for (Entry entry : that.edges) {
            if (!this.edges.contains(entry)) {
                diff.add(new ModelDiff.EdgeAdded(entry.sourceFilename, entry.source, entry.sinkFilename, entry.sink, entry.edgeType));
            }
            pm.worked(1);
        }
        pm.done();
        return diff;
    }

    private Entry findEntryWithNewSink(Entry entry, Set<Entry> otherEdgeList) {
        for (Entry otherEntry : otherEdgeList) {
            if (!otherEntry.sourceFilename.equals(entry.sourceFilename) || !otherEntry.source.equals(entry.source) || otherEntry.edgeType != entry.edgeType) continue;
            return otherEntry;
        }
        return null;
    }

    public String toString() {
        return this.toString(null, null, null);
    }

    public String toString(String filename, String fileContents, ArrayList<Integer> lineMap) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.edges.size());
        sb.append(" edges\n\n");
        TreeSet<Integer> edgeTypes = new TreeSet<Integer>();
        for (Entry entry : this.edges) {
            edgeTypes.add(entry.edgeType);
        }
        Iterator<Entry> iterator = edgeTypes.iterator();
        while (iterator.hasNext()) {
            int edgeType = (Integer)((Object)iterator.next());
            for (Entry entry : this.edges) {
                if (entry.edgeType != edgeType) continue;
                if (!entry.sourceFilename.equals(filename)) {
                    sb.append(entry.sourceFilename);
                    sb.append(':');
                }
                sb.append('[');
                sb.append(String.format("%5d", ((Entry)entry).source.lb));
                sb.append(", ");
                sb.append(String.format("%5d", ((Entry)entry).source.ub));
                sb.append(")  ===(");
                sb.append(entry.edgeType);
                sb.append(")==>  ");
                if (!entry.sinkFilename.equals(filename)) {
                    sb.append(entry.sinkFilename);
                    sb.append(':');
                }
                sb.append('[');
                sb.append(String.format("%5d", ((Entry)entry).sink.lb));
                sb.append(", ");
                sb.append(String.format("%5d", ((Entry)entry).sink.ub));
                sb.append(")");
                if (fileContents != null) {
                    sb.append("           [");
                    if (!entry.sourceFilename.equals(filename)) {
                        sb.append('?');
                    } else if (((Entry)entry).source.lb >= 0 && ((Entry)entry).source.ub >= ((Entry)entry).source.lb) {
                        sb.append(this.extractText(fileContents, entry.source));
                    }
                    sb.append("]");
                    if (lineMap != null) {
                        sb.append(" (Line ");
                        sb.append(this.getLine(((Entry)entry).source.lb, lineMap));
                        sb.append(")");
                    }
                    sb.append("  ===(");
                    sb.append(this.vpg.describeEdgeType(entry.edgeType));
                    sb.append(")==>  [");
                    if (!entry.sinkFilename.equals(filename)) {
                        sb.append('?');
                    } else if (((Entry)entry).sink.lb >= 0 && ((Entry)entry).sink.ub >= ((Entry)entry).sink.lb) {
                        sb.append(this.extractText(fileContents, entry.sink));
                    }
                    sb.append("]");
                    if (lineMap != null) {
                        sb.append(" (Line ");
                        sb.append(this.getLine(((Entry)entry).sink.lb, lineMap));
                        sb.append(")");
                    }
                }
                sb.append('\n');
            }
        }
        return sb.toString();
    }

    private String extractText(String fileContents, Interval interval) {
        String result = fileContents.substring(interval.lb, interval.ub);
        result = result.replace("\t", "\\t");
        result = result.replace("\r", "\\r");
        if ((result = result.replace("\n", "\\n")).length() > 17) {
            result = String.valueOf(result.substring(0, 18)) + "...";
        }
        return result;
    }

    private int getLine(int offset, ArrayList<Integer> lineMap) {
        int i = 0;
        while (i < lineMap.size()) {
            if (offset < lineMap.get(i)) {
                return i + 1;
            }
            ++i;
        }
        return lineMap.size();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Entry
    implements Comparable<Entry> {
        private int edgeType;
        private String sourceFilename;
        private Interval source;
        private Interval origSource;
        private String sinkFilename;
        private Interval sink;

        public Entry(String sourceFilename, Interval source, String sinkFilename, Interval sink, int edgeType) {
            if (source == null || sink == null) {
                throw new IllegalArgumentException();
            }
            this.sourceFilename = sourceFilename;
            this.source = this.origSource = source;
            this.sinkFilename = sinkFilename;
            this.sink = sink;
            this.edgeType = edgeType;
        }

        public boolean shouldPreserveAccordingTo(Set<PreservationRule> preserveEdgeTypes, PrimitiveOpList primitiveOps, boolean initial) {
            for (PreservationRule rule : preserveEdgeTypes) {
                if (!this.shouldPreserveAccordingTo(rule, primitiveOps, initial)) continue;
                return true;
            }
            return false;
        }

        public boolean shouldPreserveAccordingTo(PreservationRule rule, PrimitiveOpList primitiveOps, boolean initial) {
            boolean result = false;
            for (PrimitiveOp op : primitiveOps) {
                boolean outgoing;
                Interval affected = initial ? op.iaff() : op.daff(primitiveOps);
                boolean incoming = this.sinkFilename.equals(op.filename) && this.sink.isSubsetOf(affected);
                boolean bl = outgoing = this.sourceFilename.equals(op.filename) && this.source.isSubsetOf(affected);
                if (rule.definitelyShouldNotPreserve(incoming, outgoing, this.edgeType)) {
                    return false;
                }
                boolean bl2 = result = result || rule.shouldPreserve(incoming, outgoing, this.edgeType);
            }
            return result;
        }

        public boolean equals(Object o) {
            if (o == null || !o.getClass().equals(this.getClass())) {
                return false;
            }
            Entry that = (Entry)o;
            return this.edgeType == that.edgeType && this.sourceFilename.equals(that.sourceFilename) && this.source.equals(that.source) && this.sinkFilename.equals(that.sinkFilename) && this.sink.equals(that.sink);
        }

        public int hashCode() {
            return 263 * this.source.hashCode() + 13 * this.sink.hashCode() + this.edgeType;
        }

        @Override
        public int compareTo(Entry that) {
            int result = that.edgeType - this.edgeType;
            if (result == 0 && (result = this.sourceFilename.compareTo(that.sourceFilename)) == 0 && (result = this.sinkFilename.compareTo(that.sinkFilename)) == 0 && (result = this.source.compareTo(that.source)) == 0) {
                result = this.sink.compareTo(that.sink);
            }
            return result;
        }
    }
}

