/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.ibm.ll.ui.rmLaunchConfiguration;

import org.eclipse.ptp.core.attributes.IAttributeDefinition;
import org.eclipse.ptp.core.attributes.IllegalValueException;
import org.eclipse.ptp.rm.ibm.ll.ui.messages.Messages;
import org.eclipse.ptp.rm.ibm.ll.ui.rmLaunchConfiguration.ValidationState;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DualFieldRowWidget
implements ValidationState {
    private Label label;
    private Label nonDefaultMarker;
    private GridData gridData;
    private IAttributeDefinition<?, ?, ?> attr1;
    private IAttributeDefinition<?, ?, ?> attr2;
    private DualField widget;
    private String[] defaultValue;
    private EventMonitor eventMonitor;
    private int validationState;

    public DualFieldRowWidget(Composite parent, String id1, String id2, IAttributeDefinition<?, ?, ?> def1, IAttributeDefinition<?, ?, ?> def2) {
        this.attr1 = def1;
        this.attr2 = def2;
        this.gridData = new GridData(768);
        this.gridData.grabExcessHorizontalSpace = false;
        this.label = new Label(parent, 0);
        this.label.setText(Messages.getString(this.attr1.getName()));
        this.label.setLayoutData((Object)this.gridData);
        this.nonDefaultMarker = new Label(parent, 0);
        this.nonDefaultMarker.setText(" ");
        this.widget = new DualField(parent);
        this.widget.setToolTipText(Messages.getString(this.attr1.getDescription()), Messages.getString(this.attr2.getDescription()));
        this.gridData = new GridData(768);
        this.gridData.horizontalSpan = 2;
        this.gridData.grabExcessHorizontalSpace = true;
        this.widget.setLayoutData(this.gridData);
        this.widget.setData1(id1);
        this.widget.setData2(id2);
        try {
            this.defaultValue = new String[2];
            this.defaultValue[0] = this.attr1.create().getValueAsString();
            this.defaultValue[1] = this.attr2.create().getValueAsString();
        }
        catch (IllegalValueException illegalValueException) {
            this.defaultValue[0] = "";
            this.defaultValue[1] = "";
        }
        this.eventMonitor = new EventMonitor();
        this.widget.addModifyListener(this.eventMonitor);
    }

    public void addModifyListener(ModifyListener listener) {
        this.widget.addModifyListener(listener);
    }

    public void setEnabled(boolean state) {
        this.widget.setEnabled(state);
    }

    public void setValue(String value1, String value2) {
        this.widget.setText(value1, value2);
    }

    public Object getData1() {
        return this.widget.getData1();
    }

    public Object getData2() {
        return this.widget.getData2();
    }

    public String[] getValue() {
        return this.widget.getText();
    }

    public boolean isEnabled() {
        return this.widget.isEnabled();
    }

    @Override
    public void resetValidationState() {
        this.validationState = 0;
    }

    @Override
    public void setFieldInError() {
        this.validationState = 2;
    }

    @Override
    public void setValidationRequired() {
        this.validationState = 1;
    }

    @Override
    public boolean isValidationRequired() {
        return this.validationState == 1 || this.validationState == 2;
    }

    @Override
    public boolean isMatchingWidget(Widget source) {
        return this.widget.isMatchingWidget(source);
    }

    private class DualField {
        private Object attrValue1;
        private Object attrValue2;
        private Composite group;
        private Text[] value;

        public DualField(Composite parent) {
            this.group = new Composite(parent, 0);
            GridLayout layout = new GridLayout(2, true);
            layout.marginWidth = 0;
            layout.marginHeight = 0;
            GridData gd = new GridData(768);
            this.group.setLayout((Layout)layout);
            this.value = new Text[2];
            this.value[0] = new Text(this.group, 2052);
            this.value[0].setLayoutData((Object)gd);
            this.value[1] = new Text(this.group, 2052);
            this.value[1].setLayoutData((Object)gd);
        }

        public void setLayoutData(GridData gd) {
            this.group.setLayoutData((Object)gd);
        }

        public void addModifyListener(ModifyListener listener) {
            this.value[0].addModifyListener(listener);
            this.value[1].addModifyListener(listener);
        }

        public void setToolTipText(String tip1, String tip2) {
            this.value[0].setToolTipText(tip1);
            this.value[1].setToolTipText(tip2);
        }

        public void setText(String value1, String value2) {
            this.value[0].setText(value1);
            this.value[1].setText(value2);
        }

        public String[] getText() {
            String[] textValue = new String[]{this.value[0].getText().trim(), this.value[1].getText().trim()};
            return textValue;
        }

        public boolean isEnabled() {
            return this.value[0].isEnabled();
        }

        public void setEnabled(boolean state) {
            this.value[0].setEnabled(state);
            this.value[1].setEnabled(state);
        }

        public void setData1(Object value) {
            this.attrValue1 = value;
        }

        public Object getData1() {
            return this.attrValue1;
        }

        public void setData2(Object value) {
            this.attrValue2 = value;
        }

        public Object getData2() {
            return this.attrValue2;
        }

        public boolean isMatchingWidget(Widget source) {
            return this.value[0] == source || this.value[1] == source;
        }
    }

    private class EventMonitor
    implements ModifyListener {
        public void modifyText(ModifyEvent e) {
            String[] value = DualFieldRowWidget.this.widget.getText();
            if (value[0].equals(DualFieldRowWidget.this.defaultValue[0]) && value[1].equals(DualFieldRowWidget.this.defaultValue[1])) {
                DualFieldRowWidget.this.nonDefaultMarker.setText(" ");
            } else {
                DualFieldRowWidget.this.nonDefaultMarker.setText("*");
            }
        }
    }
}

