/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.pldt.openmp.core.views;

import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.parser.ParserUtil;
import org.eclipse.cdt.internal.core.dom.parser.ASTNode;
import org.eclipse.cdt.internal.ui.util.EditorUtility;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ptp.pldt.common.Artifact;
import org.eclipse.ptp.pldt.common.ArtifactManager;
import org.eclipse.ptp.pldt.common.IArtifact;
import org.eclipse.ptp.pldt.common.views.SimpleTableMarkerView;
import org.eclipse.ptp.pldt.openmp.analysis.PAST.PASTOMPPragma;
import org.eclipse.ptp.pldt.openmp.core.OpenMPPlugin;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.texteditor.AbstractTextEditor;

public class OpenMPArtifactView
extends SimpleTableMarkerView {
    public OpenMPArtifactView() {
        super((AbstractUIPlugin)OpenMPPlugin.getDefault(), OpenMPPlugin.getResourceString("OpenMPArtifactView.thingname"), OpenMPPlugin.getResourceString("OpenMPArtifactView.thingnames"), OpenMPPlugin.getResourceString("OpenMPArtifactView.extraColName"), "org.eclipse.ptp.pldt.openmp.core.openMPMarker");
    }

    protected String getConstructStr(IMarker marker) throws CoreException {
        Integer temp = (Integer)marker.getAttribute(this.columnID_);
        if (temp != null) {
            Integer constructType = temp;
            int i = constructType;
            String val = "";
            val = i < Artifact.CONSTRUCT_TYPE_NAMES.length ? Artifact.CONSTRUCT_TYPE_NAMES[i] : "value is " + i;
            return val;
        }
        return " ";
    }

    protected void makeShowInfoAction() {
        this.infoAction = new Action(){

            public void run() {
                ISelection selection = OpenMPArtifactView.this.viewer.getSelection();
                Object obj = ((IStructuredSelection)selection).getFirstElement();
                IMarker marker = (IMarker)obj;
                if (marker == null) {
                    MessageDialog.openInformation(null, (String)"No selection", (String)"No artifact selected");
                    return;
                }
                try {
                    ASTNode region;
                    IArtifact o = ArtifactManager.getArtifact((IMarker)marker);
                    if (o == null || !(o instanceof Artifact)) {
                        return;
                    }
                    Artifact artifact = (Artifact)o;
                    Object p = artifact.getArtifactAssist();
                    if (p == null || !(p instanceof PASTOMPPragma)) {
                        return;
                    }
                    PASTOMPPragma ompPragma = (PASTOMPPragma)p;
                    IASTNode iRegion = ompPragma.getRegion();
                    ASTNode aSTNode = region = iRegion instanceof ASTNode ? (ASTNode)iRegion : null;
                    if (region == null) {
                        return;
                    }
                    String filename = ompPragma.getRegionFilename();
                    if (filename == null) {
                        return;
                    }
                    IResource r = ParserUtil.getResourceForFilename((String)filename);
                    IEditorPart aPart = null;
                    if (r != null) {
                        try {
                            aPart = EditorUtility.openInEditor((Object)r);
                        }
                        catch (PartInitException partInitException) {
                            return;
                        }
                        catch (CModelException cModelException) {
                            return;
                        }
                    } else {
                        return;
                    }
                    if (aPart instanceof AbstractTextEditor) {
                        int offset = ompPragma.getRegionOffset();
                        int length = ompPragma.getRegionLength();
                        ((AbstractTextEditor)aPart).selectAndReveal(offset, length);
                    }
                }
                catch (Exception e) {
                    System.out.println("ATV.doubleclickAction: Error positioning editor page from marker line number");
                    e.printStackTrace();
                }
            }
        };
        this.infoAction.setText("Show pragma region");
        this.infoAction.setToolTipText("Show region for selected " + this.thingname_);
        this.infoAction.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJS_INFO_TSK"));
    }
}

