/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.ui.views.vpgproblems;

import java.util.List;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.MultiRule;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.photran.internal.core.vpg.PhotranVPG;
import org.eclipse.photran.internal.ui.views.vpgproblems.CopyMarkedFileAction;
import org.eclipse.photran.internal.ui.views.vpgproblems.OpenMarkedFileAction;
import org.eclipse.photran.internal.ui.views.vpgproblems.ShowFullMessageAction;
import org.eclipse.photran.internal.ui.views.vpgproblems.TableSorter;
import org.eclipse.photran.internal.ui.views.vpgproblems.VGPProblemContentProvider;
import org.eclipse.photran.internal.ui.views.vpgproblems.VGPProblemContextMenu;
import org.eclipse.photran.internal.ui.views.vpgproblems.VGPProblemLabelProvider;
import org.eclipse.photran.internal.ui.views.vpgproblems.VPGViewFilterAction;
import org.eclipse.rephraserengine.core.vpg.VPGLog;
import org.eclipse.rephraserengine.core.vpg.eclipse.VPGSchedulingRule;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.texteditor.MarkerUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VGPProblemView
extends ViewPart
implements VPGLog.ILogListener {
    private TableViewer tableViewer = null;
    private TableSorter tableSorter = null;
    private Clipboard clipboard = null;
    private CopyMarkedFileAction copyAction = null;
    private OpenMarkedFileAction openAction = null;
    private ShowFullMessageAction showAction = null;
    private VPGViewFilterAction warningsMarkerFilterAction = null;
    private VPGViewFilterAction errorsMarkerFilterAction = null;
    private static final String[] COLUMN_NAMES = new String[]{"Description", "Resource", "Path"};
    private static final int[] COLUMN_WIDTHS = new int[]{44, 10, 20};
    public static int[] MARKER_COUNT = new int[3];
    private static RecreateMarkers markersTask = null;

    public void createPartControl(Composite parent) {
        GridLayout overallLayout = new GridLayout(1, false);
        parent.setLayout((Layout)overallLayout);
        this.tableViewer = new TableViewer(parent, 66306);
        this.tableSorter = new TableSorter();
        this.tableViewer.setSorter((ViewerSorter)this.tableSorter);
        this.createTableColumns(this.tableViewer);
        this.setTableGridData();
        this.getSite().setSelectionProvider((ISelectionProvider)this.tableViewer);
        VGPProblemContextMenu manager = new VGPProblemContextMenu(this.getViewSite(), "Problems View Menu");
        this.tableViewer.getTable().setMenu(manager.createContextMenu((Control)this.tableViewer.getTable()));
        this.getSite().registerContextMenu((MenuManager)manager, (ISelectionProvider)this.tableViewer);
        this.tableViewer.setContentProvider((IContentProvider)new VGPProblemContentProvider());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new VGPProblemLabelProvider());
        PhotranVPG.getInstance().log.addLogListener((VPGLog.ILogListener)this);
        this.createToolbarButtons();
        this.initEvents();
    }

    public void onLogChange() {
        if (markersTask == null) {
            markersTask = new RecreateMarkers();
            RecreateMarkers job = new RecreateMarkers();
            job.setRule(MultiRule.combine((ISchedulingRule)VPGSchedulingRule.getInstance(), (ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot()));
            job.schedule();
        }
    }

    private void setTableGridData() {
        GridData tableData = new GridData();
        tableData.grabExcessHorizontalSpace = true;
        tableData.grabExcessVerticalSpace = true;
        tableData.horizontalAlignment = 4;
        tableData.verticalAlignment = 4;
        this.tableViewer.getTable().setLayoutData((Object)tableData);
    }

    private void resetMarkerCount() {
        int i = 0;
        while (i < MARKER_COUNT.length) {
            VGPProblemView.MARKER_COUNT[i] = 0;
            ++i;
        }
    }

    private void countMarkers(List<IMarker> markers) {
        this.resetMarkerCount();
        for (IMarker marker : markers) {
            int sev = MarkerUtilities.getSeverity((IMarker)marker);
            if (sev != 2 && sev != 1 && sev != 0) continue;
            int n = sev;
            MARKER_COUNT[n] = MARKER_COUNT[n] + 1;
        }
    }

    private void createActions() {
        this.copyAction = new CopyMarkedFileAction(this, "Copy");
        this.openAction = new OpenMarkedFileAction((IWorkbenchSite)this.getSite());
        this.showAction = new ShowFullMessageAction((IWorkbenchSite)this.getSite());
        int sevWarn = 1;
        int sevErr = 2;
        List markers = PhotranVPG.getInstance().recomputeErrorLogMarkers();
        this.countMarkers(markers);
        String warnStr = String.valueOf(String.valueOf(MARKER_COUNT[sevWarn])) + " Warnings";
        String errStr = String.valueOf(String.valueOf(MARKER_COUNT[sevErr])) + " Errors";
        this.warningsMarkerFilterAction = new VPGViewFilterAction((StructuredViewer)this.tableViewer, warnStr, sevWarn);
        this.errorsMarkerFilterAction = new VPGViewFilterAction((StructuredViewer)this.tableViewer, errStr, sevErr);
    }

    private void addActionsToToolbar() {
        IToolBarManager toolBarManager = this.getViewSite().getActionBars().getToolBarManager();
        toolBarManager.add((IAction)this.errorsMarkerFilterAction);
        toolBarManager.add((IAction)this.warningsMarkerFilterAction);
        toolBarManager.add((IAction)this.openAction);
        toolBarManager.add((IAction)this.copyAction);
        toolBarManager.add((IContributionItem)new Separator());
        toolBarManager.add((IAction)this.showAction);
    }

    private void addTableViewerSelectionChangeListener() {
        this.tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent e) {
                boolean isEnabled = !e.getSelection().isEmpty();
                VGPProblemView.this.openAction.setEnabled(isEnabled);
                VGPProblemView.this.copyAction.setEnabled(isEnabled);
                VGPProblemView.this.showAction.setEnabled(isEnabled);
            }
        });
    }

    private void createToolbarButtons() {
        this.createActions();
        this.openAction.setEnabled(false);
        this.copyAction.setEnabled(false);
        this.showAction.setEnabled(false);
        this.addActionsToToolbar();
        this.addTableViewerSelectionChangeListener();
    }

    private TableLayout createTableLayout() {
        TableLayout layout = new TableLayout();
        int i = 0;
        while (i < COLUMN_WIDTHS.length) {
            layout.addColumnData((ColumnLayoutData)new ColumnWeightData(COLUMN_WIDTHS[i], true));
            ++i;
        }
        return layout;
    }

    private void createTableColumns(final TableViewer viewer) {
        Table table = viewer.getTable();
        TableLayout layout = this.createTableLayout();
        table.setLayout((Layout)layout);
        int i = 0;
        while (i < COLUMN_NAMES.length) {
            final int index = i;
            TableViewerColumn viewerColumn = new TableViewerColumn(viewer, 0);
            final TableColumn column = viewerColumn.getColumn();
            column.setText(COLUMN_NAMES[i]);
            column.setToolTipText(COLUMN_NAMES[i]);
            column.setAlignment(16384);
            column.setResizable(true);
            column.setMoveable(true);
            column.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    VGPProblemView.this.tableSorter.setColumn(index);
                    int dir = viewer.getTable().getSortDirection();
                    dir = viewer.getTable().getSortColumn() == column ? (dir == 128 ? 1024 : 128) : 1024;
                    viewer.getTable().setSortDirection(dir);
                    viewer.getTable().setSortColumn(column);
                    viewer.refresh();
                }
            });
            ++i;
        }
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
    }

    private void initEvents() {
        this.tableViewer.getTable().addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent dblClick) {
                Table t = (Table)dblClick.getSource();
                TableItem[] selection = t.getSelection();
                int i = 0;
                while (i < selection.length) {
                    IMarker marker;
                    if (selection[i].getData() instanceof IMarker && (marker = (IMarker)selection[i].getData()).getResource() != null) {
                        try {
                            OpenMarkedFileAction openAction = new OpenMarkedFileAction((IWorkbenchSite)VGPProblemView.this.getViewSite());
                            openAction.run(marker);
                        }
                        catch (Throwable throwable) {}
                    }
                    ++i;
                }
            }

            public void mouseDown(MouseEvent arg0) {
            }

            public void mouseUp(MouseEvent arg0) {
            }
        });
    }

    public Clipboard getClipboard() {
        if (this.clipboard == null) {
            this.clipboard = new Clipboard(this.getSite().getShell().getDisplay());
        }
        return this.clipboard;
    }

    public void setFocus() {
        this.tableViewer.getControl().setFocus();
    }

    public void dispose() {
        if (this.clipboard != null) {
            this.clipboard.dispose();
        }
        super.dispose();
    }

    private class RecreateMarkers
    extends WorkspaceJob {
        private RecreateMarkers() {
            super("Updating Fortran Analysis/Refactoring Problems view");
        }

        public IStatus runInWorkspace(IProgressMonitor monitor) {
            final List markers = PhotranVPG.getInstance().recomputeErrorLogMarkers();
            VGPProblemView.this.getSite().getShell().getDisplay().syncExec(new Runnable(){

                public void run() {
                    Table t = VGPProblemView.this.tableViewer.getTable();
                    t.removeAll();
                    t.update();
                    VGPProblemView.this.tableViewer.setInput((Object)markers);
                    VGPProblemView.this.countMarkers(markers);
                    if (VGPProblemView.this.warningsMarkerFilterAction != null && VGPProblemView.this.errorsMarkerFilterAction != null) {
                        String warnStr = String.valueOf(String.valueOf(MARKER_COUNT[1])) + " Warnings";
                        String errStr = String.valueOf(String.valueOf(MARKER_COUNT[2])) + " Errors";
                        VGPProblemView.this.warningsMarkerFilterAction.setText(warnStr);
                        VGPProblemView.this.errorsMarkerFilterAction.setText(errStr);
                    }
                }
            });
            markersTask = null;
            return Status.OK_STATUS;
        }
    }
}

