/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rdt.ui.serviceproviders;

import org.eclipse.ptp.rdt.core.serviceproviders.IRemoteExecutionServiceProvider;
import org.eclipse.ptp.rdt.ui.messages.Messages;
import org.eclipse.ptp.remote.core.IRemoteConnection;
import org.eclipse.ptp.remote.core.IRemoteConnectionManager;
import org.eclipse.ptp.remote.core.IRemoteServices;
import org.eclipse.ptp.remote.core.PTPRemoteCorePlugin;
import org.eclipse.ptp.services.core.ServiceProvider;

public class RemoteBuildServiceProvider
extends ServiceProvider
implements IRemoteExecutionServiceProvider {
    public static final String REMOTE_BUILD_SERVICE_PROVIDER_REMOTE_TOOLS_PROVIDER_ID = "RemoteBuildServiceProvider.remoteToolsProviderID";
    public static final String REMOTE_BUILD_SERVICE_PROVIDER_REMOTE_TOOLS_CONNECTION_NAME = "RemoteBuildServiceProvider.remoteToolsConnectionName";
    public static final String ID = "org.eclipse.ptp.rdt.ui.RemoteBuildServiceProvider";
    public static final String SERVICE_ID = "org.eclipse.ptp.rdt.core.BuildService";
    public static final String NAME = Messages.getString("RemoteBuildServiceProvider.0");
    private IRemoteConnection fRemoteConnection = null;

    public String getConfigurationString() {
        if (this.isConfigured()) {
            return String.valueOf(this.getRemoteServices().getName()) + ": " + this.getRemoteConnectionName();
        }
        return null;
    }

    public IRemoteConnection getConnection() {
        IRemoteConnectionManager manager;
        IRemoteServices services;
        if (this.fRemoteConnection == null && this.getRemoteConnectionName() != null && (services = this.getRemoteServices()) != null && (manager = services.getConnectionManager()) != null) {
            this.fRemoteConnection = manager.getConnection(this.getRemoteConnectionName());
        }
        return this.fRemoteConnection;
    }

    public String getRemoteConnectionName() {
        return this.getString(REMOTE_BUILD_SERVICE_PROVIDER_REMOTE_TOOLS_CONNECTION_NAME, null);
    }

    public IRemoteServices getRemoteServices() {
        return PTPRemoteCorePlugin.getDefault().getRemoteServices(this.getRemoteToolsProviderID());
    }

    public String getRemoteToolsProviderID() {
        return this.getString(REMOTE_BUILD_SERVICE_PROVIDER_REMOTE_TOOLS_PROVIDER_ID, null);
    }

    public boolean isConfigured() {
        return this.getRemoteToolsProviderID() != null && this.getRemoteConnectionName() != null;
    }

    public void setRemoteToolsConnection(IRemoteConnection connection) {
        this.fRemoteConnection = connection;
        String name = "";
        if (connection != null) {
            name = connection.getName();
        }
        this.putString(REMOTE_BUILD_SERVICE_PROVIDER_REMOTE_TOOLS_CONNECTION_NAME, name);
    }

    public void setRemoteToolsProviderID(String id) {
        this.putString(REMOTE_BUILD_SERVICE_PROVIDER_REMOTE_TOOLS_PROVIDER_ID, id);
    }

    public String toString() {
        return "RemoteBuildServiceProvider(" + this.getRemoteConnectionName() + ")";
    }
}

