/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rdt.ui.wizards;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.ui.wizards.conversion.ConvertProjectWizardPage;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.ptp.rdt.core.RDTLog;
import org.eclipse.ptp.rdt.core.resources.RemoteNature;
import org.eclipse.ptp.rdt.ui.UIPlugin;
import org.eclipse.ptp.rdt.ui.messages.Messages;
import org.eclipse.ptp.services.core.IServiceConfiguration;
import org.eclipse.ptp.services.core.ServiceModelManager;
import org.eclipse.ptp.services.ui.widgets.ServiceProviderConfigurationWidget;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;

public class ConvertToRemoteWizardPage
extends ConvertProjectWizardPage {
    private static final String WZ_TITLE = "WizardProjectConversion.title";
    private static final String WZ_DESC = "WizardProjectConversion.description";
    ServiceProviderConfigurationWidget fServiceModelWidget;
    Group remoteServices;
    Map<IProject, IServiceConfiguration> projectConfigs = new HashMap<IProject, IServiceConfiguration>();

    public ConvertToRemoteWizardPage(String pageName) {
        super(pageName);
    }

    protected String getWzTitleResource() {
        return Messages.getString(WZ_TITLE);
    }

    protected String getWzDescriptionResource() {
        return Messages.getString(WZ_DESC);
    }

    public boolean isCandidate(IProject project) {
        boolean a = false;
        boolean b = false;
        boolean c = false;
        a = !project.isHidden();
        try {
            b = !project.hasNature("org.eclipse.ptp.rdt.core.remoteNature");
            c = !project.hasNature("org.eclipse.rse.ui.remoteSystemsTempNature");
        }
        catch (CoreException e) {
            RDTLog.logError((Throwable)e);
        }
        return a && b && c;
    }

    public void convertProject(IProject project, String bsId, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask(Messages.getString("WizardProjectConversion.monitor.convertingToRemoteProject"), 3);
        try {
            try {
                RemoteNature.addRemoteNature((IProject)project, (IProgressMonitor)monitor);
                this.configureServicesForRemoteProject(project);
            }
            catch (InvocationTargetException e) {
                RDTLog.logError((Throwable)e);
                monitor.done();
            }
            catch (InterruptedException e) {
                RDTLog.logError((Throwable)e);
                monitor.done();
            }
        }
        finally {
            monitor.done();
        }
    }

    public void convertProject(IProject project, IProgressMonitor monitor, String projectID) throws CoreException {
        monitor.beginTask(Messages.getString("WizardProjectConversion.monitor.convertingToRemoteProject"), 3);
        try {
            try {
                RemoteNature.addRemoteNature((IProject)project, (IProgressMonitor)monitor);
                this.configureServicesForRemoteProject(project);
            }
            catch (InvocationTargetException e) {
                RDTLog.logError((Throwable)e);
                monitor.done();
            }
            catch (InterruptedException e) {
                RDTLog.logError((Throwable)e);
                monitor.done();
            }
        }
        finally {
            monitor.done();
        }
    }

    protected void addToMainPage(Composite container) {
        this.remoteServices = new Group(container, 4);
        this.remoteServices.setText(Messages.getString("WizardProjectConversion.servicesTableLabel"));
        this.remoteServices.setLayout((Layout)new FillLayout());
        GridData data = new GridData(4, 4, true, true);
        data.heightHint = 300;
        this.remoteServices.setLayoutData((Object)data);
        this.fServiceModelWidget = new ServiceProviderConfigurationWidget((Composite)this.remoteServices, 0);
        this.tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent e) {
                IProject project = (IProject)((IStructuredSelection)e.getSelection()).getFirstElement();
                if (project != null) {
                    ConvertToRemoteWizardPage.this.changeProject(project);
                }
            }
        });
        this.tableViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent e) {
                IProject project = (IProject)e.getElement();
                if (e.getChecked() && project != null) {
                    ConvertToRemoteWizardPage.this.changeProject(project);
                }
            }
        });
    }

    public void doRun(IProgressMonitor monitor, String projectID, String bsId) throws CoreException {
        this.fServiceModelWidget.applyChangesToConfiguration();
        super.doRun(monitor, projectID, bsId);
        try {
            ServiceModelManager.getInstance().saveModelConfiguration();
        }
        catch (IOException e) {
            UIPlugin.log(e);
        }
    }

    private IServiceConfiguration getConfig(IProject project) {
        IServiceConfiguration config = this.projectConfigs.get(project);
        if (config == null) {
            config = ServiceModelManager.getInstance().newServiceConfiguration(project.getName());
            this.projectConfigs.put(project, config);
        }
        return config;
    }

    private void changeProject(IProject project) {
        IServiceConfiguration config = this.getConfig(project);
        this.fServiceModelWidget.applyChangesToConfiguration();
        this.fServiceModelWidget.setServiceConfiguration(config);
        this.remoteServices.setText(MessageFormat.format(Messages.getString("WizardProjectConversion.servicesTableForProjectLabel"), project.getName()));
        this.setPageComplete(true);
    }

    private void configureServicesForRemoteProject(IProject project) throws InvocationTargetException, InterruptedException {
        ServiceModelManager.getInstance().addConfiguration(project, this.getConfig(project));
    }
}

