/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.core.attributes;

import java.text.DateFormat;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import org.eclipse.ptp.core.attributes.AbstractAttribute;
import org.eclipse.ptp.core.attributes.DateAttributeDefinition;
import org.eclipse.ptp.core.attributes.IllegalValueException;
import org.eclipse.ptp.core.messages.Messages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DateAttribute
extends AbstractAttribute<Calendar, DateAttribute, DateAttributeDefinition> {
    private static DateFormat[] dateFormats = null;
    protected final Calendar value = Calendar.getInstance();

    public static void main(String[] args) throws IllegalValueException {
        Calendar cal = Calendar.getInstance();
        DateAttributeDefinition def = new DateAttributeDefinition("uniqId", "name", "desc", true, cal.getTime(), DateFormat.getDateTimeInstance());
        DateAttribute mda = def.create();
        mda.setValue(cal);
        System.out.println(mda.toString());
        String str = mda.toString();
        cal.add(2, 2);
        System.out.println(mda.toString());
        mda.setValueAsString(str);
        System.out.println(mda.toString());
    }

    private static DateFormat[] getDateFormats() {
        if (dateFormats != null) {
            return dateFormats;
        }
        Locale[] locals = DateFormat.getAvailableLocales();
        int[] nArray = new int[4];
        nArray[0] = 3;
        nArray[1] = 2;
        nArray[2] = 1;
        int[] styles = nArray;
        ArrayList<DateFormat> dfs = new ArrayList<DateFormat>(styles.length * styles.length * locals.length);
        int i = 0;
        while (i < locals.length) {
            int ds = 0;
            while (ds < styles.length) {
                int dateStyle = styles[ds];
                int ts = 0;
                while (ts < styles.length) {
                    int timeStyle = styles[ts];
                    dfs.add(DateFormat.getDateTimeInstance(dateStyle, timeStyle, locals[i]));
                    ++ts;
                }
                ++ds;
            }
            ++i;
        }
        dateFormats = dfs.toArray(new DateFormat[dfs.size()]);
        return dateFormats;
    }

    public DateAttribute(DateAttributeDefinition definition, Date initialValue) throws IllegalValueException {
        super(definition);
        this.setValue(initialValue);
    }

    public DateAttribute(DateAttributeDefinition definition, String initialValue) throws IllegalValueException {
        super(definition);
        this.setValueAsString(initialValue);
    }

    public DateFormat getDateFormat() {
        return ((DateAttributeDefinition)this.getDefinition()).getDateFormat();
    }

    public Date getDateValue() {
        return this.value.getTime();
    }

    @Override
    public Calendar getValue() {
        return (Calendar)this.value.clone();
    }

    @Override
    public String getValueAsString() {
        return this.getDateFormat().format(this.value);
    }

    @Override
    public boolean isValid(String string) {
        Date date = this.parseString(string);
        if (date == null) {
            return false;
        }
        if (date.compareTo(this.getMinDate()) < 0) {
            return false;
        }
        return date.compareTo(this.getMaxDate()) <= 0;
    }

    @Override
    public void setValue(Calendar calendar) throws IllegalValueException {
        this.setValue(calendar.getTime());
    }

    @Override
    public void setValue(Date date) throws IllegalValueException {
        this.value.setTime(date);
        if (date.compareTo(this.getMinDate()) < 0) {
            throw new IllegalValueException(Messages.DateAttribute_0);
        }
        if (date.compareTo(this.getMaxDate()) > 0) {
            throw new IllegalValueException(Messages.DateAttribute_1);
        }
    }

    @Override
    public void setValueAsString(String string) throws IllegalValueException {
        Date date = this.parseString(string);
        if (date == null) {
            throw new IllegalValueException(String.valueOf(Messages.DateAttribute_2) + string + Messages.DateAttribute_3);
        }
        if (date.compareTo(this.getMinDate()) < 0) {
            throw new IllegalValueException(String.valueOf(Messages.DateAttribute_4) + string + Messages.DateAttribute_5 + this.toString(this.getMinDate()));
        }
        if (date.compareTo(this.getMaxDate()) > 0) {
            throw new IllegalValueException(String.valueOf(Messages.DateAttribute_6) + string + Messages.DateAttribute_7 + this.toString(this.getMaxDate()));
        }
        this.value.setTime(date);
    }

    @Override
    public String toString() {
        return this.getValueAsString();
    }

    private Date getMaxDate() {
        return ((DateAttributeDefinition)this.getDefinition()).getMaxDate();
    }

    private Date getMinDate() {
        return ((DateAttributeDefinition)this.getDefinition()).getMinDate();
    }

    private Date parseString(String string) {
        Date date = null;
        ParsePosition parsePosition = new ParsePosition(0);
        date = this.getDateFormat().parse(string, parsePosition);
        if (date != null) {
            return date;
        }
        int i = 0;
        while (i < DateAttribute.getDateFormats().length) {
            parsePosition.setIndex(0);
            date = DateAttribute.getDateFormats()[i].parse(string, parsePosition);
            if (date != null) {
                return date;
            }
            ++i;
        }
        return date;
    }

    private String toString(Date date) {
        return this.getDateFormat().format(date);
    }

    @Override
    protected DateAttribute doCopy() {
        try {
            return new DateAttribute((DateAttributeDefinition)this.getDefinition(), this.value.getTime());
        }
        catch (IllegalValueException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected int doCompareTo(DateAttribute other) {
        return this.value.compareTo(other.value);
    }

    @Override
    protected boolean doEquals(DateAttribute other) {
        return this.value.equals(other.value);
    }

    @Override
    protected int doHashCode() {
        return this.value.hashCode();
    }
}

