/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.core.attributes;

import org.eclipse.ptp.core.attributes.AbstractAttribute;
import org.eclipse.ptp.core.attributes.IllegalValueException;
import org.eclipse.ptp.core.attributes.StringAttributeDefinition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class StringAttribute
extends AbstractAttribute<String, StringAttribute, StringAttributeDefinition> {
    private final StringBuffer value = new StringBuffer();

    public StringAttribute(StringAttributeDefinition description, String initialValue) {
        super(description);
        this.setValueAsString(initialValue);
    }

    @Override
    public synchronized String getValue() {
        return this.value.toString();
    }

    @Override
    public String getValueAsString() {
        return this.getValue();
    }

    @Override
    public boolean isValid(String string) {
        return true;
    }

    @Override
    public void setValue(String value) throws IllegalValueException {
        this.setValueAsString(value);
    }

    @Override
    public synchronized void setValueAsString(String string) {
        if (string == null) {
            string = "";
        }
        this.value.replace(0, this.value.length(), string);
    }

    @Override
    protected StringAttribute doCopy() {
        return new StringAttribute((StringAttributeDefinition)this.getDefinition(), this.value.toString());
    }

    @Override
    protected synchronized int doCompareTo(StringAttribute other) {
        return this.value.toString().compareTo(other.value.toString());
    }

    @Override
    protected synchronized boolean doEquals(StringAttribute other) {
        return this.value.equals(other.value);
    }

    @Override
    protected synchronized int doHashCode() {
        return this.value.hashCode();
    }
}

