/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.core.elements.attributes;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.ptp.core.attributes.IAttribute;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttributeIndexSet<A extends IAttribute<?, A, ?>> {
    private final Map<A, BitSet> indexSetMap = new HashMap<A, BitSet>();
    private final BitSet totalIndexSet;

    public AttributeIndexSet() {
        this.totalIndexSet = new BitSet();
    }

    public AttributeIndexSet(AttributeIndexSet<A> other) {
        this.totalIndexSet = (BitSet)other.totalIndexSet.clone();
        for (Map.Entry<A, BitSet> entry : other.indexSetMap.entrySet()) {
            IAttribute attr = (IAttribute)entry.getKey();
            this.indexSetMap.put(attr, (BitSet)entry.getValue().clone());
        }
    }

    public AttributeIndexSet(int nIndices) {
        this.totalIndexSet = new BitSet(nIndices);
    }

    public void clear() {
        this.totalIndexSet.clear();
        this.indexSetMap.clear();
    }

    public void clearAttributes(BitSet indices) {
        if (indices == null) {
            throw new NullPointerException("indices may not be null");
        }
        this.totalIndexSet.andNot(indices);
        ArrayList<Map.Entry<A, BitSet>> entrySet = new ArrayList<Map.Entry<A, BitSet>>(this.indexSetMap.entrySet());
        for (Map.Entry entry : entrySet) {
            BitSet indicesForAttr = (BitSet)entry.getValue();
            indicesForAttr.andNot(indices);
            if (!indicesForAttr.isEmpty()) continue;
            IAttribute attr = (IAttribute)entry.getKey();
            this.indexSetMap.remove(attr);
        }
    }

    public AttributeIndexSet<A> copy() {
        return new AttributeIndexSet<A>(this);
    }

    public A getAttribute(int index) {
        for (Map.Entry<A, BitSet> entry : this.indexSetMap.entrySet()) {
            BitSet indicesForATmp = entry.getValue();
            if (!indicesForATmp.get(index)) continue;
            IAttribute aTmp = (IAttribute)entry.getKey();
            return aTmp.copy();
        }
        return null;
    }

    public Set<A> getAttributes() {
        HashSet valueSet = new HashSet();
        for (IAttribute value : this.indexSetMap.keySet()) {
            valueSet.add(value.copy());
        }
        return valueSet;
    }

    public BitSet getIndexSet() {
        return (BitSet)this.totalIndexSet.clone();
    }

    public BitSet getIndexSet(A attribute) {
        if (attribute == null) {
            throw new NullPointerException("attribute may not be null");
        }
        BitSet bitSet = this.indexSetMap.get(attribute);
        if (bitSet == null) {
            return new BitSet();
        }
        return (BitSet)bitSet.clone();
    }

    public AttributeIndexSet<A> getSubset(BitSet indices) {
        AttributeIndexSet<A> subSet = new AttributeIndexSet<A>();
        subSet.totalIndexSet.or(this.totalIndexSet);
        subSet.totalIndexSet.and(indices);
        if (subSet.totalIndexSet.isEmpty()) {
            return subSet;
        }
        for (Map.Entry<A, BitSet> entry : this.indexSetMap.entrySet()) {
            BitSet indicesForATmp = (BitSet)entry.getValue().clone();
            indicesForATmp.and(indices);
            if (indicesForATmp.isEmpty()) continue;
            IAttribute aTmp = (IAttribute)entry.getKey();
            subSet.indexSetMap.put(aTmp, indicesForATmp);
        }
        return subSet;
    }

    public boolean intersects(BitSet indices) {
        return this.totalIndexSet.intersects(indices);
    }

    public boolean isEmpty() {
        return this.totalIndexSet.isEmpty();
    }

    /*
     * WARNING - void declaration
     */
    public void setAttribute(A attribute, BitSet indices) {
        void var4_8;
        if (attribute == null) {
            throw new NullPointerException("attribute may not be null");
        }
        if (indices == null) {
            throw new NullPointerException("indices may not be null");
        }
        this.totalIndexSet.or(indices);
        ArrayList<Map.Entry<A, BitSet>> entrySet = new ArrayList<Map.Entry<A, BitSet>>(this.indexSetMap.entrySet());
        for (Map.Entry entry : entrySet) {
            IAttribute aTmp = (IAttribute)entry.getKey();
            if (attribute.equals(aTmp)) continue;
            BitSet indicesForATmp = (BitSet)entry.getValue();
            indicesForATmp.andNot(indices);
            if (!indicesForATmp.isEmpty()) continue;
            this.indexSetMap.remove(aTmp);
        }
        BitSet bitSet = this.indexSetMap.get(attribute);
        if (bitSet == null) {
            BitSet bitSet2 = new BitSet(indices.cardinality());
            this.indexSetMap.put(attribute, bitSet2);
        }
        var4_8.or(indices);
    }
}

