/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.debug.core;

import java.util.BitSet;

public class TaskSet
extends BitSet {
    private static final long serialVersionUID = 8213303688193251561L;
    private int fNumberOfTasks;

    public TaskSet() {
        this.fNumberOfTasks = this.size();
    }

    public TaskSet(int ntasks) {
        super(ntasks);
        this.fNumberOfTasks = ntasks;
    }

    public TaskSet(int ntasks, String str) {
        super(ntasks);
        this.fromHexString(str);
        this.fNumberOfTasks = ntasks;
    }

    public void clear(int[] indices) throws IndexOutOfBoundsException {
        int i = 0;
        while (i < indices.length) {
            this.clear(indices[i]);
            ++i;
        }
    }

    public Object clone() {
        return super.clone();
    }

    public TaskSet copy() {
        return (TaskSet)this.clone();
    }

    public void set(int[] indices) throws IndexOutOfBoundsException {
        int i = 0;
        while (i < indices.length) {
            this.set(indices[i]);
            ++i;
        }
    }

    public int[] toArray() {
        int[] retValue = new int[this.cardinality()];
        int i = this.nextSetBit(0);
        int j = 0;
        while (i >= 0) {
            retValue[j] = i;
            i = this.nextSetBit(i + 1);
            ++j;
        }
        return retValue;
    }

    public String toHexString() {
        String res = "";
        if (this.isEmpty()) {
            res = "00";
        } else {
            int bytes = (this.taskSize() - 1) / 8 + 1;
            int bit = bytes * 8 - 1;
            int i = 0;
            while (i < bytes * 2) {
                int nib = 0;
                int mask = 8;
                while (mask > 0) {
                    if (this.get(bit--)) {
                        nib |= mask;
                    }
                    mask >>= 1;
                }
                res = String.valueOf(res) + Integer.toHexString(nib & 0xF);
                ++i;
            }
        }
        return res;
    }

    public String toString() {
        if (this.isEmpty()) {
            return "{}";
        }
        int[] bits = this.toArray();
        String msg = "{";
        int rangeStart = bits[0];
        msg = String.valueOf(msg) + rangeStart;
        boolean isContinue = false;
        int i = 1;
        while (i < bits.length) {
            if (rangeStart == bits[i] - 1) {
                rangeStart = bits[i];
                isContinue = true;
                if (i == bits.length - 1) {
                    msg = String.valueOf(msg) + "-" + bits[i];
                    break;
                }
            } else {
                if (isContinue) {
                    msg = String.valueOf(msg) + "-" + rangeStart;
                }
                msg = String.valueOf(msg) + "," + bits[i];
                isContinue = false;
                rangeStart = bits[i];
            }
            ++i;
        }
        return String.valueOf(msg) + "}";
    }

    public int taskSize() {
        return this.fNumberOfTasks;
    }

    private byte fromHex(byte b) {
        if (b >= 48 && b <= 57) {
            return (byte)(b - 48);
        }
        if (b >= 65 && b <= 70) {
            return (byte)(b - 65 + 10);
        }
        if (b >= 97 && b <= 102) {
            return (byte)(b - 97 + 10);
        }
        return 0;
    }

    private void fromHexString(String str) {
        byte[] chars = str.getBytes();
        int bit = 0;
        int i = chars.length - 1;
        while (i >= 0) {
            byte hex = this.fromHex(chars[i]);
            int mask = 1;
            while (mask <= 8) {
                if ((mask & hex) == mask) {
                    this.set(bit);
                }
                ++bit;
                mask <<= 1;
            }
            --i;
        }
    }
}

