/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.debug.core.pdi;

import java.util.Vector;
import java.util.concurrent.locks.ReentrantLock;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ptp.debug.core.PDebugUtils;
import org.eclipse.ptp.debug.core.PTPDebugCorePlugin;
import org.eclipse.ptp.debug.core.TaskSet;
import org.eclipse.ptp.debug.core.pdi.IPDIDebugger;
import org.eclipse.ptp.debug.core.pdi.IPDILocation;
import org.eclipse.ptp.debug.core.pdi.IPDISession;
import org.eclipse.ptp.debug.core.pdi.PDIException;
import org.eclipse.ptp.debug.core.pdi.event.IPDIEventFactory;
import org.eclipse.ptp.debug.core.pdi.manager.IPDIBreakpointManager;
import org.eclipse.ptp.debug.core.pdi.manager.IPDIEventManager;
import org.eclipse.ptp.debug.core.pdi.manager.IPDIEventRequestManager;
import org.eclipse.ptp.debug.core.pdi.manager.IPDIExpressionManager;
import org.eclipse.ptp.debug.core.pdi.manager.IPDIManagerFactory;
import org.eclipse.ptp.debug.core.pdi.manager.IPDIMemoryManager;
import org.eclipse.ptp.debug.core.pdi.manager.IPDIRegisterManager;
import org.eclipse.ptp.debug.core.pdi.manager.IPDISignalManager;
import org.eclipse.ptp.debug.core.pdi.manager.IPDISourceManager;
import org.eclipse.ptp.debug.core.pdi.manager.IPDITargetManager;
import org.eclipse.ptp.debug.core.pdi.manager.IPDITaskManager;
import org.eclipse.ptp.debug.core.pdi.manager.IPDIThreadManager;
import org.eclipse.ptp.debug.core.pdi.manager.IPDIVariableManager;
import org.eclipse.ptp.debug.core.pdi.messages.Messages;
import org.eclipse.ptp.debug.core.pdi.model.IPDIModelFactory;
import org.eclipse.ptp.debug.core.pdi.model.IPDISignal;
import org.eclipse.ptp.debug.core.pdi.model.IPDITarget;
import org.eclipse.ptp.debug.core.pdi.model.IPDIThread;
import org.eclipse.ptp.debug.core.pdi.model.aif.IAIF;
import org.eclipse.ptp.debug.core.pdi.request.IPDIRequestFactory;
import org.eclipse.ptp.debug.core.pdi.request.IPDIStartDebuggerRequest;

public class Session
implements IPDISession {
    private IPDIBreakpointManager breakpointManager;
    private IPDIEventManager eventManager;
    private IPDIEventRequestManager eventRequestManager;
    private IPDITaskManager taskManager;
    private IPDITargetManager targetManager;
    private IPDIThreadManager threadManager;
    private IPDIExpressionManager expressionManager;
    private IPDIVariableManager variableManager;
    private IPDISourceManager sourceManager;
    private IPDIMemoryManager memoryManager;
    private IPDISignalManager signalManager;
    private IPDIRegisterManager registerManager;
    private IPDIDebugger debugger = null;
    private String job_id;
    private int total_tasks = 0;
    private int status;
    private long timeout = 30000L;
    private NotifyJob notifyJob = null;
    private IPDIRequestFactory requestFactory;
    private IPDIEventFactory eventFactory;
    private IPDIModelFactory modelFactory;
    private final ReentrantLock waitLock = new ReentrantLock();
    private ILaunchConfiguration config = null;

    public Session(IPDIManagerFactory managerFactory, IPDIRequestFactory requestFactory, IPDIEventFactory eventFactory, IPDIModelFactory modelFactory, ILaunchConfiguration config, long timeout, IPDIDebugger debugger, String job_id, int total_tasks) throws PDIException {
        this.config = config;
        this.timeout = timeout;
        this.debugger = debugger;
        this.job_id = job_id;
        this.total_tasks = total_tasks;
        this.notifyJob = new NotifyJob();
        this.requestFactory = requestFactory;
        this.eventFactory = eventFactory;
        this.modelFactory = modelFactory;
        this.setEventRequestManager(managerFactory.newEventRequestManager(this));
        this.setEventManager(managerFactory.newEventManager(this));
        this.setTaskManager(managerFactory.newTaskManager(this));
        this.setTargetManager(managerFactory.newTargetManager(this));
        this.setThreadManager(managerFactory.newThreadManager(this));
        this.setBreakpointManager(managerFactory.newBreakpointManager(this));
        this.setExpressionManager(managerFactory.newExpressionManager(this));
        this.setVariableManager(managerFactory.newVariableManager(this));
        this.setSourceManager(managerFactory.newSourceManager(this));
        this.setMemeoryManager(managerFactory.newMemoryManager(this));
        this.setSignalManager(managerFactory.newSignalManager(this));
        this.setRegisterManager(managerFactory.newRegisterManager(this));
    }

    public ILaunchConfiguration getConfiguration() {
        return this.config;
    }

    public IPDIRequestFactory getRequestFactory() {
        return this.requestFactory;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setRequestTimeout(long timeout) {
        this.timeout = timeout;
    }

    public void connectToDebugger(IProgressMonitor monitor, String app, String path, String dir, String[] args) throws PDIException {
        this.setStatus(1);
        if (!this.getDebugger().isConnected(monitor)) {
            throw new PDIException(this.getTasks(), Messages.Session_0);
        }
        this.getDebugger().register(this.eventManager);
        monitor.beginTask(NLS.bind((String)Messages.Session_1, (Object)this.total_tasks), this.total_tasks);
        IPDIStartDebuggerRequest request = this.getRequestFactory().getStartDebuggerRequest(this.getTasks(), app, path, dir, args);
        this.eventRequestManager.addEventRequest(request);
        request.waitUntilCompleted(null, monitor);
        this.setStatus(2);
        this.eventManager.fireEvent(this.getEventFactory().newStartedEvent(this, this.getTasks()));
    }

    protected void setEventRequestManager(IPDIEventRequestManager manager) {
        this.eventRequestManager = manager;
    }

    protected void setEventManager(IPDIEventManager manager) {
        this.eventManager = manager;
    }

    protected void setTaskManager(IPDITaskManager manager) {
        this.taskManager = manager;
    }

    protected void setTargetManager(IPDITargetManager manager) {
        this.targetManager = manager;
    }

    protected void setThreadManager(IPDIThreadManager manager) {
        this.threadManager = manager;
    }

    protected void setBreakpointManager(IPDIBreakpointManager manager) {
        this.breakpointManager = manager;
    }

    protected void setExpressionManager(IPDIExpressionManager manager) {
        this.expressionManager = manager;
    }

    protected void setVariableManager(IPDIVariableManager manager) {
        this.variableManager = manager;
    }

    protected void setSourceManager(IPDISourceManager manager) {
        this.sourceManager = manager;
    }

    protected void setMemeoryManager(IPDIMemoryManager manager) {
        this.memoryManager = manager;
    }

    protected void setSignalManager(IPDISignalManager manager) {
        this.signalManager = manager;
    }

    protected void setRegisterManager(IPDIRegisterManager manager) {
        this.registerManager = manager;
    }

    public IPDIEventRequestManager getEventRequestManager() {
        return this.eventRequestManager;
    }

    public IPDIEventManager getEventManager() {
        return this.eventManager;
    }

    public IPDITaskManager getTaskManager() {
        return this.taskManager;
    }

    public IPDIThreadManager getThreadManager() {
        return this.threadManager;
    }

    public IPDITargetManager getTargetManager() {
        return this.targetManager;
    }

    public IPDIBreakpointManager getBreakpointManager() {
        return this.breakpointManager;
    }

    public IPDIExpressionManager getExpressionManager() {
        return this.expressionManager;
    }

    public IPDIVariableManager getVariableManager() {
        return this.variableManager;
    }

    public IPDISourceManager getSourceManager() {
        return this.sourceManager;
    }

    public IPDIMemoryManager getMemoryManager() {
        return this.memoryManager;
    }

    public IPDISignalManager getSignalManager() {
        return this.signalManager;
    }

    public IPDIRegisterManager getRegisterManager() {
        return this.registerManager;
    }

    public void shutdown(boolean force) {
        try {
            try {
                if (!force) {
                    this.exit();
                } else {
                    this.setStatus(4);
                }
                this.debugger.disconnect(this.eventManager);
            }
            catch (PDIException e) {
                e.printStackTrace();
                this.variableManager.shutdown();
                this.expressionManager.shutdown();
                this.breakpointManager.shutdown();
                this.eventManager.shutdown();
                this.sourceManager.shutdown();
                this.taskManager.shutdown();
                this.targetManager.shutdown();
                this.threadManager.shutdown();
                this.memoryManager.shutdown();
                this.signalManager.shutdown();
                this.eventRequestManager.shutdown();
                this.notifyJob.schedule();
            }
        }
        finally {
            this.variableManager.shutdown();
            this.expressionManager.shutdown();
            this.breakpointManager.shutdown();
            this.eventManager.shutdown();
            this.sourceManager.shutdown();
            this.taskManager.shutdown();
            this.targetManager.shutdown();
            this.threadManager.shutdown();
            this.memoryManager.shutdown();
            this.signalManager.shutdown();
            this.eventRequestManager.shutdown();
            this.notifyJob.schedule();
        }
    }

    public void restart(TaskSet tasks) throws PDIException {
        this.checkStatus();
        throw new PDIException(tasks, Messages.Session_2);
    }

    public void start(TaskSet tasks) throws PDIException {
        this.checkStatus();
        this.getEventRequestManager().addEventRequest(this.getRequestFactory().getResumeRequest(tasks, false));
    }

    public void resume(TaskSet tasks, boolean passSignal) throws PDIException {
        this.checkStatus();
        if (passSignal) {
            throw new PDIException(tasks, Messages.Session_3);
        }
        this.taskManager.getSuspendedTasks(tasks);
        if (tasks.isEmpty()) {
            throw new PDIException(tasks, Messages.Session_4);
        }
        this.getEventRequestManager().addEventRequest(this.getRequestFactory().getResumeRequest(tasks, passSignal));
    }

    public void resume(TaskSet tasks, IPDILocation location) throws PDIException {
        this.checkStatus();
        this.taskManager.getSuspendedTasks(tasks);
        if (tasks.isEmpty()) {
            throw new PDIException(tasks, Messages.Session_4);
        }
        throw new PDIException(tasks, Messages.Session_5);
    }

    public void resume(TaskSet tasks, IPDISignal signal) throws PDIException {
        this.checkStatus();
        this.taskManager.getSuspendedTasks(tasks);
        if (tasks.isEmpty()) {
            throw new PDIException(tasks, Messages.Session_4);
        }
        throw new PDIException(tasks, Messages.Session_6);
    }

    public void stepInto(TaskSet tasks, int count) throws PDIException {
        this.checkStatus();
        this.taskManager.getSuspendedTasks(tasks);
        if (tasks.isEmpty()) {
            throw new PDIException(tasks, Messages.Session_4);
        }
        this.getEventRequestManager().addEventRequest(this.getRequestFactory().getStepIntoRequest(tasks, count));
    }

    public void stepIntoInstruction(TaskSet tasks, int count) throws PDIException {
        this.checkStatus();
        this.taskManager.getSuspendedTasks(tasks);
        if (tasks.isEmpty()) {
            throw new PDIException(tasks, Messages.Session_4);
        }
        throw new PDIException(tasks, Messages.Session_7);
    }

    public void stepOver(TaskSet tasks, int count) throws PDIException {
        this.checkStatus();
        this.taskManager.getSuspendedTasks(tasks);
        if (tasks.isEmpty()) {
            throw new PDIException(tasks, Messages.Session_4);
        }
        this.getEventRequestManager().addEventRequest(this.getRequestFactory().getStepOverRequest(tasks, count));
    }

    public void stepOverInstruction(TaskSet tasks, int count) throws PDIException {
        this.checkStatus();
        this.taskManager.getSuspendedTasks(tasks);
        if (tasks.isEmpty()) {
            throw new PDIException(tasks, Messages.Session_4);
        }
        throw new PDIException(tasks, Messages.Session_8);
    }

    public void stepReturn(TaskSet tasks, IAIF aif) throws PDIException {
        this.checkStatus();
        this.taskManager.getSuspendedTasks(tasks);
        if (tasks.isEmpty()) {
            throw new PDIException(tasks, Messages.Session_4);
        }
        throw new PDIException(tasks, Messages.Session_9);
    }

    public void stepReturn(TaskSet tasks, int count) throws PDIException {
        this.checkStatus();
        this.taskManager.getCanStepReturnTasks(tasks);
        if (tasks.isEmpty()) {
            throw new PDIException(tasks, Messages.Session_4);
        }
        this.getEventRequestManager().addEventRequest(this.getRequestFactory().getStepFinishRequest(tasks, count));
    }

    public void stepUntil(TaskSet tasks, IPDILocation location) throws PDIException {
        this.checkStatus();
        this.taskManager.getSuspendedTasks(tasks);
        if (tasks.isEmpty()) {
            throw new PDIException(tasks, Messages.Session_4);
        }
        throw new PDIException(tasks, Messages.Session_10);
    }

    public void suspend(TaskSet tasks) throws PDIException {
        this.checkStatus();
        this.taskManager.getRunningTasks(tasks);
        if (tasks.isEmpty()) {
            throw new PDIException(tasks, Messages.Session_11);
        }
        this.getEventRequestManager().addEventRequest(this.getRequestFactory().getSuspendRequest(tasks));
    }

    public void terminate(TaskSet tasks) throws PDIException {
        this.checkStatus();
        this.taskManager.getNonTerminatedTasks(tasks);
        if (tasks.isEmpty()) {
            throw new PDIException(tasks, Messages.Session_12);
        }
        TaskSet nonTerTasks = tasks.copy();
        this.taskManager.getRunningTasks(nonTerTasks);
        if (!nonTerTasks.isEmpty()) {
            this.getEventRequestManager().addEventRequest(this.getRequestFactory().getSuspendRequest(nonTerTasks, false));
        }
        this.getEventRequestManager().addEventRequest(this.getRequestFactory().getTerminateRequest(tasks));
        this.taskManager.setPendingTasks(true, tasks);
    }

    public void validateStepReturn(TaskSet tasks) throws PDIException {
    }

    public void exit() throws PDIException {
        if (this.status != 4 && this.status != 5) {
            this.setStatus(4);
            this.eventRequestManager.cleanEventRequests();
            TaskSet tasks = this.getTasks();
            this.taskManager.getRunningTasks(tasks);
            if (!tasks.isEmpty()) {
                this.getEventRequestManager().addEventRequest(this.getRequestFactory().getSuspendRequest(tasks, false));
            }
            tasks = this.getTasks();
            this.taskManager.getNonTerminatedTasks(tasks);
            if (!tasks.isEmpty()) {
                this.getEventRequestManager().addEventRequest(this.getRequestFactory().getTerminateRequest(tasks));
            }
            this.getEventRequestManager().addEventRequest(this.getRequestFactory().getStopDebuggerRequest(new TaskSet(this.total_tasks)));
            this.taskManager.setPendingTasks(true, tasks);
        }
    }

    public IPDIDebugger getDebugger() {
        return this.debugger;
    }

    public String getJobID() {
        return this.job_id;
    }

    public boolean isTerminated(TaskSet tasks) {
        return this.taskManager.isAllTerminated(tasks);
    }

    public boolean isSuspended(TaskSet tasks) {
        return this.taskManager.isAllSuspended(tasks);
    }

    public boolean isRunning(TaskSet tasks) {
        return this.taskManager.isAllRunning(tasks);
    }

    public TaskSet getTasks() {
        TaskSet tasks = new TaskSet(this.total_tasks);
        tasks.set(0, this.total_tasks);
        return tasks;
    }

    public int getTotalTasks() {
        return this.total_tasks;
    }

    public IPDISession getSession() {
        return this;
    }

    public void setStatus(int status) {
        this.waitLock.lock();
        try {
            this.status = status;
        }
        finally {
            this.waitLock.unlock();
        }
    }

    public int getStatus() {
        return this.status;
    }

    protected void checkStatus() throws PDIException {
        if (this.status == 4 || this.status == 5) {
            throw new PDIException(null, Messages.Session_13);
        }
    }

    public IPDITarget findTarget(TaskSet qTasks) throws PDIException {
        IPDITarget target = this.targetManager.getTarget(qTasks);
        if (target == null) {
            throw new PDIException(qTasks, Messages.Session_14);
        }
        return target;
    }

    public boolean isTarget(TaskSet qTasks) {
        return this.targetManager.getTarget(qTasks) != null;
    }

    public synchronized void processRunningEvent(TaskSet tasks) {
        IPDITarget[] targets;
        IPDITarget[] iPDITargetArray = targets = this.targetManager.getTargets();
        int n = targets.length;
        int n2 = 0;
        while (n2 < n) {
            final IPDITarget target = iPDITargetArray[n2];
            if (target.getTasks().intersects(tasks)) {
                Runnable runnable = new Runnable(){

                    public void run() {
                        target.setSupended(false);
                    }
                };
                this.queueRunnable(runnable);
            }
            ++n2;
        }
    }

    public synchronized void processSupsendedEvent(TaskSet tasks, final int thread_id, final String[] vars) {
        IPDITarget[] targets;
        IPDITarget[] iPDITargetArray = targets = this.targetManager.getTargets();
        int n = targets.length;
        int n2 = 0;
        while (n2 < n) {
            final IPDITarget target = iPDITargetArray[n2];
            if (target.getTasks().intersects(tasks)) {
                Runnable runnable = new Runnable(){

                    public void run() {
                        target.setSupended(true);
                        target.updateState(thread_id);
                        try {
                            IPDIThread pthread = target.getCurrentThread();
                            if (pthread == null) {
                                return;
                            }
                            pthread.getCurrentStackFrame();
                        }
                        catch (PDIException pDIException) {
                            return;
                        }
                        try {
                            if (Session.this.variableManager.isAutoUpdate()) {
                                Session.this.variableManager.update(target.getTasks(), vars);
                            }
                            if (Session.this.expressionManager.isAutoUpdate()) {
                                Session.this.expressionManager.update(target.getTasks(), vars);
                            }
                            if (Session.this.registerManager.isAutoUpdate()) {
                                Session.this.registerManager.update(target.getTasks());
                            }
                            if (Session.this.memoryManager.isAutoUpdate()) {
                                Session.this.memoryManager.update(target.getTasks());
                            }
                            if (Session.this.breakpointManager.isAutoUpdate()) {
                                Session.this.breakpointManager.update(target.getTasks());
                            }
                            if (Session.this.signalManager.isAutoUpdate()) {
                                Session.this.signalManager.update(target.getTasks());
                            }
                            if (Session.this.sourceManager.isAutoUpdate()) {
                                Session.this.sourceManager.update(target.getTasks());
                            }
                        }
                        catch (PDIException pDIException) {
                            return;
                        }
                    }
                };
                this.queueRunnable(runnable);
            }
            ++n2;
        }
    }

    public void queueRunnable(Runnable runnable) {
        this.notifyJob.addRunnable(runnable);
    }

    public IPDIEventFactory getEventFactory() {
        return this.eventFactory;
    }

    public IPDIModelFactory getModelFactory() {
        return this.modelFactory;
    }

    class NotifyJob
    extends Job {
        private Vector<Runnable> fRunnables;

        public NotifyJob() {
            super(Messages.Session_15);
            this.setSystem(true);
            this.fRunnables = new Vector(10);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addRunnable(Runnable runnable) {
            Vector<Runnable> vector = this.fRunnables;
            synchronized (vector) {
                this.fRunnables.add(runnable);
            }
            this.schedule();
        }

        public boolean shouldRun() {
            return !this.fRunnables.isEmpty();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public IStatus run(IProgressMonitor monitor) {
            Runnable[] runnables;
            Vector<Runnable> vector = this.fRunnables;
            synchronized (vector) {
                runnables = this.fRunnables.toArray(new Runnable[0]);
                this.fRunnables.clear();
            }
            MultiStatus failed = null;
            monitor.beginTask(this.getName(), runnables.length);
            PDebugUtils.println(String.valueOf(Messages.Session_16) + runnables.length);
            Runnable[] runnableArray = runnables;
            int n = runnables.length;
            int n2 = 0;
            while (n2 < n) {
                Runnable runnable = runnableArray[n2];
                try {
                    runnable.run();
                }
                catch (Exception e) {
                    if (failed == null) {
                        failed = new MultiStatus(PTPDebugCorePlugin.getUniqueIdentifier(), 1000, Messages.Session_17, null);
                    }
                    failed.add((IStatus)new Status(4, PTPDebugCorePlugin.getUniqueIdentifier(), 1000, Messages.Session_17, (Throwable)e));
                }
                monitor.worked(1);
                ++n2;
            }
            monitor.done();
            if (failed == null) {
                return Status.OK_STATUS;
            }
            return failed;
        }
    }
}

