/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.debug.core.pdi.model.aif;

import java.util.Random;
import org.eclipse.ptp.debug.core.PDebugUtils;
import org.eclipse.ptp.debug.core.pdi.messages.Messages;
import org.eclipse.ptp.debug.core.pdi.model.aif.IAIF;
import org.eclipse.ptp.debug.core.pdi.model.aif.IAIFType;
import org.eclipse.ptp.debug.core.pdi.model.aif.IAIFTypeAddress;
import org.eclipse.ptp.debug.core.pdi.model.aif.IAIFTypeArray;
import org.eclipse.ptp.debug.core.pdi.model.aif.IAIFTypeBool;
import org.eclipse.ptp.debug.core.pdi.model.aif.IAIFTypeChar;
import org.eclipse.ptp.debug.core.pdi.model.aif.IAIFTypeCharPointer;
import org.eclipse.ptp.debug.core.pdi.model.aif.IAIFTypeClass;
import org.eclipse.ptp.debug.core.pdi.model.aif.IAIFTypeEnum;
import org.eclipse.ptp.debug.core.pdi.model.aif.IAIFTypeFloat;
import org.eclipse.ptp.debug.core.pdi.model.aif.IAIFTypeInt;
import org.eclipse.ptp.debug.core.pdi.model.aif.IAIFTypeNamed;
import org.eclipse.ptp.debug.core.pdi.model.aif.IAIFTypePointer;
import org.eclipse.ptp.debug.core.pdi.model.aif.IAIFTypeReference;
import org.eclipse.ptp.debug.core.pdi.model.aif.IAIFTypeString;
import org.eclipse.ptp.debug.core.pdi.model.aif.IAIFTypeStruct;
import org.eclipse.ptp.debug.core.pdi.model.aif.IAIFTypeUnion;
import org.eclipse.ptp.debug.core.pdi.model.aif.IAIFTypeVoid;
import org.eclipse.ptp.debug.core.pdi.model.aif.IAIFValue;
import org.eclipse.ptp.debug.core.pdi.model.aif.IValueParent;
import org.eclipse.ptp.debug.internal.core.pdi.aif.AIF;
import org.eclipse.ptp.debug.internal.core.pdi.aif.AIFTypeAddress;
import org.eclipse.ptp.debug.internal.core.pdi.aif.AIFTypeArray;
import org.eclipse.ptp.debug.internal.core.pdi.aif.AIFTypeBool;
import org.eclipse.ptp.debug.internal.core.pdi.aif.AIFTypeChar;
import org.eclipse.ptp.debug.internal.core.pdi.aif.AIFTypeCharPointer;
import org.eclipse.ptp.debug.internal.core.pdi.aif.AIFTypeClass;
import org.eclipse.ptp.debug.internal.core.pdi.aif.AIFTypeEnum;
import org.eclipse.ptp.debug.internal.core.pdi.aif.AIFTypeFloat;
import org.eclipse.ptp.debug.internal.core.pdi.aif.AIFTypeFunction;
import org.eclipse.ptp.debug.internal.core.pdi.aif.AIFTypeIncomplete;
import org.eclipse.ptp.debug.internal.core.pdi.aif.AIFTypeInt;
import org.eclipse.ptp.debug.internal.core.pdi.aif.AIFTypeNamed;
import org.eclipse.ptp.debug.internal.core.pdi.aif.AIFTypePointer;
import org.eclipse.ptp.debug.internal.core.pdi.aif.AIFTypeReference;
import org.eclipse.ptp.debug.internal.core.pdi.aif.AIFTypeString;
import org.eclipse.ptp.debug.internal.core.pdi.aif.AIFTypeStruct;
import org.eclipse.ptp.debug.internal.core.pdi.aif.AIFTypeUnion;
import org.eclipse.ptp.debug.internal.core.pdi.aif.AIFTypeVoid;
import org.eclipse.ptp.debug.internal.core.pdi.aif.AIFValueAddress;
import org.eclipse.ptp.debug.internal.core.pdi.aif.AIFValueArray;
import org.eclipse.ptp.debug.internal.core.pdi.aif.AIFValueBool;
import org.eclipse.ptp.debug.internal.core.pdi.aif.AIFValueChar;
import org.eclipse.ptp.debug.internal.core.pdi.aif.AIFValueCharPointer;
import org.eclipse.ptp.debug.internal.core.pdi.aif.AIFValueClass;
import org.eclipse.ptp.debug.internal.core.pdi.aif.AIFValueEnum;
import org.eclipse.ptp.debug.internal.core.pdi.aif.AIFValueFloat;
import org.eclipse.ptp.debug.internal.core.pdi.aif.AIFValueInt;
import org.eclipse.ptp.debug.internal.core.pdi.aif.AIFValueNamed;
import org.eclipse.ptp.debug.internal.core.pdi.aif.AIFValuePointer;
import org.eclipse.ptp.debug.internal.core.pdi.aif.AIFValueReference;
import org.eclipse.ptp.debug.internal.core.pdi.aif.AIFValueString;
import org.eclipse.ptp.debug.internal.core.pdi.aif.AIFValueStruct;
import org.eclipse.ptp.debug.internal.core.pdi.aif.AIFValueUnion;
import org.eclipse.ptp.debug.internal.core.pdi.aif.AIFValueUnknown;
import org.eclipse.ptp.debug.internal.core.pdi.aif.AIFValueVoid;

public class AIFFactory {
    public static final char FDS_ARRAY = '[';
    public static final char FDS_BOOL = 'b';
    public static final char FDS_CHAR = 'c';
    public static final char FDS_ENUM = '<';
    public static final char FDS_FLOAT = 'f';
    public static final char FDS_FUNCTION = '&';
    public static final char FDS_INT = 'i';
    public static final char FDS_POINTER = '^';
    public static final char FDS_STRING = 's';
    public static final char FDS_STRUCT_CLASS = '{';
    public static final char FDS_UNION = '(';
    public static final char FDS_VOID = 'v';
    public static final char FDS_REFERENCE = '>';
    public static final char FDS_NAMED = '%';
    public static final char FDS_ADDRESS = 'a';
    public static final char FDS_CHAR_POINTER = 'p';
    public static final int FDS_FLOAT_SIZE_POS = 1;
    public static final int FDS_VOID_SIZE_POS = 1;
    public static final int FDS_INTEGER_SIGN_POS = 1;
    public static final int FDS_INTEGER_SIZE_POS = 2;
    public static final int FDS_RANGE_DOT_LEN = 2;
    public static final String SIGN_OPEN = "[";
    public static final String SIGN_CLOSE = "]";
    public static final String SIGN_STROKE = "|";
    public static final String SIGN_COMMA = ",";
    public static final String SIGN_EQUAL = "=";
    public static final String SIGN_SEMI_COLON = ";";
    public static final String SIGN_COLON = ":";
    public static final String SIGN_DOT = ".";
    public static final String FDS_STRUCT_END = ";;;}";
    public static final String FDS_CLASS_END = "}";
    public static final String FDS_UNION_END = ")";
    public static final String FDS_ENUM_END = ">";
    public static final String FDS_FUNCTION_END = "/";
    public static final String FDS_REFERENCE_END = "/";
    public static final String FDS_NAMED_END = "/";
    public static final int NO_SIZE = 0;
    public static final int SIZE_BOOL = 1;
    public static final int SIZE_CHAR = 1;
    public static final int SIZE_FLOAT = 4;
    public static final int SIZE_DOUBLE = 8;
    public static final int SIZE_INVALID = 0;
    public static final IAIFType UNKNOWNTYPE = new AIFTypeIncomplete();
    public static final IAIFValue UNKNOWNVALUE = new AIFValueUnknown(UNKNOWNTYPE);

    public static String extractFormat(String fmt, int start_pos, int end_pos) {
        return fmt.substring(start_pos, end_pos);
    }

    public static IAIF newAIF(String fds, byte[] data, String description) {
        return new AIF(fds, data, description);
    }

    public static IAIF newAIF(IAIFType aifType, IAIFValue aifValue) {
        return new AIF(aifType, aifValue);
    }

    public static IAIF newAIF(String fds, byte[] data) {
        return new AIF(fds, data);
    }

    public static IAIFType getAIFType(String fmt) {
        if (fmt == null || fmt.length() == 0) {
            PDebugUtils.println(String.valueOf(Messages.AIFFactory_0) + fmt);
            return UNKNOWNTYPE;
        }
        switch (fmt.charAt(0)) {
            case 'c': {
                PDebugUtils.println(String.valueOf(Messages.AIFFactory_1) + fmt);
                return new AIFTypeChar();
            }
            case 'f': {
                int float_size = Character.digit(fmt.charAt(1), 10);
                PDebugUtils.println(String.valueOf(Messages.AIFFactory_2) + fmt + Messages.AIFFactory_3 + float_size);
                return new AIFTypeFloat(float_size);
            }
            case 'i': {
                boolean signed = fmt.charAt(1) == 's';
                int int_size = Character.digit(fmt.charAt(2), 10);
                PDebugUtils.println(String.valueOf(Messages.AIFFactory_4) + fmt + Messages.AIFFactory_5 + int_size);
                return new AIFTypeInt(signed, int_size);
            }
            case 'p': {
                PDebugUtils.println(String.valueOf(Messages.AIFFactory_6) + fmt);
                return new AIFTypeCharPointer(AIFFactory.getAIFType(fmt.substring(1, 3)));
            }
            case 's': {
                PDebugUtils.println(String.valueOf(Messages.AIFFactory_7) + fmt);
                return new AIFTypeString();
            }
            case 'b': {
                PDebugUtils.println(String.valueOf(Messages.AIFFactory_8) + fmt);
                return new AIFTypeBool();
            }
            case '<': {
                PDebugUtils.println(String.valueOf(Messages.AIFFactory_9) + fmt);
                int enum_end_pos = AIFFactory.getEndPosFromLast(fmt, FDS_ENUM_END);
                String enum_type = fmt.substring(enum_end_pos + FDS_ENUM_END.length());
                return new AIFTypeEnum(AIFFactory.extractFormat(fmt, 1, enum_end_pos), AIFFactory.getAIFType(enum_type));
            }
            case '&': {
                PDebugUtils.println(String.valueOf(Messages.AIFFactory_10) + fmt);
                int func_end_pos = AIFFactory.getEndPosFromLast(fmt, "/");
                String func_type = fmt.substring(func_end_pos + "/".length());
                return new AIFTypeFunction(AIFFactory.extractFormat(fmt, 1, func_end_pos), AIFFactory.getAIFType(func_type));
            }
            case '{': {
                int struct_end_pos = AIFFactory.getEndPosFromLast(fmt, FDS_STRUCT_END);
                if (fmt.length() == struct_end_pos + FDS_STRUCT_END.length()) {
                    PDebugUtils.println(String.valueOf(Messages.AIFFactory_11) + fmt);
                    return new AIFTypeStruct(AIFFactory.extractFormat(fmt, 1, struct_end_pos));
                }
                struct_end_pos = AIFFactory.getEndPosFromLast(fmt, FDS_CLASS_END);
                PDebugUtils.println(String.valueOf(Messages.AIFFactory_12) + fmt);
                return new AIFTypeClass(AIFFactory.extractFormat(fmt, 1, struct_end_pos));
            }
            case '(': {
                PDebugUtils.println(String.valueOf(Messages.AIFFactory_13) + fmt);
                int union_end_pos = AIFFactory.getEndPosFromLast(fmt, FDS_UNION_END);
                return new AIFTypeUnion(AIFFactory.extractFormat(fmt, 1, union_end_pos));
            }
            case '>': {
                PDebugUtils.println(String.valueOf(Messages.AIFFactory_14) + fmt);
                int ref_end_pos = AIFFactory.getEndPosFromStart(fmt, "/");
                return new AIFTypeReference(AIFFactory.extractFormat(fmt, 1, ref_end_pos));
            }
            case 'a': {
                PDebugUtils.println(String.valueOf(Messages.AIFFactory_15) + fmt);
                return new AIFTypeAddress(Character.digit(fmt.charAt(1), 10));
            }
            case '^': {
                PDebugUtils.println(String.valueOf(Messages.AIFFactory_16) + fmt);
                return new AIFTypePointer(AIFFactory.getAIFType(fmt.substring(1, 3)), AIFFactory.getAIFType(fmt.substring(3)));
            }
            case 'v': {
                PDebugUtils.println(String.valueOf(Messages.AIFFactory_17) + fmt);
                int void_size = Character.digit(fmt.charAt(1), 10);
                return new AIFTypeVoid(void_size);
            }
            case '[': {
                PDebugUtils.println(String.valueOf(Messages.AIFFactory_18) + fmt);
                int array_end_pos = AIFFactory.getEndPosFromStart(fmt, SIGN_CLOSE);
                return new AIFTypeArray(AIFFactory.extractFormat(fmt, 1, array_end_pos), AIFFactory.getAIFType(fmt.substring(array_end_pos + 1)));
            }
            case '%': {
                PDebugUtils.println(String.valueOf(Messages.AIFFactory_19) + fmt);
                int named_end_pos = AIFFactory.getEndPosFromStart(fmt, "/");
                return new AIFTypeNamed(AIFFactory.extractFormat(fmt, 1, named_end_pos), AIFFactory.getAIFType(fmt.substring(named_end_pos + 1)));
            }
        }
        PDebugUtils.println(String.valueOf(Messages.AIFFactory_20) + fmt);
        return new AIFTypeIncomplete();
    }

    public static IAIFValue getAIFValue(IValueParent parent, IAIFType type, byte[] data) {
        if (data == null || data.length < 0) {
            return new AIFValueUnknown(type);
        }
        return AIFFactory.getAIFValue(parent, type, new SimpleByteBuffer(data));
    }

    public static IAIFValue getAIFValue(IValueParent parent, IAIFType type, SimpleByteBuffer buffer) {
        if (buffer.end()) {
            return new AIFValueUnknown(type);
        }
        if (type instanceof IAIFTypeChar) {
            return new AIFValueChar((IAIFTypeChar)type, buffer);
        }
        if (type instanceof IAIFTypeFloat) {
            return new AIFValueFloat((IAIFTypeFloat)type, buffer);
        }
        if (type instanceof IAIFTypeInt) {
            return new AIFValueInt((IAIFTypeInt)type, buffer);
        }
        if (type instanceof IAIFTypeCharPointer) {
            return new AIFValueCharPointer((IAIFTypeCharPointer)type, buffer);
        }
        if (type instanceof IAIFTypeString) {
            return new AIFValueString((IAIFTypeString)type, buffer);
        }
        if (type instanceof IAIFTypeBool) {
            return new AIFValueBool((IAIFTypeBool)type, buffer);
        }
        if (type instanceof IAIFTypeArray) {
            return new AIFValueArray((IAIFTypeArray)type, buffer);
        }
        if (type instanceof IAIFTypeEnum) {
            return new AIFValueEnum((IAIFTypeEnum)type, buffer);
        }
        if (type instanceof IAIFTypeAddress) {
            return new AIFValueAddress((IAIFTypeAddress)type, buffer);
        }
        if (type instanceof IAIFTypePointer) {
            return new AIFValuePointer(parent, (IAIFTypePointer)type, buffer);
        }
        if (type instanceof IAIFTypeNamed) {
            return new AIFValueNamed(parent, (IAIFTypeNamed)type, buffer);
        }
        if (type instanceof IAIFTypeReference) {
            return new AIFValueReference(parent, (IAIFTypeReference)type, buffer);
        }
        if (type instanceof IAIFTypeStruct) {
            return new AIFValueStruct(parent, (IAIFTypeStruct)type, buffer);
        }
        if (type instanceof IAIFTypeUnion) {
            return new AIFValueUnion(parent, (IAIFTypeUnion)type, buffer);
        }
        if (type instanceof IAIFTypeClass) {
            return new AIFValueClass(parent, (IAIFTypeClass)type, buffer);
        }
        if (type instanceof IAIFTypeVoid) {
            return new AIFValueVoid((IAIFTypeVoid)type, buffer);
        }
        return new AIFValueUnknown(type);
    }

    public static int getDigitPos(String format, int pos) {
        int len = format.length();
        while (pos < len) {
            char aChar = format.charAt(pos);
            if (!Character.isDigit(aChar)) break;
            ++pos;
        }
        return pos;
    }

    public static int getEndPosFromLast(String fmt, String regex) {
        return fmt.lastIndexOf(regex);
    }

    public static int getEndPosFromStart(String fmt, String regex) {
        return fmt.indexOf(regex);
    }

    public static int random_num(int min, int max) {
        Random generator = new Random();
        long range = (long)max - (long)min + 1L;
        long fraction = (long)((double)range * generator.nextDouble());
        return (int)(fraction + (long)min);
    }

    public static IAIF UNKNOWNAIF() {
        return new AIF(UNKNOWNTYPE, UNKNOWNVALUE);
    }

    public static class SimpleByteBuffer {
        byte[] bytes;
        int pos = 0;

        SimpleByteBuffer(byte[] bytes) {
            if (bytes == null) {
                bytes = new byte[]{};
            }
            this.bytes = bytes;
        }

        public boolean end() {
            return this.pos == this.bytes.length;
        }

        public byte get() {
            return this.bytes[this.pos++];
        }

        public byte get(int pos) {
            return this.bytes[pos];
        }

        public byte[] getByte() {
            return this.bytes;
        }

        public int getCapacity() {
            return this.bytes.length;
        }

        public int getPosition() {
            return this.pos;
        }

        public void setPos(int pos) {
            this.pos = pos;
        }
    }
}

