/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.debug.core.pdi.request;

import org.eclipse.osgi.util.NLS;
import org.eclipse.ptp.debug.core.TaskSet;
import org.eclipse.ptp.debug.core.pdi.IPDIDebugger;
import org.eclipse.ptp.debug.core.pdi.PDIException;
import org.eclipse.ptp.debug.core.pdi.messages.Messages;
import org.eclipse.ptp.debug.core.pdi.model.aif.IAIF;
import org.eclipse.ptp.debug.core.pdi.request.AbstractEventResultRequest;
import org.eclipse.ptp.debug.core.pdi.request.IPDIEvaluatePartialExpressionRequest;

public abstract class AbstractEvaluatePartialExpressionRequest
extends AbstractEventResultRequest
implements IPDIEvaluatePartialExpressionRequest {
    private String expr;
    private String exprId;
    private boolean listChildren = false;
    private boolean express = false;

    public AbstractEvaluatePartialExpressionRequest(TaskSet tasks, String expr, String exprId) {
        this(tasks, expr, exprId, false, exprId != null);
    }

    public AbstractEvaluatePartialExpressionRequest(TaskSet tasks, String expr, String exprId, boolean listChildren) {
        this(tasks, expr, exprId, listChildren, false);
    }

    public AbstractEvaluatePartialExpressionRequest(TaskSet tasks, String expr, String exprId, boolean listChildren, boolean express) {
        super(tasks);
        this.expr = expr;
        this.exprId = exprId;
        this.listChildren = listChildren;
        this.express = express;
    }

    public void doExecute(IPDIDebugger debugger) throws PDIException {
        debugger.evaluatePartialExpression(this.tasks, this.expr, this.exprId, this.listChildren, this.express);
    }

    public String getName() {
        return Messages.AbstractEvaluatePartialExpressionRequest_0;
    }

    public IAIF getPartialAIF(TaskSet qTasks) throws PDIException {
        this.waitUntilCompleted(qTasks);
        Object obj = this.getResult(qTasks);
        if (obj instanceof Object[]) {
            Object[] returnValues = (Object[])obj;
            return (IAIF)returnValues[1];
        }
        throw new PDIException(qTasks, NLS.bind((String)Messages.AbstractEvaluatePartialExpressionRequest_1, (Object)this.expr));
    }

    public String getId(TaskSet qTasks) throws PDIException {
        this.waitUntilCompleted(qTasks);
        Object obj = this.getResult(qTasks);
        if (obj instanceof Object[]) {
            Object[] returnValues = (Object[])obj;
            return (String)returnValues[0];
        }
        throw new PDIException(qTasks, NLS.bind((String)Messages.AbstractEvaluatePartialExpressionRequest_2, (Object)this.exprId));
    }

    public String toString() {
        return NLS.bind((String)Messages.AbstractEvaluatePartialExpressionRequest_3, (Object[])new Object[]{this.getName(), this.getTasks(), this.expr, this.exprId, this.listChildren, this.express});
    }
}

