/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.debug.internal.core.pdi.model;

import org.eclipse.ptp.debug.core.TaskSet;
import org.eclipse.ptp.debug.core.pdi.IPDISession;
import org.eclipse.ptp.debug.core.pdi.PDIException;
import org.eclipse.ptp.debug.core.pdi.messages.Messages;
import org.eclipse.ptp.debug.core.pdi.model.IPDIStackFrame;
import org.eclipse.ptp.debug.core.pdi.model.IPDIThread;
import org.eclipse.ptp.debug.core.pdi.model.IPDIVariable;
import org.eclipse.ptp.debug.core.pdi.model.IPDIVariableDescriptor;
import org.eclipse.ptp.debug.core.pdi.model.aif.AIFFactory;
import org.eclipse.ptp.debug.core.pdi.model.aif.IAIF;
import org.eclipse.ptp.debug.core.pdi.model.aif.IAIFType;
import org.eclipse.ptp.debug.core.pdi.model.aif.IAIFTypeArray;
import org.eclipse.ptp.debug.core.pdi.model.aif.IAIFTypePointer;
import org.eclipse.ptp.debug.core.pdi.model.aif.IAIFTypeReference;
import org.eclipse.ptp.debug.core.pdi.model.aif.IAIFValue;
import org.eclipse.ptp.debug.core.pdi.model.aif.IAIFValueArray;
import org.eclipse.ptp.debug.core.pdi.model.aif.ITypeAggregate;
import org.eclipse.ptp.debug.core.pdi.model.aif.ITypeDerived;
import org.eclipse.ptp.debug.core.pdi.model.aif.IValueAggregate;
import org.eclipse.ptp.debug.core.pdi.request.IPDIEvaluatePartialExpressionRequest;
import org.eclipse.ptp.debug.internal.core.pdi.model.Target;
import org.eclipse.ptp.debug.internal.core.pdi.model.Thread;
import org.eclipse.ptp.debug.internal.core.pdi.model.VariableDescriptor;

public abstract class Variable
extends VariableDescriptor
implements IPDIVariable {
    private static IPDIVariable[] NO_CHILDREN = new IPDIVariable[0];
    private IPDIVariable[] children = NO_CHILDREN;
    protected String editable = null;
    protected String language;
    protected boolean isUpdated = true;

    public Variable(IPDISession session, TaskSet tasks, IPDIThread thread, IPDIStackFrame frame, String name, String fullName, int pos, int depth, String varId) {
        super(session, tasks, thread, frame, name, fullName, pos, depth);
        this.varId = varId;
    }

    public Variable(IPDISession session, IPDIVariableDescriptor varDesc, String varId) {
        super(session, varDesc);
        this.varId = varId;
    }

    public void dispose() throws PDIException {
        this.session.getVariableManager().destroyVariable(this);
    }

    public boolean equals(IPDIVariable var) {
        if (var instanceof Variable) {
            Variable variable = (Variable)var;
            return variable.getId().equals(this.getId());
        }
        return super.equalDescriptors(var);
    }

    public IPDIVariable getChild(String varid) {
        IPDIVariable[] iPDIVariableArray = this.children;
        int n = this.children.length;
        int n2 = 0;
        while (n2 < n) {
            IPDIVariable variable = iPDIVariableArray[n2];
            if (variable.getId().equals(varid)) {
                return (Variable)variable;
            }
            IPDIVariable grandChild = variable.getChild(varid);
            if (grandChild != null) {
                return grandChild;
            }
            ++n2;
        }
        return null;
    }

    public IPDIVariable[] getChildren() throws PDIException {
        String fn = this.getFullName();
        Target target = (Target)this.fStackFrame.getTarget();
        Thread currentThread = target.getCurrentThread();
        IPDIStackFrame currentFrame = currentThread.getCurrentStackFrame();
        target.lockTarget();
        try {
            target.setCurrentThread(this.fStackFrame.getThread(), false);
            ((Thread)this.fStackFrame.getThread()).setCurrentStackFrame(this.fStackFrame, false);
            IPDIEvaluatePartialExpressionRequest request = this.session.getRequestFactory().getEvaluatePartialExpressionRequest(this.getTasks(), this.getQualifiedName(), this.varId, true);
            this.session.getEventRequestManager().addEventRequest(request);
            IAIF aif = request.getPartialAIF(this.getTasks());
            String ch_varid = request.getId(this.getTasks());
            IAIFType type = aif.getType();
            IAIFValue value = aif.getValue();
            this.fTypename = aif.getDescription();
            if (this.varId == null) {
                this.varId = ch_varid;
            }
            if (type instanceof ITypeDerived) {
                IAIFType baseType = ((ITypeDerived)type).getBaseType();
                if (type instanceof IAIFTypeArray) {
                    IAIFValue[] values = ((IAIFValueArray)value).getValues();
                    this.children = new Variable[values.length];
                    int i = 0;
                    while (i < this.children.length) {
                        int index = this.castingIndex + i;
                        String ch_fn = "(" + fn + ")[" + index + "]";
                        String ch_n = String.valueOf(this.getName()) + "[" + index + "]";
                        String ch_k = String.valueOf(this.varId) + "." + i;
                        IPDIVariable v = this.createVariable(this.session, this.getTasks(), this.fThread, this.fStackFrame, ch_n, ch_fn, this.getPosition(), this.getStackDepth(), ch_k);
                        v.setAIF(AIFFactory.newAIF(baseType, values[i]));
                        this.children[i] = v;
                        ++i;
                    }
                } else if (type instanceof IAIFTypePointer) {
                    if (baseType instanceof ITypeAggregate) {
                        ITypeAggregate aggrType = (ITypeAggregate)baseType;
                        this.children = new Variable[aggrType.getNumberOfChildren()];
                        int i = 0;
                        while (i < this.children.length) {
                            String ch_fn = "(" + fn + ")->" + aggrType.getField(i);
                            String ch_n = aggrType.getField(i);
                            String ch_k = String.valueOf(this.varId) + "." + ch_n;
                            IPDIVariable v = this.createVariable(this.session, this.getTasks(), this.fThread, this.fStackFrame, ch_n, ch_fn, this.getPosition(), this.getStackDepth(), ch_k);
                            v.setAIF(AIFFactory.newAIF(aggrType.getType(i), ((IValueAggregate)value).getValue(i)));
                            this.children[i] = v;
                            ++i;
                        }
                    } else {
                        this.children = new Variable[1];
                        String ch_fn = "*(" + fn + ")";
                        String ch_n = ch_varid;
                        String ch_k = String.valueOf(this.varId) + "." + ch_n;
                        IPDIVariable v = this.createVariable(this.session, this.getTasks(), this.fThread, this.fStackFrame, ch_n, ch_fn, this.getPosition(), this.getStackDepth(), ch_k);
                        v.setAIF(AIFFactory.newAIF(type, value));
                        this.children[0] = v;
                    }
                }
            } else if (type instanceof IAIFTypeReference) {
                this.children = new Variable[1];
                String ch_fn = "(" + fn + ")->" + ((IAIFTypeReference)type).getName();
                String ch_n = ((IAIFTypeReference)type).getName();
                String ch_k = String.valueOf(this.varId) + "." + ch_n;
                IPDIVariable v = this.createVariable(this.session, this.getTasks(), this.fThread, this.fStackFrame, ch_n, ch_fn, this.getPosition(), this.getStackDepth(), ch_k);
                v.setAIF(AIFFactory.newAIF(type, value));
                this.children[0] = v;
            } else if (type instanceof ITypeAggregate) {
                ITypeAggregate aggrType = (ITypeAggregate)type;
                this.children = new Variable[aggrType.getNumberOfChildren()];
                int i = 0;
                while (i < this.children.length) {
                    String ch_fn = "(" + fn + ")." + aggrType.getField(i);
                    String ch_n = aggrType.getField(i);
                    String ch_k = String.valueOf(this.varId) + "." + ch_n;
                    IPDIVariable v = this.createVariable(this.session, this.getTasks(), this.fThread, this.fStackFrame, ch_n, ch_fn, this.getPosition(), this.getStackDepth(), ch_k);
                    v.setAIF(AIFFactory.newAIF(aggrType.getType(i), ((IValueAggregate)value).getValue(i)));
                    this.children[i] = v;
                    ++i;
                }
            } else {
                this.children = new Variable[1];
                String ch_fn = fn;
                String ch_n = ch_varid;
                String ch_k = String.valueOf(this.varId) + "." + ch_n;
                IPDIVariable v = this.createVariable(this.session, this.getTasks(), this.fThread, this.fStackFrame, ch_n, ch_fn, this.getPosition(), this.getStackDepth(), ch_k);
                v.setAIF(AIFFactory.newAIF(type, value));
                this.children[0] = v;
            }
            IPDIVariable[] iPDIVariableArray = this.children;
            return iPDIVariableArray;
        }
        finally {
            target.setCurrentThread(currentThread, false);
            currentThread.setCurrentStackFrame(currentFrame, false);
            target.releaseTarget();
        }
    }

    public IPDIVariable[] getChildren(int findex, int psize) throws PDIException {
        IPDIVariableDescriptor vo = this.getVariableDescriptorAsArray(findex, psize);
        IPDIVariable var = this.session.getVariableManager().createVariable((VariableDescriptor)vo);
        return var.getChildren();
    }

    public int getChildrenNumber() throws PDIException {
        IAIF a = this.getAIF();
        if (a.getType() instanceof IAIFTypeArray) {
            return ((IAIFTypeArray)a.getType()).getRange();
        }
        if (a.getType() instanceof ITypeAggregate) {
            return ((ITypeAggregate)a.getType()).getNumberOfChildren();
        }
        return 0;
    }

    public boolean isEditable() throws PDIException {
        if (this.editable == null) {
            throw new PDIException(this.getTasks(), Messages.Variable_0);
        }
        return this.editable == null ? false : this.editable.equalsIgnoreCase("true");
    }

    public void resetValue() {
        this.setAIF(null);
    }

    public void setValue(String expression) throws PDIException {
        throw new PDIException(this.getTasks(), Messages.Variable_1);
    }

    protected abstract IPDIVariable createVariable(IPDISession var1, TaskSet var2, IPDIThread var3, IPDIStackFrame var4, String var5, String var6, int var7, int var8, String var9);
}

