/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rephraserengine.internal.ui.actions;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.rephraserengine.core.vpg.eclipse.EclipseVPG;
import org.eclipse.rephraserengine.internal.core.preservation.Model;
import org.eclipse.rephraserengine.ui.WorkbenchSelectionInfo;
import org.eclipse.rephraserengine.ui.actions.VPGOutputWindowAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DisplayModelAction
extends VPGOutputWindowAction {
    @Override
    protected void writeOutput(EclipseVPG vpg, PrintStream ps) {
        try {
            String filename;
            WorkbenchSelectionInfo info = new WorkbenchSelectionInfo();
            if (info.editingAnIFile() && (filename = EclipseVPG.getFilenameForIFile((IFile)info.getFileInEditor())) != null) {
                ArrayList<Integer> lineMap = new ArrayList<Integer>();
                String fileContents = this.readStream(lineMap, info.getFileInEditor().getContents(true));
                ps.println(filename);
                ps.println();
                Model model = new Model("edge model", (IProgressMonitor)new NullProgressMonitor(), 0, vpg, new String[]{filename});
                ps.print(model.toString(filename, fileContents, lineMap));
                return;
            }
            ps.print("Please open in the file in the editor before invoking this action.");
        }
        catch (Exception e) {
            ps.print("An error occurred:\n");
            e.printStackTrace(ps);
        }
    }

    protected String readStream(ArrayList<Integer> lineMap, InputStream inputStream) throws IOException {
        StringBuffer sb = new StringBuffer(4096);
        BufferedReader in = new BufferedReader(new InputStreamReader(inputStream));
        int offset = 0;
        int ch = in.read();
        while (ch >= 0) {
            sb.append((char)ch);
            ++offset;
            if (ch == 10 && lineMap != null) {
                lineMap.add(offset);
            }
            ch = in.read();
        }
        in.close();
        return sb.toString();
    }
}

