/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.core.rtsystem;

import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.ptp.core.attributes.ArrayAttribute;
import org.eclipse.ptp.core.attributes.AttributeDefinitionManager;
import org.eclipse.ptp.core.attributes.AttributeManager;
import org.eclipse.ptp.core.attributes.BooleanAttribute;
import org.eclipse.ptp.core.attributes.IAttribute;
import org.eclipse.ptp.core.attributes.IAttributeDefinition;
import org.eclipse.ptp.core.attributes.IllegalValueException;
import org.eclipse.ptp.core.attributes.IntegerAttribute;
import org.eclipse.ptp.core.attributes.StringAttribute;
import org.eclipse.ptp.core.elements.IPElement;
import org.eclipse.ptp.core.elements.IPJob;
import org.eclipse.ptp.core.elements.attributes.ElementAttributeManager;
import org.eclipse.ptp.core.elements.attributes.ElementAttributes;
import org.eclipse.ptp.core.elements.attributes.JobAttributes;
import org.eclipse.ptp.core.elements.attributes.MachineAttributes;
import org.eclipse.ptp.core.elements.attributes.NodeAttributes;
import org.eclipse.ptp.core.elements.attributes.ProcessAttributes;
import org.eclipse.ptp.remote.core.IRemoteConnection;
import org.eclipse.ptp.remote.core.IRemoteConnectionManager;
import org.eclipse.ptp.remote.core.IRemoteFileManager;
import org.eclipse.ptp.remote.core.IRemoteProcessBuilder;
import org.eclipse.ptp.remote.core.IRemoteServices;
import org.eclipse.ptp.remote.core.PTPRemoteCorePlugin;
import org.eclipse.ptp.remote.core.exception.RemoteConnectionException;
import org.eclipse.ptp.rm.core.MPIJobAttributes;
import org.eclipse.ptp.rm.core.RMCorePlugin;
import org.eclipse.ptp.rm.core.messages.Messages;
import org.eclipse.ptp.rm.core.rmsystem.AbstractEffectiveToolRMConfiguration;
import org.eclipse.ptp.rm.core.rmsystem.IToolRMConfiguration;
import org.eclipse.ptp.rm.core.rtsystem.IToolRuntimeSystemJob;
import org.eclipse.ptp.rm.core.utils.DebugUtil;
import org.eclipse.ptp.rtsystem.AbstractRuntimeSystem;
import org.eclipse.ptp.rtsystem.events.IRuntimeEventFactory;
import org.eclipse.ptp.rtsystem.events.IRuntimeJobChangeEvent;
import org.eclipse.ptp.rtsystem.events.IRuntimeMachineChangeEvent;
import org.eclipse.ptp.rtsystem.events.IRuntimeNodeChangeEvent;
import org.eclipse.ptp.rtsystem.events.IRuntimeProcessChangeEvent;
import org.eclipse.ptp.rtsystem.events.RuntimeEventFactory;
import org.eclipse.ptp.utils.core.RangeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractToolRuntimeSystem
extends AbstractRuntimeSystem {
    private Job continousMonitorJob;
    private IRuntimeEventFactory eventFactory = new RuntimeEventFactory();
    private int jobNumber;
    private Thread jobQueueThread = null;
    private Map<String, Job> jobs = Collections.synchronizedMap(new HashMap());
    private int nextID;
    private Job periodicMonitorJob;
    private String rmID;
    private IProgressMonitor startupMonitor = null;
    protected AttributeDefinitionManager attrMgr;
    protected IRemoteConnection connection = null;
    protected LinkedBlockingQueue<Job> pendingJobQueue = new LinkedBlockingQueue();
    protected IRemoteServices remoteServices = null;
    protected IToolRMConfiguration rmConfiguration;

    public AbstractToolRuntimeSystem(Integer id, IToolRMConfiguration config, AttributeDefinitionManager manager) {
        this.rmID = id.toString();
        this.nextID = id + 1;
        this.jobNumber = 0;
        this.rmConfiguration = config;
        this.attrMgr = manager;
    }

    public void changeJob(String jobID, AttributeManager changedAttrMgr) {
        AttributeManager attrMgr = new AttributeManager();
        attrMgr.addAttributes(changedAttrMgr.getAttributes());
        ElementAttributeManager elementAttrs = new ElementAttributeManager();
        elementAttrs.setAttributeManager(new RangeSet(jobID), attrMgr);
        IRuntimeJobChangeEvent event = this.eventFactory.newRuntimeJobChangeEvent(elementAttrs);
        this.fireRuntimeJobChangeEvent(event);
        IAttribute[] iAttributeArray = changedAttrMgr.getAttributes();
        int n = iAttributeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IAttribute attr = iAttributeArray[n2];
            DebugUtil.trace(DebugUtil.RTS_TRACING, "RTS {0}, job #{1}: {2}={3}", this.rmConfiguration.getName(), jobID, attr.getDefinition().getId(), attr.getValueAsString());
            ++n2;
        }
    }

    public void changeMachine(String machineID, AttributeManager changedAttrMgr) {
        AttributeManager attrMgr = new AttributeManager();
        attrMgr.addAttributes(changedAttrMgr.getAttributes());
        ElementAttributeManager elementAttrs = new ElementAttributeManager();
        elementAttrs.setAttributeManager(new RangeSet(machineID), attrMgr);
        IRuntimeMachineChangeEvent event = this.eventFactory.newRuntimeMachineChangeEvent(elementAttrs);
        this.fireRuntimeMachineChangeEvent(event);
        IAttribute[] iAttributeArray = changedAttrMgr.getAttributes();
        int n = iAttributeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IAttribute attr = iAttributeArray[n2];
            DebugUtil.trace(DebugUtil.RTS_TRACING, "RTS {0}, machine #{1}: {2}={3}", this.rmConfiguration.getName(), machineID, attr.getDefinition().getId(), attr.getValueAsString());
            ++n2;
        }
    }

    public void changeNode(String nodeID, AttributeManager changedAttrMgr) {
        AttributeManager attrMgr = new AttributeManager();
        attrMgr.addAttributes(changedAttrMgr.getAttributes());
        ElementAttributeManager elementAttrs = new ElementAttributeManager();
        elementAttrs.setAttributeManager(new RangeSet(nodeID), attrMgr);
        IRuntimeNodeChangeEvent event = this.eventFactory.newRuntimeNodeChangeEvent(elementAttrs);
        this.fireRuntimeNodeChangeEvent(event);
        IAttribute[] iAttributeArray = changedAttrMgr.getAttributes();
        int n = iAttributeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IAttribute attr = iAttributeArray[n2];
            DebugUtil.trace(DebugUtil.RTS_TRACING, "RTS {0}, node #{1}: {2}={3}", this.rmConfiguration.getName(), nodeID, attr.getDefinition().getId(), attr.getValueAsString());
            ++n2;
        }
    }

    public void changeProcesses(String jobId, BitSet processJobRanks, AttributeManager changedAttrMgr) {
        AttributeManager attrMgr = new AttributeManager();
        attrMgr.addAttributes(changedAttrMgr.getAttributes());
        ElementAttributeManager elementAttrs = new ElementAttributeManager();
        elementAttrs.setAttributeManager(new RangeSet(processJobRanks), attrMgr);
        IRuntimeProcessChangeEvent event = this.eventFactory.newRuntimeProcessChangeEvent(jobId, elementAttrs);
        this.fireRuntimeProcessChangeEvent(event);
        IAttribute[] iAttributeArray = changedAttrMgr.getAttributes();
        int n = iAttributeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IAttribute attr = iAttributeArray[n2];
            DebugUtil.trace(DebugUtil.RTS_TRACING, "RTS {0}, processes #{1}: {2}={3}", this.rmConfiguration.getName(), processJobRanks, attr.getDefinition().getId(), attr.getValueAsString());
            ++n2;
        }
    }

    public String createJob(String parentID, AttributeManager attrMgr) {
        ElementAttributeManager mgr = new ElementAttributeManager();
        AttributeManager jobAttrMgr = new AttributeManager();
        String jobID = this.generateID().toString();
        jobAttrMgr.addAttribute((IAttribute)JobAttributes.getJobIdAttributeDefinition().create(jobID));
        jobAttrMgr.addAttribute((IAttribute)JobAttributes.getQueueIdAttributeDefinition().create(parentID));
        jobAttrMgr.addAttribute((IAttribute)JobAttributes.getStatusAttributeDefinition().create(MPIJobAttributes.Status.NORMAL.toString()));
        jobAttrMgr.addAttribute((IAttribute)JobAttributes.getUserIdAttributeDefinition().create(System.getenv("USER")));
        jobAttrMgr.addAttribute((IAttribute)ElementAttributes.getNameAttributeDefinition().create(this.generateJobName()));
        String subId = ((StringAttribute)attrMgr.getAttribute((IAttributeDefinition)JobAttributes.getSubIdAttributeDefinition())).getValue();
        String execName = ((StringAttribute)attrMgr.getAttribute((IAttributeDefinition)JobAttributes.getExecutableNameAttributeDefinition())).getValue();
        String execPath = ((StringAttribute)attrMgr.getAttribute((IAttributeDefinition)JobAttributes.getExecutablePathAttributeDefinition())).getValue();
        String workDir = ((StringAttribute)attrMgr.getAttribute((IAttributeDefinition)JobAttributes.getWorkingDirectoryAttributeDefinition())).getValue();
        Integer numProcs = ((IntegerAttribute)attrMgr.getAttribute((IAttributeDefinition)JobAttributes.getNumberOfProcessesAttributeDefinition())).getValue();
        List progArgs = ((ArrayAttribute)attrMgr.getAttribute((IAttributeDefinition)JobAttributes.getProgramArgumentsAttributeDefinition())).getValue();
        BooleanAttribute debugAttr = (BooleanAttribute)attrMgr.getAttribute((IAttributeDefinition)JobAttributes.getDebugFlagAttributeDefinition());
        jobAttrMgr.addAttribute((IAttribute)JobAttributes.getSubIdAttributeDefinition().create(subId));
        jobAttrMgr.addAttribute((IAttribute)JobAttributes.getExecutableNameAttributeDefinition().create(execName));
        jobAttrMgr.addAttribute((IAttribute)JobAttributes.getExecutablePathAttributeDefinition().create(execPath));
        jobAttrMgr.addAttribute((IAttribute)JobAttributes.getWorkingDirectoryAttributeDefinition().create(workDir));
        try {
            jobAttrMgr.addAttribute((IAttribute)JobAttributes.getNumberOfProcessesAttributeDefinition().create(numProcs));
        }
        catch (IllegalValueException e) {
            RMCorePlugin.log(e);
        }
        jobAttrMgr.addAttribute((IAttribute)JobAttributes.getProgramArgumentsAttributeDefinition().create((Comparable[])progArgs.toArray(new String[0])));
        if (debugAttr != null) {
            jobAttrMgr.addAttribute((IAttribute)JobAttributes.getDebugFlagAttributeDefinition().create(debugAttr.getValue()));
        }
        mgr.setAttributeManager(new RangeSet(jobID), jobAttrMgr);
        this.fireRuntimeNewJobEvent(this.eventFactory.newRuntimeNewJobEvent(parentID, mgr));
        DebugUtil.trace(DebugUtil.RTS_TRACING, "RTS {0}: new job #{1}", this.rmConfiguration.getName(), jobID);
        return jobID;
    }

    public String createMachine(String name) {
        String id = this.generateID().toString();
        ElementAttributeManager mgr = new ElementAttributeManager();
        AttributeManager attrMgr = new AttributeManager();
        attrMgr.addAttribute((IAttribute)MachineAttributes.getStateAttributeDefinition().create((Enum)MachineAttributes.State.UP));
        attrMgr.addAttribute((IAttribute)ElementAttributes.getNameAttributeDefinition().create(name));
        mgr.setAttributeManager(new RangeSet(id), attrMgr);
        this.fireRuntimeNewMachineEvent(this.eventFactory.newRuntimeNewMachineEvent(this.rmID, mgr));
        DebugUtil.trace(DebugUtil.RTS_TRACING, "RTS {0}: new machine #{1}", this.rmConfiguration.getName(), id);
        return id;
    }

    public String createNode(String parentID, String name, int number) {
        AttributeManager attrMgr;
        ElementAttributeManager mgr;
        String id;
        block2: {
            id = this.generateID();
            mgr = new ElementAttributeManager();
            attrMgr = new AttributeManager();
            attrMgr.addAttribute((IAttribute)NodeAttributes.getStateAttributeDefinition().create((Enum)NodeAttributes.State.UP));
            try {
                attrMgr.addAttribute((IAttribute)NodeAttributes.getNumberAttributeDefinition().create(new Integer(number)));
            }
            catch (IllegalValueException e) {
                RMCorePlugin.log(e);
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
        attrMgr.addAttribute((IAttribute)ElementAttributes.getNameAttributeDefinition().create(name));
        mgr.setAttributeManager(new RangeSet(id), attrMgr);
        this.fireRuntimeNewNodeEvent(this.eventFactory.newRuntimeNewNodeEvent(parentID, mgr));
        DebugUtil.trace(DebugUtil.RTS_TRACING, "RTS {0}: new node #{1}", this.rmConfiguration.getName(), id);
        return id;
    }

    public void createProcess(String jobId, int index) {
        ElementAttributeManager mgr = new ElementAttributeManager();
        AttributeManager attrMgr = new AttributeManager();
        attrMgr.addAttribute((IAttribute)ProcessAttributes.getStateAttributeDefinition().create((Enum)ProcessAttributes.State.STARTING));
        mgr.setAttributeManager(new RangeSet(index), attrMgr);
        this.fireRuntimeNewProcessEvent(this.eventFactory.newRuntimeNewProcessEvent(jobId, mgr));
        DebugUtil.trace(DebugUtil.RTS_TRACING, "RTS {0}: new process #{1}", this.rmConfiguration.getName(), Integer.toString(index));
    }

    public IRemoteProcessBuilder createProcessBuilder(List<String> command) {
        return this.remoteServices.getProcessBuilder(this.connection, command);
    }

    public IRemoteProcessBuilder createProcessBuilder(List<String> command, String workdir) {
        IRemoteFileManager fileManager = this.remoteServices.getFileManager(this.connection);
        IRemoteProcessBuilder processBuilder = this.remoteServices.getProcessBuilder(this.connection, command);
        if (fileManager != null) {
            processBuilder.directory(fileManager.getResource(workdir));
        }
        return processBuilder;
    }

    public void createProcesses(String jobId, int num) {
        int index = 0;
        while (index < num) {
            this.createProcess(jobId, index);
            ++index;
        }
        DebugUtil.trace(DebugUtil.RTS_TRACING, "RTS {0}: created {1} new processes", this.rmConfiguration.getName(), num);
    }

    public String createQueue(String name) {
        String id = this.generateID();
        ElementAttributeManager mgr = new ElementAttributeManager();
        AttributeManager attrMgr = new AttributeManager();
        attrMgr.addAttribute((IAttribute)ElementAttributes.getNameAttributeDefinition().create(name));
        mgr.setAttributeManager(new RangeSet(id), attrMgr);
        this.fireRuntimeNewQueueEvent(this.eventFactory.newRuntimeNewQueueEvent(this.rmID, mgr));
        DebugUtil.trace(DebugUtil.RTS_TRACING, "RTS {0}: new queue #{1}", this.rmConfiguration.getName(), id);
        return id;
    }

    public abstract Job createRuntimeSystemJob(String var1, String var2, AttributeManager var3) throws CoreException;

    public void filterEvents(IPElement element, boolean filterChildren, AttributeManager filterAttributes) throws CoreException {
        this.doFilterEvents(element, filterChildren, filterAttributes);
    }

    public IRemoteConnection getConnection() {
        return this.connection;
    }

    public IRemoteServices getRemoteServices() {
        return this.remoteServices;
    }

    public IToolRMConfiguration getRmConfiguration() {
        return this.rmConfiguration;
    }

    public String getRmID() {
        return this.rmID;
    }

    public abstract AbstractEffectiveToolRMConfiguration retrieveEffectiveToolRmConfiguration();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() throws CoreException {
        DebugUtil.trace(DebugUtil.RTS_TRACING, "RTS {0}: shutdown", this.rmConfiguration.getName());
        this.doShutdown();
        this.stopEvents();
        if (this.jobQueueThread != null) {
            this.jobQueueThread.interrupt();
            for (Job job : this.pendingJobQueue) {
                job.cancel();
            }
        }
        Iterator<Job> iterator = this.jobs.values().iterator();
        while (iterator.hasNext()) {
            Job job = iterator.next();
            job.cancel();
            iterator.remove();
        }
        Object object = this;
        synchronized (object) {
            if (this.startupMonitor != null) {
                this.startupMonitor.setCanceled(true);
            }
        }
        if (this.connection != null) {
            this.connection.close();
        }
        this.jobQueueThread = null;
        this.fireRuntimeShutdownStateEvent(this.eventFactory.newRuntimeShutdownStateEvent());
    }

    public void startEvents() throws CoreException {
        DebugUtil.trace(DebugUtil.RTS_TRACING, "RTS {0}: start events", this.rmConfiguration.getName());
        if (this.periodicMonitorJob == null) {
            this.periodicMonitorJob = this.createPeriodicMonitorJob(null);
        }
        if (this.continousMonitorJob == null) {
            this.continousMonitorJob = this.createContinuousMonitorJob(null);
        }
        if (this.periodicMonitorJob != null) {
            this.periodicMonitorJob.schedule();
        }
        if (this.continousMonitorJob != null) {
            this.continousMonitorJob.schedule();
        }
        this.doStartEvents();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void startup(IProgressMonitor monitor) throws CoreException {
        SubMonitor subMon = SubMonitor.convert((IProgressMonitor)monitor, (int)90);
        AbstractToolRuntimeSystem abstractToolRuntimeSystem = this;
        synchronized (abstractToolRuntimeSystem) {
            this.startupMonitor = monitor;
        }
        monitor.subTask(Messages.AbstractToolRuntimeSystem_1);
        DebugUtil.trace(DebugUtil.RTS_TRACING, "RTS {0}: startup", this.rmConfiguration.getName());
        try {
            block33: {
                block32: {
                    block31: {
                        this.remoteServices = PTPRemoteCorePlugin.getDefault().getRemoteServices(this.rmConfiguration.getRemoteServicesId());
                        if (this.remoteServices == null) {
                            throw new CoreException((IStatus)new Status(4, "org.eclipse.ptp.rm.core", Messages.AbstractToolRuntimeSystem_Exception_NoRemoteServices));
                        }
                        IRemoteConnectionManager connectionManager = this.remoteServices.getConnectionManager();
                        Assert.isNotNull((Object)connectionManager);
                        monitor.worked(10);
                        monitor.subTask(Messages.AbstractToolRuntimeSystem_2);
                        this.connection = connectionManager.getConnection(this.rmConfiguration.getConnectionName());
                        if (this.connection == null) {
                            throw new CoreException((IStatus)new Status(4, "org.eclipse.ptp.rm.core", Messages.AbstractToolRuntimeSystem_Exception_NoConnection));
                        }
                        if (!this.connection.isOpen()) {
                            try {
                                this.connection.open((IProgressMonitor)subMon.newChild(50));
                            }
                            catch (RemoteConnectionException e) {
                                throw new CoreException((IStatus)new Status(4, "org.eclipse.ptp.rm.core", e.getMessage()));
                            }
                        }
                        if (!monitor.isCanceled()) break block31;
                        this.connection.close();
                        break block32;
                    }
                    try {
                        this.doStartup((IProgressMonitor)subMon.newChild(40));
                    }
                    catch (CoreException e) {
                        this.connection.close();
                        throw e;
                    }
                    if (!monitor.isCanceled()) break block33;
                    this.connection.close();
                }
                AbstractToolRuntimeSystem abstractToolRuntimeSystem2 = this;
                synchronized (abstractToolRuntimeSystem2) {
                    this.startupMonitor = null;
                    return;
                }
            }
            Job discoverJob = this.createDiscoverJob((IProgressMonitor)subMon.newChild(50));
            if (discoverJob != null) {
                discoverJob.schedule();
                try {
                    discoverJob.join();
                }
                catch (InterruptedException interruptedException) {}
                IStatus status = discoverJob.getResult();
                if (!status.isOK()) {
                    throw new CoreException(status);
                }
            }
            if (this.jobQueueThread == null) {
                this.jobQueueThread = new Thread((Runnable)new JobRunner(), Messages.AbstractToolRuntimeSystem_JobQueueManagerThreadTitle);
                this.jobQueueThread.start();
            }
            this.fireRuntimeRunningStateEvent(this.eventFactory.newRuntimeRunningStateEvent());
        }
        catch (Throwable throwable) {
            AbstractToolRuntimeSystem abstractToolRuntimeSystem3 = this;
            synchronized (abstractToolRuntimeSystem3) {
                this.startupMonitor = null;
                throw throwable;
            }
        }
        AbstractToolRuntimeSystem abstractToolRuntimeSystem4 = this;
        synchronized (abstractToolRuntimeSystem4) {
            this.startupMonitor = null;
            return;
        }
    }

    public void stopEvents() throws CoreException {
        DebugUtil.trace(DebugUtil.RTS_TRACING, "RTS {0}: stop events", this.rmConfiguration.getName());
        if (this.periodicMonitorJob != null) {
            this.periodicMonitorJob.cancel();
        }
        if (this.continousMonitorJob != null) {
            this.continousMonitorJob.cancel();
        }
        this.doStopEvents();
    }

    public void submitJob(String subId, AttributeManager attrMgr) throws CoreException {
        if (this.remoteServices == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.ptp.rm.core", Messages.AbstractToolRuntimeSystem_Exception_ResourceManagerNotInitialized));
        }
        attrMgr.addAttribute((IAttribute)JobAttributes.getSubIdAttributeDefinition().create(subId));
        String queueID = ((StringAttribute)attrMgr.getAttribute((IAttributeDefinition)JobAttributes.getQueueIdAttributeDefinition())).getValue();
        String jobID = this.createJob(queueID, attrMgr);
        attrMgr.addAttribute((IAttribute)JobAttributes.getJobIdAttributeDefinition().create(jobID));
        DebugUtil.trace(DebugUtil.JOB_TRACING, "RTS {0}: job submission #{0}, job id #{1}, queue id @{2}", this.rmConfiguration.getName(), subId, jobID, queueID);
        Job job = this.createRuntimeSystemJob(jobID, queueID, attrMgr);
        this.jobs.put(jobID, job);
        try {
            this.pendingJobQueue.put(job);
        }
        catch (InterruptedException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.ptp.rm.core", e.getMessage()));
        }
    }

    public void terminateJob(IPJob ipJob) throws CoreException {
        DebugUtil.trace(DebugUtil.JOB_TRACING, "RTS {0}: terminate job #{1}", this.rmConfiguration.getName(), ipJob.getID());
        Job job = this.jobs.get(ipJob.getID());
        this.pendingJobQueue.remove(job);
        job.cancel();
    }

    protected abstract Job createContinuousMonitorJob(IProgressMonitor var1) throws CoreException;

    protected abstract Job createDiscoverJob(IProgressMonitor var1) throws CoreException;

    protected abstract Job createPeriodicMonitorJob(IProgressMonitor var1) throws CoreException;

    protected abstract void doFilterEvents(IPElement var1, boolean var2, AttributeManager var3) throws CoreException;

    protected abstract void doShutdown() throws CoreException;

    protected abstract void doStartEvents() throws CoreException;

    protected abstract void doStartup(IProgressMonitor var1) throws CoreException;

    protected abstract void doStopEvents() throws CoreException;

    protected String generateID() {
        String id = Integer.toString(this.generateIntID());
        return id;
    }

    protected int generateIntID() {
        int id = this.nextID++;
        return id;
    }

    protected RangeSet generateIdRange(int count) {
        int start = this.nextID;
        this.nextID += count;
        return new RangeSet(start, this.nextID - 1);
    }

    protected String generateJobName() {
        return "job" + this.jobNumber++;
    }

    class JobRunner
    implements Runnable {
        JobRunner() {
        }

        public void run() {
            DebugUtil.trace(DebugUtil.JOB_TRACING, "RTS {0}: started job thread", AbstractToolRuntimeSystem.this.rmConfiguration.getName());
            try {
                while (AbstractToolRuntimeSystem.this.connection != null) {
                    Job job = AbstractToolRuntimeSystem.this.pendingJobQueue.take();
                    if (job instanceof IToolRuntimeSystemJob) {
                        DebugUtil.trace(DebugUtil.JOB_TRACING, "RTS {0}: schedule job #{1}", AbstractToolRuntimeSystem.this.rmConfiguration.getName(), ((IToolRuntimeSystemJob)job).getJobID());
                    } else {
                        DebugUtil.trace(DebugUtil.JOB_TRACING, "RTS {0}: schedule job #{1}", AbstractToolRuntimeSystem.this.rmConfiguration.getName(), job.getName());
                    }
                    job.schedule();
                }
            }
            catch (InterruptedException interruptedException) {
            }
            catch (Exception e) {
                DebugUtil.error(DebugUtil.JOB_TRACING, "RTS {0}: {1}", AbstractToolRuntimeSystem.this.rmConfiguration.getName(), e);
                RMCorePlugin.log(e);
            }
            DebugUtil.trace(DebugUtil.JOB_TRACING, "RTS {0}: terminated job thread", AbstractToolRuntimeSystem.this.rmConfiguration.getName());
        }
    }
}

