/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.core.parser;

import java.util.zip.Inflater;
import org.eclipse.photran.internal.core.lexer.Token;
import org.eclipse.photran.internal.core.parser.Parser;
import org.eclipse.photran.internal.core.parser.ParsingTables;

final class ContainsStmtParsingTables
extends ParsingTables {
    private static ContainsStmtParsingTables instance = null;

    ContainsStmtParsingTables() {
    }

    public static ContainsStmtParsingTables getInstance() {
        if (instance == null) {
            instance = new ContainsStmtParsingTables();
        }
        return instance;
    }

    public int getActionCode(int state, Token lookahead) {
        return ActionTable.getActionCode(state, lookahead);
    }

    public int getActionCode(int state, int lookaheadTokenIndex) {
        return ActionTable.get(state, lookaheadTokenIndex);
    }

    public int getGoTo(int state, Parser.Nonterminal nonterminal) {
        return GoToTable.getGoTo(state, nonterminal);
    }

    public int getRecoveryCode(int state, Token lookahead) {
        return RecoveryTable.getRecoveryCode(state, lookahead);
    }

    protected static final class ActionTable {
        protected static final int[] rowmap;
        protected static final int[] columnmap;
        protected static int[][] sigmap;
        protected static int[][] value;

        static {
            int[] nArray = new int[8];
            nArray[1] = 1;
            nArray[2] = 2;
            nArray[3] = 3;
            nArray[7] = 1;
            rowmap = nArray;
            int[] nArray2 = new int[246];
            nArray2[17] = 1;
            nArray2[42] = 2;
            nArray2[155] = 3;
            columnmap = nArray2;
            sigmap = null;
            value = null;
            ActionTable.sigmapInit();
            ActionTable.valueInit();
        }

        protected ActionTable() {
        }

        protected static int getActionCode(int state, Token lookahead) {
            assert (state >= 0 && state < 3223);
            assert (lookahead != null);
            Integer index = Parser.terminalIndices.get(lookahead.getTerminal());
            if (index == null) {
                return 0;
            }
            return ActionTable.get(state, index);
        }

        public static int get(int row, int col) {
            if (ActionTable.isErrorEntry(row, col)) {
                return 0;
            }
            if (columnmap[col] % 2 == 0) {
                return ActionTable.lookupValue(rowmap[row], columnmap[col] / 2) >>> 16;
            }
            return ActionTable.lookupValue(rowmap[row], columnmap[col] / 2) & 0xFFFF;
        }

        protected static boolean isErrorEntry(int row, int col) {
            int sigmapRow = row;
            int sigmapCol = col / 32;
            int bitNumberFromLeft = col % 32;
            int sigmapMask = 1 << 32 - bitNumberFromLeft - 1;
            return (ActionTable.lookupSigmap(sigmapRow, sigmapCol) & sigmapMask) == 0;
        }

        protected static void sigmapInit() {
            try {
                byte[] decoded = new byte[31];
                ContainsStmtParsingTables.base64Decode(decoded, "eNoTYMAAAjg5DAQUkyEPBgr4JB0YKAb4zAcAbuEA0Q==");
                byte[] buffer = new byte[257];
                Inflater inflater = new Inflater();
                inflater.setInput(decoded, 0, 31);
                inflater.inflate(buffer);
                inflater.end();
                sigmap = new int[8][8];
                int index = 0;
                while (index < 256) {
                    int byte1 = 0xFF & buffer[index + 0];
                    int byte2 = 0xFF & buffer[index + 1];
                    int byte3 = 0xFF & buffer[index + 2];
                    int byte4 = 0xFF & buffer[index + 3];
                    int element = index / 4;
                    int row = element / 8;
                    int col = element % 8;
                    ActionTable.sigmap[row][col] = byte1 << 24 | byte2 << 16 | byte3 << 8 | byte4;
                    index += 4;
                }
            }
            catch (Exception e) {
                throw new Error(e);
            }
        }

        protected static int lookupSigmap(int row, int col) {
            return sigmap[row][col];
        }

        protected static void valueInit() {
            try {
                byte[] decoded = new byte[32];
                ContainsStmtParsingTables.base64Decode(decoded, "eNpzfd3AfoChgdHhBgOD63kgfsMABg2sEJoBAKJkBts=");
                byte[] buffer = new byte[33];
                Inflater inflater = new Inflater();
                inflater.setInput(decoded, 0, 32);
                inflater.inflate(buffer);
                inflater.end();
                value = new int[4][2];
                int index = 0;
                while (index < 32) {
                    int byte1 = 0xFF & buffer[index + 0];
                    int byte2 = 0xFF & buffer[index + 1];
                    int byte3 = 0xFF & buffer[index + 2];
                    int byte4 = 0xFF & buffer[index + 3];
                    int element = index / 4;
                    int row = element / 2;
                    int col = element % 2;
                    ActionTable.value[row][col] = byte1 << 24 | byte2 << 16 | byte3 << 8 | byte4;
                    index += 4;
                }
            }
            catch (Exception e) {
                throw new Error(e);
            }
        }

        protected static int lookupValue(int row, int col) {
            return value[row][col];
        }
    }

    protected static final class GoToTable {
        protected static final int[] rowmap = new int[8];
        protected static final int[] columnmap;
        protected static int[][] sigmap;
        protected static int[][] value;

        static {
            int[] nArray = new int[493];
            nArray[220] = 1;
            nArray[489] = 2;
            columnmap = nArray;
            sigmap = null;
            value = null;
            GoToTable.sigmapInit();
            GoToTable.valueInit();
        }

        protected GoToTable() {
        }

        protected static int getGoTo(int state, Parser.Nonterminal nonterminal) {
            assert (state >= 0 && state < 3223);
            assert (nonterminal != null);
            return GoToTable.get(state, nonterminal.getIndex());
        }

        public static int get(int row, int col) {
            if (GoToTable.isErrorEntry(row, col)) {
                return -1;
            }
            if (columnmap[col] % 2 == 0) {
                return GoToTable.lookupValue(rowmap[row], columnmap[col] / 2) >>> 16;
            }
            return GoToTable.lookupValue(rowmap[row], columnmap[col] / 2) & 0xFFFF;
        }

        protected static boolean isErrorEntry(int row, int col) {
            int sigmapRow = row;
            int sigmapCol = col / 32;
            int bitNumberFromLeft = col % 32;
            int sigmapMask = 1 << 32 - bitNumberFromLeft - 1;
            return (GoToTable.lookupSigmap(sigmapRow, sigmapCol) & sigmapMask) == 0;
        }

        protected static void sigmapInit() {
            try {
                byte[] decoded = new byte[22];
                ContainsStmtParsingTables.base64Decode(decoded, "eNpjYEABHDjY2IEDwygY6gAAkcEAUQ==");
                byte[] buffer = new byte[513];
                Inflater inflater = new Inflater();
                inflater.setInput(decoded, 0, 22);
                inflater.inflate(buffer);
                inflater.end();
                sigmap = new int[8][16];
                int index = 0;
                while (index < 512) {
                    int byte1 = 0xFF & buffer[index + 0];
                    int byte2 = 0xFF & buffer[index + 1];
                    int byte3 = 0xFF & buffer[index + 2];
                    int byte4 = 0xFF & buffer[index + 3];
                    int element = index / 4;
                    int row = element / 16;
                    int col = element % 16;
                    GoToTable.sigmap[row][col] = byte1 << 24 | byte2 << 16 | byte3 << 8 | byte4;
                    index += 4;
                }
            }
            catch (Exception e) {
                throw new Error(e);
            }
        }

        protected static int lookupSigmap(int row, int col) {
            return sigmap[row][col];
        }

        protected static void valueInit() {
            try {
                byte[] decoded = new byte[13];
                ContainsStmtParsingTables.base64Decode(decoded, "eNpjYGFgYmD+/58BAA==");
                byte[] buffer = new byte[9];
                Inflater inflater = new Inflater();
                inflater.setInput(decoded, 0, 13);
                inflater.inflate(buffer);
                inflater.end();
                value = new int[1][2];
                int index = 0;
                while (index < 8) {
                    int byte1 = 0xFF & buffer[index + 0];
                    int byte2 = 0xFF & buffer[index + 1];
                    int byte3 = 0xFF & buffer[index + 2];
                    int byte4 = 0xFF & buffer[index + 3];
                    int element = index / 4;
                    int row = element / 2;
                    int col = element % 2;
                    GoToTable.value[row][col] = byte1 << 24 | byte2 << 16 | byte3 << 8 | byte4;
                    index += 4;
                }
            }
            catch (Exception e) {
                throw new Error(e);
            }
        }

        protected static int lookupValue(int row, int col) {
            return value[row][col];
        }
    }

    protected static final class RecoveryTable {
        protected static final int[] rowmap = new int[8];
        protected static final int[] columnmap = new int[246];
        protected static int[][] sigmap = null;
        protected static int[][] value = null;

        static {
            RecoveryTable.sigmapInit();
            RecoveryTable.valueInit();
        }

        protected RecoveryTable() {
        }

        protected static int getRecoveryCode(int state, Token lookahead) {
            assert (state >= 0 && state < 3223);
            assert (lookahead != null);
            Integer index = Parser.terminalIndices.get(lookahead.getTerminal());
            if (index == null) {
                return 0;
            }
            return RecoveryTable.get(state, index);
        }

        public static int get(int row, int col) {
            if (RecoveryTable.isErrorEntry(row, col)) {
                return 0;
            }
            if (columnmap[col] % 2 == 0) {
                return RecoveryTable.lookupValue(rowmap[row], columnmap[col] / 2) >>> 16;
            }
            return RecoveryTable.lookupValue(rowmap[row], columnmap[col] / 2) & 0xFFFF;
        }

        protected static boolean isErrorEntry(int row, int col) {
            int sigmapRow = row;
            int sigmapCol = col / 32;
            int bitNumberFromLeft = col % 32;
            int sigmapMask = 1 << 32 - bitNumberFromLeft - 1;
            return (RecoveryTable.lookupSigmap(sigmapRow, sigmapCol) & sigmapMask) == 0;
        }

        protected static void sigmapInit() {
            try {
                byte[] decoded = new byte[12];
                ContainsStmtParsingTables.base64Decode(decoded, "eNpjYBjhAAABAQAB");
                byte[] buffer = new byte[257];
                Inflater inflater = new Inflater();
                inflater.setInput(decoded, 0, 12);
                inflater.inflate(buffer);
                inflater.end();
                sigmap = new int[8][8];
                int index = 0;
                while (index < 256) {
                    int byte1 = 0xFF & buffer[index + 0];
                    int byte2 = 0xFF & buffer[index + 1];
                    int byte3 = 0xFF & buffer[index + 2];
                    int byte4 = 0xFF & buffer[index + 3];
                    int element = index / 4;
                    int row = element / 8;
                    int col = element % 8;
                    RecoveryTable.sigmap[row][col] = byte1 << 24 | byte2 << 16 | byte3 << 8 | byte4;
                    index += 4;
                }
            }
            catch (Exception e) {
                throw new Error(e);
            }
        }

        protected static int lookupSigmap(int row, int col) {
            return sigmap[row][col];
        }

        protected static void valueInit() {
            try {
                byte[] decoded = new byte[7];
                ContainsStmtParsingTables.base64Decode(decoded, "eNpjYAACAA==");
                byte[] buffer = new byte[5];
                Inflater inflater = new Inflater();
                inflater.setInput(decoded, 0, 7);
                inflater.inflate(buffer);
                inflater.end();
                value = new int[1][1];
                int index = 0;
                while (index < 4) {
                    int byte1 = 0xFF & buffer[index + 0];
                    int byte2 = 0xFF & buffer[index + 1];
                    int byte3 = 0xFF & buffer[index + 2];
                    int byte4 = 0xFF & buffer[index + 3];
                    int element = index / 4;
                    int row = element / 1;
                    int col = element % 1;
                    RecoveryTable.value[row][col] = byte1 << 24 | byte2 << 16 | byte3 << 8 | byte4;
                    index += 4;
                }
            }
            catch (Exception e) {
                throw new Error(e);
            }
        }

        protected static int lookupValue(int row, int col) {
            return value[row][col];
        }
    }
}

