/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.ui.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.MultiRule;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.photran.core.IFortranAST;
import org.eclipse.photran.internal.core.analysis.binding.Definition;
import org.eclipse.photran.internal.core.lexer.Token;
import org.eclipse.photran.internal.core.util.IterableWrapper;
import org.eclipse.photran.internal.core.vpg.PhotranVPG;
import org.eclipse.photran.internal.ui.actions.FortranEditorActionDelegate;
import org.eclipse.photran.internal.ui.editor.FortranEditor;
import org.eclipse.rephraserengine.core.util.OffsetLength;
import org.eclipse.rephraserengine.core.vpg.eclipse.VPGSchedulingRule;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.progress.IProgressService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FortranEditorASTActionDelegate
extends FortranEditorActionDelegate {
    public final void run(IAction action) {
        if (this.window != null) {
            IEditorPart editor = this.window.getActivePage().getActiveEditor();
            FortranEditor fortranEditor = this.fEditor = editor instanceof FortranEditor ? (FortranEditor)editor : null;
        }
        if (this.fEditor != null) {
            IProgressService context = PlatformUI.getWorkbench().getProgressService();
            IWorkspaceRoot lockEntireWorkspace = ResourcesPlugin.getWorkspace().getRoot();
            VPGSchedulingRule vpgSched = VPGSchedulingRule.getInstance();
            ISchedulingRule schedulingRule = MultiRule.combine((ISchedulingRule)lockEntireWorkspace, (ISchedulingRule)vpgSched);
            try {
                context.runInUI((IRunnableContext)context, (IRunnableWithProgress)this, schedulingRule);
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
                MessageDialog.openError((Shell)this.fEditor.getShell(), (String)"Unhandled Exception", (String)e.getMessage());
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    protected IFortranAST getAST() throws Exception {
        IFortranAST ast = (IFortranAST)PhotranVPG.getInstance().acquireTransientAST(this.getFortranEditor().getIFile());
        if (ast == null) {
            throw new Exception("Unable to parse file in editor");
        }
        return ast;
    }

    protected Token findEnclosingToken(IFortranAST ast, ITextSelection textSelection) {
        for (Token token : new IterableWrapper((Object)ast)) {
            if (!token.containsFileOffset(new OffsetLength(textSelection.getOffset(), textSelection.getLength()))) continue;
            return token;
        }
        return null;
    }

    protected Definition openSelectionDialog(Collection<Definition> defs) {
        ElementListSelectionDialog dlg = new ElementListSelectionDialog(this.getShell(), (ILabelProvider)new LabelProvider(){

            public String getText(Object element) {
                Definition def = (Definition)element;
                return FortranEditorASTActionDelegate.this.describeDeclaration(def);
            }
        });
        dlg.setBlockOnOpen(true);
        dlg.setHelpAvailable(false);
        dlg.setIgnoreCase(true);
        dlg.setMessage("Select a declaration to open (? = any character, * = any string):");
        dlg.setMultipleSelection(false);
        dlg.setSize(100, 10);
        dlg.setTitle("Multiple Declarations Found");
        dlg.setElements(defs.toArray());
        dlg.open();
        if (dlg.getResult() != null) {
            return (Definition)dlg.getResult()[0];
        }
        return null;
    }

    protected String describeDeclaration(Definition def) {
        try {
            IDocument document = this.getFortranEditor().getDocumentProvider().getDocument((Object)this.getFortranEditor().getEditorInput());
            return String.valueOf(def.getCanonicalizedName()) + " - " + def.describeClassification() + (def.isSubprogramArgument() ? " (Subprogram Argument)" : "") + " - Line " + (document.getLineOfOffset(def.getTokenRef().findToken().getFileOffset()) + 1) + " - " + def.getTokenRef().getFilename();
        }
        catch (Throwable throwable) {
            return def.toString();
        }
    }
}

