/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.ui.views.vpgproblems;

import org.eclipse.core.resources.IMarker;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.photran.internal.ui.views.vpgproblems.VPGProblemView;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.MarkerUtilities;

public class CopyMarkedFileAction
extends Action {
    private static final String SEPARATOR = " ";
    VPGProblemView myView = null;

    public CopyMarkedFileAction(VPGProblemView view, String text) {
        super(text);
        this.myView = view;
    }

    public ImageDescriptor getImageDescriptor() {
        Image img = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_TOOL_COPY");
        return ImageDescriptor.createFromImage((Image)img);
    }

    public void run() {
        ISelection sel = this.myView.getSite().getSelectionProvider().getSelection();
        this.myView.getClipboard().setContents(new Object[]{this.asText(sel)}, new Transfer[]{TextTransfer.getInstance()});
    }

    protected String asText(ISelection sel) {
        IStructuredSelection selection = (IStructuredSelection)sel;
        String result = "";
        for (Object element : selection) {
            if (!(element instanceof IMarker)) continue;
            IMarker marker = (IMarker)element;
            result = result.concat(this.asText(marker));
            result = result.concat("\n");
        }
        return result;
    }

    protected String asText(IMarker marker) {
        String markerID = "ID: " + String.valueOf(marker.getId());
        String markerMsg = "Description: " + MarkerUtilities.getMessage((IMarker)marker);
        String markerRes = "Resource: " + marker.getResource().getName().toString();
        String markerPath = "Path: " + marker.getResource().getProjectRelativePath().toString();
        String markerLoc = "Location: line " + String.valueOf(MarkerUtilities.getLineNumber((IMarker)marker));
        String markerType = "Error Type: " + MarkerUtilities.getMarkerType((IMarker)marker);
        String result = String.valueOf(markerID) + SEPARATOR + markerMsg + SEPARATOR + markerRes + SEPARATOR + markerPath + SEPARATOR + markerLoc + SEPARATOR + markerType + SEPARATOR;
        return result;
    }
}

