/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.mpi.openmpi.core.rtsystem;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.ptp.core.attributes.AttributeManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OpenMPIProcessMap {
    private final AttributeManager attributeManager = new AttributeManager();
    private final List<Application> applications = new ArrayList<Application>();
    private final Map<String, Node> nodes = new HashMap<String, Node>();
    private final List<Process> processes = new ArrayList<Process>();

    public List<Process> getProcesses() {
        return Collections.unmodifiableList(this.processes);
    }

    public List<Node> getNodes() {
        return Collections.unmodifiableList(new ArrayList<Node>(this.nodes.values()));
    }

    public List<Application> getAppContexts() {
        return Collections.unmodifiableList(this.applications);
    }

    public AttributeManager getAttributeManager() {
        return this.attributeManager;
    }

    public void addApplication(Application application) {
        this.applications.add(application);
    }

    public void addNode(Node node) {
        this.nodes.put(node.getName(), node);
    }

    public Node getNode(String name) {
        return this.nodes.get(name);
    }

    public void addProcess(Process process) {
        this.processes.add(process);
        process.getNode().addProcess(process);
    }

    public static class Application {
        private int index;
        private String name = new String();
        private final AttributeManager attributeManager = new AttributeManager();
        private int numberOfProcessors;

        public Application(int index, String applicationName, int numberOfProcessors) {
            this.index = index;
            this.name = applicationName;
            this.numberOfProcessors = numberOfProcessors;
        }

        public int getIndex() {
            return this.index;
        }

        public String getName() {
            return this.name;
        }

        public int getNumberOfProcessors() {
            return this.numberOfProcessors;
        }

        public AttributeManager getAttributeManager() {
            return this.attributeManager;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Node {
        private String name = null;
        private List<String> resolvedNames = new ArrayList<String>();
        private Iterator<String> iterator = null;
        private final AttributeManager attributeManager = new AttributeManager();
        private List<Process> processes = new ArrayList<Process>();

        public Node(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public String getResolvedName() {
            if (this.iterator == null || !this.iterator.hasNext()) {
                this.iterator = this.resolvedNames.listIterator();
            }
            if (!this.iterator.hasNext()) {
                return this.name;
            }
            return this.iterator.next();
        }

        public void addResolvedName(String name) {
            if (!this.resolvedNames.contains(name)) {
                this.resolvedNames.add(name);
            }
        }

        public AttributeManager getAttributeManager() {
            return this.attributeManager;
        }

        public void addProcess(Process process) {
            this.processes.add(process);
        }

        public List<Process> getProcesses() {
            return Collections.unmodifiableList(this.processes);
        }
    }

    public static class Process {
        private int index;
        private int applicationIndex;
        private Node node;
        private final AttributeManager attributeManager = new AttributeManager();

        public Process(Node node, int index, int applicationIndex) {
            this.node = node;
            this.index = index;
            this.applicationIndex = applicationIndex;
        }

        public int getIndex() {
            return this.index;
        }

        public int getApplicationIndex() {
            return this.applicationIndex;
        }

        public AttributeManager getAttributeManager() {
            return this.attributeManager;
        }

        public Node getNode() {
            return this.node;
        }
    }
}

