/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.rdt.core.miners;

import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.cdt.core.index.IIndexFileLocation;
import org.eclipse.cdt.core.index.IIndexLocationConverter;
import org.eclipse.dstore.core.model.DataStore;
import org.eclipse.ptp.internal.rdt.core.miners.RemoteIndexFileLocation;
import org.eclipse.ptp.internal.rdt.core.miners.ScopeManager;
import org.eclipse.ptp.internal.rdt.core.miners.URICreatorManager;

public class SimpleLocationConverter
implements IIndexLocationConverter {
    String fScheme;
    String fHost;
    DataStore fDataStore;

    public SimpleLocationConverter(String scheme, String host, DataStore datastore) {
        this.fScheme = scheme;
        this.fHost = host;
        this.fDataStore = datastore;
    }

    public IIndexFileLocation fromInternalFormat(String raw) {
        try {
            URI uri = this.createURIForScheme(this.fScheme, this.fHost, raw);
            return new RemoteIndexFileLocation(null, uri);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private URI createURIForScheme(String scheme, String host, String path) throws URISyntaxException {
        if (scheme == null || scheme.equals("")) {
            scheme = ScopeManager.getInstance().getSchemeForFile(path);
        }
        URI newURI = URICreatorManager.getDefault(this.fDataStore).createURI(scheme, host, path);
        return newURI;
    }

    public String toInternalFormat(IIndexFileLocation location) {
        return null;
    }
}

