/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.rdt.core.miners;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import org.eclipse.cdt.core.dom.IName;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTFileLocation;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTNodeSelector;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorIncludeStatement;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IProblemBinding;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMethod;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPSpecialization;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPUsingDeclaration;
import org.eclipse.cdt.core.index.IIndex;
import org.eclipse.cdt.core.index.IIndexBinding;
import org.eclipse.cdt.core.index.IIndexMacro;
import org.eclipse.cdt.core.index.IIndexName;
import org.eclipse.cdt.core.index.IndexFilter;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ISourceReference;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.parser.util.ArrayUtil;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.dstore.core.model.DataStore;
import org.eclipse.ptp.internal.rdt.core.miners.RemoteIndexManager;
import org.eclipse.ptp.internal.rdt.core.model.BindingAdapter;
import org.eclipse.ptp.internal.rdt.core.model.CElement;
import org.eclipse.ptp.internal.rdt.core.model.Path;
import org.eclipse.ptp.internal.rdt.core.navigation.OpenDeclarationResult;
import org.eclipse.ptp.internal.rdt.core.navigation.SimpleName;
import org.eclipse.rse.dstore.universal.miners.UniversalServerUtilities;

public class OpenDeclarationHandler {
    private static final int KIND_OTHER = 0;
    private static final int KIND_USING_DECL = 1;
    private static final int KIND_DEFINITION = 2;
    public static final String CLASS_NAME = "CDTMiner-OpenDeclarationHandler";
    private static int PARSE_MODE_FAST = 38;

    public static OpenDeclarationResult handleOpenDeclaration(String scopeName, String scheme, ITranslationUnit workingCopy, String path, String selectedText, int selectionStart, int selectionLength, DataStore _dataStore) {
        UniversalServerUtilities.logDebugMessage((String)CLASS_NAME, (String)("Getting declaration for selection in " + workingCopy.getElementName()), (DataStore)_dataStore);
        UniversalServerUtilities.logDebugMessage((String)CLASS_NAME, (String)("scope: " + scopeName), (DataStore)_dataStore);
        UniversalServerUtilities.logDebugMessage((String)CLASS_NAME, (String)("path: " + workingCopy.getLocationURI()), (DataStore)_dataStore);
        UniversalServerUtilities.logDebugMessage((String)CLASS_NAME, (String)("offset: " + selectionStart), (DataStore)_dataStore);
        UniversalServerUtilities.logDebugMessage((String)CLASS_NAME, (String)("length: " + selectionLength), (DataStore)_dataStore);
        IIndex index = RemoteIndexManager.getInstance().getIndexForScope("__WORKSPACE_ROOT_SCOPE__", _dataStore);
        UniversalServerUtilities.logDebugMessage((String)CLASS_NAME, (String)"Acquiring read lock", (DataStore)_dataStore);
        try {
            index.acquireReadLock();
        }
        catch (InterruptedException e) {
            UniversalServerUtilities.logError((String)CLASS_NAME, (String)e.toString(), (Throwable)e, (DataStore)_dataStore);
            return OpenDeclarationResult.failureUnexpectedError();
        }
        UniversalServerUtilities.logDebugMessage((String)CLASS_NAME, (String)"Got Read lock", (DataStore)_dataStore);
        try {
            OpenDeclarationResult openDeclarationResult = OpenDeclarationHandler.doHandleOpenDeclaration(scopeName, scheme, workingCopy, path, selectedText, selectionStart, selectionLength, index, _dataStore);
            return openDeclarationResult;
        }
        catch (CoreException e) {
            UniversalServerUtilities.logError((String)CLASS_NAME, (String)e.toString(), (Throwable)e, (DataStore)_dataStore);
            OpenDeclarationResult openDeclarationResult = OpenDeclarationResult.failureUnexpectedError();
            return openDeclarationResult;
        }
        finally {
            index.releaseReadLock();
            UniversalServerUtilities.logDebugMessage((String)CLASS_NAME, (String)"Lock released", (DataStore)_dataStore);
        }
    }

    private static IName[] convertNames(IName[] names) {
        int n = names.length;
        IName[] converted = new IName[n];
        int i = 0;
        while (i < n) {
            converted[i] = new SimpleName(names[i]);
            ++i;
        }
        return converted;
    }

    private static OpenDeclarationResult doHandleOpenDeclaration(String scopeName, String scheme, ITranslationUnit workingCopy, String path, String selectedText, int selectionStart, int selectionLength, IIndex index, DataStore _dataStore) throws CoreException {
        IASTTranslationUnit ast = workingCopy.getAST(index, PARSE_MODE_FAST);
        IASTNodeSelector nodeSelector = ast.getNodeSelector(null);
        IASTName searchName = nodeSelector.findEnclosingName(selectionStart, selectionLength);
        if (searchName != null) {
            IASTNode parent = searchName.getParent();
            if (parent instanceof IASTPreprocessorIncludeStatement) {
                String includedPath = ((IASTPreprocessorIncludeStatement)parent).getPath();
                if (includedPath == null || includedPath.equals("")) {
                    return OpenDeclarationResult.failureIncludeLookup(selectedText);
                }
                return OpenDeclarationResult.resultIncludePath(includedPath);
            }
            IBinding binding = searchName.resolveBinding();
            if (binding != null && !(binding instanceof IProblemBinding)) {
                ICElement[] elements;
                IName[] declNames;
                int isKind = 0;
                if (searchName.isDefinition()) {
                    int n = isKind = binding instanceof ICPPUsingDeclaration ? 1 : 2;
                }
                if ((declNames = OpenDeclarationHandler.findNames(index, ast, isKind, binding)).length == 0) {
                    ICPPMethod method;
                    if (binding instanceof ICPPSpecialization) {
                        IBinding specialized = ((ICPPSpecialization)binding).getSpecializedBinding();
                        if (specialized != null && !(specialized instanceof IProblemBinding)) {
                            declNames = OpenDeclarationHandler.findNames(index, ast, 2, specialized);
                        }
                    } else if (binding instanceof ICPPMethod && (method = (ICPPMethod)binding).isImplicit()) {
                        try {
                            ICPPClassType clsBinding = method.getClassOwner();
                            if (clsBinding != null && !(clsBinding instanceof IProblemBinding)) {
                                declNames = OpenDeclarationHandler.findNames(index, ast, 0, (IBinding)clsBinding);
                            }
                        }
                        catch (DOMException dOMException) {}
                    }
                }
                if ((elements = OpenDeclarationHandler.convertToCElements(workingCopy, index, declNames, _dataStore)) != null && elements.length > 0) {
                    return OpenDeclarationResult.resultCElements(elements);
                }
                if (OpenDeclarationHandler.hasAtLeastOneLocation(declNames)) {
                    return OpenDeclarationResult.resultNames(OpenDeclarationHandler.convertNames(declNames));
                }
            }
        } else {
            IASTNode node = nodeSelector.findEnclosingNode(selectionStart, selectionLength);
            if (node instanceof IASTPreprocessorIncludeStatement) {
                String includedPath = ((IASTPreprocessorIncludeStatement)node).getPath();
                if (includedPath != "") {
                    return OpenDeclarationResult.resultIncludePath(includedPath);
                }
                return OpenDeclarationResult.failureIncludeLookup(selectedText);
            }
        }
        return OpenDeclarationHandler.navigationFallBack(ast, index, selectedText, _dataStore);
    }

    private static ICElement[] convertToCElements(ITranslationUnit unit, IIndex index, IName[] names, DataStore _dataStore) {
        ArrayList<ICElement> elements = new ArrayList<ICElement>();
        IName[] iNameArray = names;
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            IName name = iNameArray[n2];
            try {
                ICElement element = OpenDeclarationHandler.getCElementForName(unit, index, name);
                if (element instanceof ISourceReference) {
                    elements.add(element);
                }
            }
            catch (CoreException e) {
                UniversalServerUtilities.logError((String)CLASS_NAME, (String)e.toString(), (Throwable)e, (DataStore)_dataStore);
            }
            catch (DOMException e) {
                UniversalServerUtilities.logError((String)CLASS_NAME, (String)e.toString(), (Throwable)e, (DataStore)_dataStore);
            }
            ++n2;
        }
        return elements.toArray(new ICElement[elements.size()]);
    }

    private static ICElement getCElementForName(ITranslationUnit unit, IIndex index, IName name) throws CoreException, DOMException {
        int length;
        int offset;
        IIndexBinding binding;
        boolean isDefinition = name.isDefinition();
        if (name instanceof IIndexName) {
            IIndexName indexName = (IIndexName)name;
            binding = index.findBinding((IName)indexName);
            offset = indexName.getNodeOffset();
            length = indexName.getNodeLength();
        } else if (name instanceof IASTName) {
            IASTName astName = (IASTName)name;
            binding = astName.resolveBinding();
            if (binding == null) {
                return null;
            }
            IASTFileLocation loc = astName.getFileLocation();
            if (loc == null) {
                return null;
            }
            offset = loc.getNodeOffset();
            length = loc.getNodeLength();
        } else {
            return null;
        }
        ICElement element = BindingAdapter.adaptBinding(unit, (IBinding)binding, offset, length, isDefinition);
        if (element == null) {
            return null;
        }
        ((CElement)element).setPath(new Path(name.getFileLocation().getFileName()));
        return element;
    }

    private static boolean hasAtLeastOneLocation(IName[] declNames) {
        IName[] iNameArray = declNames;
        int n = declNames.length;
        int n2 = 0;
        while (n2 < n) {
            IName name = iNameArray[n2];
            IASTFileLocation fileloc = name.getFileLocation();
            if (fileloc != null) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private static IName[] findNames(IIndex index, IASTTranslationUnit ast, int isKind, IBinding binding) throws CoreException {
        IName[] declNames = isKind == 2 ? OpenDeclarationHandler.findDeclarations(index, ast, binding) : OpenDeclarationHandler.findDefinitions(index, ast, isKind, binding);
        if (declNames.length == 0) {
            declNames = isKind == 2 ? OpenDeclarationHandler.findDefinitions(index, ast, isKind, binding) : OpenDeclarationHandler.findDeclarations(index, ast, binding);
        }
        return declNames;
    }

    private static IName[] findDefinitions(IIndex index, IASTTranslationUnit ast, int isKind, IBinding binding) throws CoreException {
        ArrayList<IASTName> declNames = new ArrayList<IASTName>();
        declNames.addAll(Arrays.asList(ast.getDefinitionsInAST(binding)));
        Iterator i = declNames.iterator();
        while (i.hasNext()) {
            IASTName name = (IASTName)i.next();
            if (!(name.resolveBinding() instanceof ICPPUsingDeclaration)) continue;
            i.remove();
        }
        if (!declNames.isEmpty()) {
            return (IName[])declNames.toArray(new IASTName[declNames.size()]);
        }
        return index.findNames(binding, 10);
    }

    private static IName[] findDeclarations(IIndex index, IASTTranslationUnit ast, IBinding binding) throws CoreException {
        Object[] declNames = ast.getDeclarationsInAST(binding);
        int i = 0;
        while (i < declNames.length) {
            Object name = declNames[i];
            if (name.isDefinition()) {
                declNames[i] = null;
            }
            ++i;
        }
        if ((declNames = (IName[])ArrayUtil.removeNulls(IName.class, (Object[])declNames)).length == 0) {
            declNames = index.findNames(binding, 9);
        }
        return declNames;
    }

    private static OpenDeclarationResult navigationFallBack(IASTTranslationUnit ast, IIndex index, String selectedText, DataStore _dataStore) {
        if (selectedText == null || selectedText.length() == 0) {
            return null;
        }
        try {
            IIndexBinding[] bindings;
            IIndexMacro[] macros;
            char[] chars = selectedText.toCharArray();
            ArrayList<IName> names = new ArrayList<IName>();
            IndexFilter filter = IndexFilter.getDeclaredBindingFilter((int)ast.getLinkage().getLinkageID(), (boolean)false);
            IIndexMacro[] iIndexMacroArray = macros = index.findMacros(chars, filter, null);
            int n = macros.length;
            int n2 = 0;
            while (n2 < n) {
                IIndexMacro macro = iIndexMacroArray[n2];
                SimpleName name = new SimpleName(macro.getFileLocation(), macro.getNameCharArray());
                names.add(name);
                ++n2;
            }
            IIndexBinding[] iIndexBindingArray = bindings = index.findBindings(chars, false, filter, null);
            int n3 = bindings.length;
            n = 0;
            while (n < n3) {
                IIndexBinding binding = iIndexBindingArray[n];
                IName[] foundNames = OpenDeclarationHandler.findNames(index, ast, 0, (IBinding)binding);
                names.addAll(Arrays.asList(foundNames));
                ++n;
            }
            if (!names.isEmpty()) {
                return OpenDeclarationResult.resultNames(OpenDeclarationHandler.convertNames(names.toArray(new IName[names.size()])));
            }
        }
        catch (CoreException e) {
            UniversalServerUtilities.logError((String)CLASS_NAME, (String)e.toString(), (Throwable)e, (DataStore)_dataStore);
        }
        return OpenDeclarationResult.failureSymbolLookup(selectedText);
    }
}

