/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rephraserengine.core.vpg;

import java.io.IOException;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.Iterator;
import org.eclipse.rephraserengine.core.vpg.TokenRef;
import org.eclipse.rephraserengine.core.vpg.VPG;
import org.eclipse.rephraserengine.core.vpg.VPGDependency;
import org.eclipse.rephraserengine.core.vpg.VPGEdge;
import org.eclipse.rephraserengine.core.vpg.VPGLog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class VPGDB<A, T, R extends TokenRef<T>, L extends VPGLog<T, R>> {
    public static final int ALL_EDGES = Integer.MIN_VALUE;
    private VPG<A, T, R, ? extends VPGDB<A, T, R, L>, L> vpg = null;

    public void setVPG(VPG<A, T, R, ? extends VPGDB<A, T, R, L>, L> vpg) {
        this.vpg = vpg;
    }

    protected VPG<A, T, R, ? extends VPGDB<A, T, R, L>, L> getVPG() {
        if (this.vpg == null) {
            throw new IllegalStateException("This VPG database has not been assigned to a VPG.  Construct a VPGDB object, and then pass it to the VPG or EclipseVPG constructor.");
        }
        return this.vpg;
    }

    public abstract void flush();

    public abstract void close();

    public abstract void clearDatabase();

    public abstract void enterHypotheticalMode() throws IOException;

    public abstract void leaveHypotheticalMode() throws IOException;

    public abstract boolean isInHypotheticalMode();

    public abstract void updateModificationStamp(String var1);

    public abstract boolean isOutOfDate(String var1);

    public abstract void deleteAllEntriesFor(String var1);

    public abstract void deleteAllEdgesAndAnnotationsFor(String var1);

    public abstract void deleteAllIncomingDependenciesFor(String var1);

    public abstract void deleteAllOutgoingDependenciesFor(String var1);

    public abstract Iterable<String> listAllFilenames();

    public abstract Iterable<String> listAllFilenamesWithDependents();

    public abstract Iterable<String> listAllDependentFilenames();

    public abstract void ensure(VPGDependency<A, T, R> var1);

    public abstract void delete(VPGDependency<A, T, R> var1);

    public abstract Iterable<String> getOutgoingDependenciesFrom(String var1);

    public abstract Iterable<String> getIncomingDependenciesTo(String var1);

    public abstract void ensure(VPGEdge<A, T, R> var1);

    public abstract void delete(VPGEdge<A, T, R> var1);

    public abstract Iterable<? extends VPGEdge<A, T, R>> getAllEdgesFor(String var1);

    public abstract Iterable<? extends VPGEdge<A, T, R>> getOutgoingEdgesFrom(R var1, int var2);

    public abstract Iterable<? extends VPGEdge<A, T, R>> getIncomingEdgesTo(R var1, int var2);

    public Iterable<R> getOutgoingEdgeTargets(R tokenRef, int edgeType) {
        return new EdgeIterable<A, T, R>(this.getOutgoingEdgesFrom(tokenRef, edgeType), false);
    }

    public Iterable<R> getIncomingEdgeSources(R tokenRef, int edgeType) {
        return new EdgeIterable<A, T, R>(this.getIncomingEdgesTo(tokenRef, edgeType), true);
    }

    public abstract void setAnnotation(R var1, int var2, Serializable var3);

    public abstract void deleteAnnotation(R var1, int var2);

    public abstract Serializable getAnnotation(R var1, int var2);

    public abstract void printOn(PrintStream var1);

    public abstract void printStatisticsOn(PrintStream var1);

    public abstract void resetStatistics();

    protected String describeEdgeType(int edgeType) {
        return "Edge of type " + edgeType;
    }

    protected String describeAnnotationType(int annotationType) {
        return "Annotation of type " + annotationType;
    }

    protected String describeToken(String filename, int offset, int length) {
        return String.valueOf(filename) + ", offset " + offset + ", length " + length;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EdgeIterable<A, T, R extends TokenRef<T>>
    implements Iterable<R> {
        private Iterable<? extends VPGEdge<A, T, R>> edges;
        private boolean returnSources;

        EdgeIterable(Iterable<? extends VPGEdge<A, T, R>> edges, boolean returnSources) {
            this.edges = edges;
            this.returnSources = returnSources;
        }

        @Override
        public Iterator<R> iterator() {
            final Iterator<? extends VPGEdge<A, T, R>> edgeIterator = this.edges.iterator();
            return new Iterator<R>(){

                @Override
                public boolean hasNext() {
                    return edgeIterator.hasNext();
                }

                @Override
                public R next() {
                    try {
                        VPGEdge edge = (VPGEdge)edgeIterator.next();
                        return EdgeIterable.this.returnSources ? edge.getSource() : edge.getSink();
                    }
                    catch (Exception e) {
                        throw new Error(e);
                    }
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
    }
}

