/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.core.parser;

import java.io.PrintStream;
import java.util.Iterator;
import org.eclipse.photran.internal.core.lexer.IPreprocessorReplacement;
import org.eclipse.photran.internal.core.lexer.Token;
import org.eclipse.photran.internal.core.parser.ASTNodeUtil;
import org.eclipse.photran.internal.core.parser.IASTNode;
import org.eclipse.photran.internal.core.parser.IASTVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ASTNode
implements IASTNode {
    private IASTNode parent = null;

    @Override
    public IASTNode getParent() {
        return this.parent;
    }

    @Override
    public void setParent(IASTNode parent) {
        this.parent = parent;
    }

    @Override
    public Iterable<? extends IASTNode> getChildren() {
        return new Iterable<IASTNode>(){

            @Override
            public Iterator<IASTNode> iterator() {
                return new ASTNodeUtil.NonNullIterator<IASTNode>(new Iterator<IASTNode>(){
                    private int index = 0;
                    private int numChildren;
                    {
                        this.numChildren = ASTNode.this.getNumASTFields();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.index < this.numChildren;
                    }

                    @Override
                    public IASTNode next() {
                        return ASTNode.this.getASTField(this.index++);
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                });
            }
        };
    }

    protected abstract int getNumASTFields();

    protected abstract IASTNode getASTField(int var1);

    protected abstract void setASTField(int var1, IASTNode var2);

    @Override
    public abstract void accept(IASTVisitor var1);

    @Override
    public void replaceChild(IASTNode node, IASTNode withNode) {
        int i = 0;
        while (i < this.getNumASTFields()) {
            if (this.getASTField(i) == node) {
                this.setASTField(i, withNode);
                if (withNode != null) {
                    withNode.setParent(this);
                }
                return;
            }
            ++i;
        }
        throw new IllegalStateException("Child node not found");
    }

    @Override
    public void removeFromTree() {
        ASTNodeUtil.removeFromTree(this);
    }

    @Override
    public void replaceWith(IASTNode newNode) {
        ASTNodeUtil.replaceWith((IASTNode)this, newNode);
    }

    @Override
    public void replaceWith(String literalString) {
        ASTNodeUtil.replaceWith((IASTNode)this, literalString);
    }

    @Override
    public Object clone() {
        try {
            ASTNode copy = (ASTNode)super.clone();
            int i = 0;
            while (i < this.getNumASTFields()) {
                if (this.getASTField(i) != null) {
                    IASTNode newChild = (IASTNode)this.getASTField(i).clone();
                    newChild.setParent(copy);
                    copy.setASTField(i, newChild);
                }
                ++i;
            }
            return copy;
        }
        catch (CloneNotSupportedException e) {
            throw new Error(e);
        }
    }

    @Override
    public <T extends IASTNode> T findNearestAncestor(Class<T> targetClass) {
        return ASTNodeUtil.findNearestAncestor(this, targetClass);
    }

    @Override
    public <T extends IASTNode> T findFirst(Class<T> targetClass) {
        return ASTNodeUtil.findFirst(this, targetClass);
    }

    @Override
    public <T extends IASTNode> T findLast(Class<T> targetClass) {
        return ASTNodeUtil.findLast(this, targetClass);
    }

    @Override
    public Token findFirstToken() {
        return ASTNodeUtil.findFirstToken(this);
    }

    @Override
    public Token findLastToken() {
        return ASTNodeUtil.findLastToken(this);
    }

    @Override
    public boolean isFirstChildInList() {
        return ASTNodeUtil.isFirstChildInList(this);
    }

    @Override
    public IPreprocessorReplacement printOn(PrintStream out, IPreprocessorReplacement currentPreprocessorDirective) {
        return ASTNodeUtil.print(this, currentPreprocessorDirective, out);
    }

    public String toString() {
        return ASTNodeUtil.toString(this);
    }
}

