/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.ui.search;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.photran.internal.core.analysis.binding.Definition;
import org.eclipse.photran.internal.core.lexer.Terminal;
import org.eclipse.photran.internal.core.lexer.Token;
import org.eclipse.photran.internal.core.vpg.PhotranVPG;
import org.eclipse.photran.internal.ui.actions.FortranEditorASTActionDelegate;
import org.eclipse.photran.internal.ui.search.FortranFindReferencesSearchQuery;
import org.eclipse.swt.widgets.Shell;

public abstract class FortranFindReferencesActionDelegate
extends FortranEditorASTActionDelegate {
    public void run(IProgressMonitor progressMonitor) throws InvocationTargetException, InterruptedException {
        try {
            try {
                Definition selectedDef;
                if (!PhotranVPG.getInstance().doesProjectHaveRefactoringEnabled(this.getFortranEditor().getIFile())) {
                    throw new Exception("Please enable analysis and refactoring in the project properties.");
                }
                Token token = this.findEnclosingToken(this.getAST(), this.getFortranEditor().getSelection());
                if (token == null || token.getTerminal() != Terminal.T_IDENT) {
                    throw new Exception("Please select an identifier.");
                }
                List defs = token.resolveBinding();
                if (defs.isEmpty()) {
                    throw new Exception("No definition could be found for the selected token.");
                }
                Definition definition = selectedDef = defs.size() > 1 ? this.openSelectionDialog(defs) : (Definition)defs.get(0);
                if (selectedDef != null && token.getPhysicalFile() != null && token.getPhysicalFile().getIFile() != null) {
                    FortranFindReferencesSearchQuery.searchForReference(selectedDef, this.getSearchScope(), token.getPhysicalFile().getIFile());
                }
            }
            catch (Exception e) {
                String message = e.getMessage();
                if (message == null) {
                    message = e.getClass().getName();
                }
                MessageDialog.openError((Shell)this.getFortranEditor().getShell(), (String)"Error", (String)message);
                progressMonitor.done();
            }
        }
        finally {
            progressMonitor.done();
        }
    }

    protected abstract FortranFindReferencesSearchQuery.SearchScope getSearchScope();

    public static class FileActionDelegate
    extends FortranFindReferencesActionDelegate {
        protected FortranFindReferencesSearchQuery.SearchScope getSearchScope() {
            return FortranFindReferencesSearchQuery.SearchScope.FILE;
        }
    }

    public static class ProjectActionDelegate
    extends FortranFindReferencesActionDelegate {
        protected FortranFindReferencesSearchQuery.SearchScope getSearchScope() {
            return FortranFindReferencesSearchQuery.SearchScope.PROJECT;
        }
    }

    public static class WorkspaceActionDelegate
    extends FortranFindReferencesActionDelegate {
        protected FortranFindReferencesSearchQuery.SearchScope getSearchScope() {
            return FortranFindReferencesSearchQuery.SearchScope.WORKSPACE;
        }
    }
}

