/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.ui.search;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.photran.internal.core.analysis.binding.Definition;
import org.eclipse.photran.internal.core.vpg.PhotranTokenRef;
import org.eclipse.photran.internal.ui.search.FortranSearchQuery;
import org.eclipse.rephraserengine.ui.search.SearchResult;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.ISearchResult;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.search.ui.text.AbstractTextSearchResult;

public class FortranFindReferencesSearchQuery
implements ISearchQuery {
    private Definition def;
    private SearchScope searchScope;
    private IFile file;
    private SearchResult searchResult;

    public FortranFindReferencesSearchQuery(Definition def, SearchScope searchScope, IFile file) {
        this.def = def;
        this.searchScope = searchScope;
        this.file = file;
        this.searchResult = new SearchResult((ISearchQuery)this);
    }

    public boolean canRerun() {
        return false;
    }

    public boolean canRunInBackground() {
        return true;
    }

    public String getLabel() {
        int count = ((AbstractTextSearchResult)this.getSearchResult()).getMatchCount();
        return "'" + this.getDef().getCanonicalizedName() + "' - " + count + (count == 1 ? " match in " : " matches in ") + (Object)((Object)this.searchScope);
    }

    public ISearchResult getSearchResult() {
        return this.searchResult;
    }

    public IFile getFile() {
        return this.file;
    }

    public IStatus run(IProgressMonitor monitor) {
        try {
            this.filterAndAddSearchResult(this.getDef().getTokenRef());
            for (PhotranTokenRef ref : this.getDef().findAllReferences(true)) {
                this.filterAndAddSearchResult(ref);
            }
        }
        catch (Exception e) {
            String message = e.getMessage();
            if (message == null) {
                message = e.getClass().getName();
            }
            return new Status(4, "org.eclipse.photran.ui.vpg", message);
        }
        return new Status(0, "org.eclipse.photran.ui.vpg", "Search Successful");
    }

    private void filterAndAddSearchResult(PhotranTokenRef ref) {
        if (!this.searchScope.filterOut(ref, this.getFile())) {
            FortranSearchQuery.addSearchResultFromTokenRef(ref, (SearchResult)this.getSearchResult());
        }
    }

    public static void searchForReference(Definition p_def, SearchScope p_searchscope, IFile p_file) {
        NewSearchUI.runQueryInBackground((ISearchQuery)new FortranFindReferencesSearchQuery(p_def, p_searchscope, p_file));
    }

    public Definition getDef() {
        return this.def;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SearchScope {
        FILE{

            public boolean filterOut(PhotranTokenRef tokenRef, IFile file) {
                return !tokenRef.getFile().equals((Object)file);
            }
        }
        ,
        PROJECT{

            public boolean filterOut(PhotranTokenRef tokenRef, IFile file) {
                return !tokenRef.getFile().getProject().equals((Object)file.getProject());
            }
        }
        ,
        WORKSPACE{

            public boolean filterOut(PhotranTokenRef tokenRef, IFile file) {
                return false;
            }
        };


        public abstract boolean filterOut(PhotranTokenRef var1, IFile var2);
    }
}

