/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.services.ui.views;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.ptp.services.core.IServiceConfiguration;
import org.eclipse.ptp.services.core.IServiceModelEvent;
import org.eclipse.ptp.services.core.IServiceModelEventListener;
import org.eclipse.ptp.services.core.IServiceModelManager;
import org.eclipse.ptp.services.core.ServiceModelManager;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.part.ViewPart;

public class ServiceConfigurationView
extends ViewPart {
    private TreeViewer fViewer;
    private IServiceModelManager fManager = ServiceModelManager.getInstance();

    public ServiceConfigurationView() {
        this.fManager.addEventListener((IServiceModelEventListener)new ServiceModelEventListener(), 11);
    }

    public void createPartControl(Composite parent) {
        this.fViewer = new TreeViewer(parent, 2);
        this.fViewer.setContentProvider((IContentProvider)new WorkbenchContentProvider());
        this.fViewer.setLabelProvider((IBaseLabelProvider)new ServiceConfigurationLabelProvider(this.fViewer.getTree().getFont()));
        this.fViewer.setInput((Object)ServiceModelManager.getInstance());
        this.createContextMenu();
        this.getSite().setSelectionProvider((ISelectionProvider)this.fViewer);
    }

    public synchronized void dispose() {
        super.dispose();
    }

    public Font getFont() {
        if (this.fViewer == null) {
            return null;
        }
        return this.fViewer.getTree().getFont();
    }

    public void refreshViewer() {
        this.fViewer.getControl().getDisplay().asyncExec(new Runnable(){

            public void run() {
                ServiceConfigurationView.this.fViewer.refresh();
            }
        });
    }

    public void setFocus() {
        this.fViewer.getControl().setFocus();
    }

    private void createContextMenu() {
        MenuManager menuManager = new MenuManager("#PopupMenu", "org.eclipse.ptp.services.ui.views.serviceConfigurationView.contextMenu");
        menuManager.setRemoveAllWhenShown(true);
        Menu menu = menuManager.createContextMenu(this.fViewer.getControl());
        this.fViewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuManager, (ISelectionProvider)this.fViewer);
    }

    private class ServiceConfigurationLabelProvider
    extends WorkbenchLabelProvider {
        private Font selectedFont;
        private Font unSelectedFont;

        public ServiceConfigurationLabelProvider(Font font) {
            this.unSelectedFont = font;
            FontData fd = font.getFontData()[0];
            FontData selectedFontData = new FontData(fd.getName(), fd.getHeight(), 1);
            this.selectedFont = (Font)new LocalResourceManager(JFaceResources.getResources()).get((DeviceResourceDescriptor)FontDescriptor.createFrom((FontData)selectedFontData));
        }

        public Font getFont(Object element) {
            IServiceConfiguration conf = this.getServiceConfiguration(element);
            if (conf != null && conf == ServiceConfigurationView.this.fManager.getActiveConfiguration()) {
                return this.selectedFont;
            }
            return this.unSelectedFont;
        }

        private IServiceConfiguration getServiceConfiguration(Object parentElement) {
            IServiceConfiguration conf = null;
            if (parentElement instanceof IAdaptable) {
                conf = (IServiceConfiguration)((IAdaptable)parentElement).getAdapter(IServiceConfiguration.class);
            }
            return conf;
        }
    }

    private class ServiceModelEventListener
    implements IServiceModelEventListener {
        private ServiceModelEventListener() {
        }

        public void handleEvent(IServiceModelEvent event) {
            ServiceConfigurationView.this.refreshViewer();
        }
    }
}

