/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom;

import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorIncludeStatement;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPUsingDirective;
import org.eclipse.cdt.core.index.IIndex;
import org.eclipse.cdt.core.index.IIndexFile;
import org.eclipse.cdt.core.index.IIndexFileLocation;
import org.eclipse.cdt.core.index.IIndexInclude;
import org.eclipse.cdt.core.index.IIndexMacro;
import org.eclipse.cdt.core.index.IndexLocationFactory;
import org.eclipse.cdt.core.model.AbstractLanguage;
import org.eclipse.cdt.core.parser.FileContent;
import org.eclipse.cdt.core.parser.IExtendedScannerInfo;
import org.eclipse.cdt.core.parser.IParserLogService;
import org.eclipse.cdt.core.parser.IScannerInfo;
import org.eclipse.cdt.core.parser.IncludeFileContentProvider;
import org.eclipse.cdt.core.parser.ParserUtil;
import org.eclipse.cdt.core.parser.ScannerInfo;
import org.eclipse.cdt.internal.core.dom.IIncludeFileResolutionHeuristics;
import org.eclipse.cdt.internal.core.index.IIndexFragmentFile;
import org.eclipse.cdt.internal.core.index.IWritableIndex;
import org.eclipse.cdt.internal.core.index.IndexBasedFileContentProvider;
import org.eclipse.cdt.internal.core.parser.scanner.InternalFileContentProvider;
import org.eclipse.cdt.internal.core.parser.scanner.StreamHasher;
import org.eclipse.cdt.internal.core.pdom.ITodoTaskUpdater;
import org.eclipse.cdt.internal.core.pdom.IndexerInputAdapter;
import org.eclipse.cdt.internal.core.pdom.Messages;
import org.eclipse.cdt.internal.core.pdom.PDOMManager;
import org.eclipse.cdt.internal.core.pdom.PDOMWriter;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNotImplementedError;
import org.eclipse.cdt.utils.FileSystemUtilityManager;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractIndexerTask
extends PDOMWriter {
    private static final int MAX_ERRORS = 500;
    private int fUpdateFlags = 1;
    private UnusedHeaderStrategy fIndexHeadersWithoutContext = UnusedHeaderStrategy.useDefaultLanguage;
    private boolean fIndexFilesWithoutConfiguration = true;
    private HashMap<FileKey, IndexFileContent> fFileInfos = new HashMap();
    private Object[] fFilesToUpdate;
    private List<Object> fFilesToRemove = new ArrayList<Object>();
    private List<String> fFilesUpFront = new ArrayList<String>();
    private int fASTOptions;
    private int fForceNumberFiles = 0;
    protected IWritableIndex fIndex;
    private ITodoTaskUpdater fTodoTaskUpdater;
    private final boolean fIsFastIndexer;
    private long fFileSizeLimit = 0L;
    private InternalFileContentProvider fCodeReaderFactory;
    private static Object NO_CONTEXT = new Object();

    public AbstractIndexerTask(Object[] filesToUpdate, Object[] filesToRemove, IndexerInputAdapter resolver, boolean fastIndexer) {
        super(resolver);
        this.fIsFastIndexer = fastIndexer;
        this.fFilesToUpdate = filesToUpdate;
        this.fFilesToRemove.addAll(Arrays.asList(filesToRemove));
        this.updateRequestedFiles(this.fFilesToUpdate.length + this.fFilesToRemove.size());
    }

    public final void setIndexHeadersWithoutContext(UnusedHeaderStrategy mode) {
        this.fIndexHeadersWithoutContext = mode;
    }

    public final void setIndexFilesWithoutBuildConfiguration(boolean val) {
        this.fIndexFilesWithoutConfiguration = val;
    }

    public UnusedHeaderStrategy getIndexHeadersWithoutContext() {
        return this.fIndexHeadersWithoutContext;
    }

    public boolean indexFilesWithoutConfiguration() {
        return this.fIndexFilesWithoutConfiguration;
    }

    public final void setUpdateFlags(int flags) {
        this.fUpdateFlags = flags;
    }

    public final void setParseUpFront(String[] astFilePaths) {
        this.fFilesUpFront.addAll(Arrays.asList(astFilePaths));
    }

    public final void setForceFirstFiles(int number) {
        this.fForceNumberFiles = number;
    }

    public final void setFileSizeLimit(long limit) {
        this.fFileSizeLimit = limit;
    }

    protected abstract IWritableIndex createIndex();

    protected abstract IIncludeFileResolutionHeuristics createIncludeHeuristics();

    protected abstract IncludeFileContentProvider createReaderFactory();

    protected abstract AbstractLanguage[] getLanguages(String var1);

    protected ITodoTaskUpdater createTodoTaskUpdater() {
        return null;
    }

    protected IScannerInfo createDefaultScannerConfig(int linkageID) {
        return new ScannerInfo();
    }

    protected String getASTPathForParsingUpFront() {
        return "______";
    }

    private final IASTTranslationUnit createAST(String code, AbstractLanguage lang, IScannerInfo scanInfo, int options, IProgressMonitor monitor) throws CoreException {
        String dummyName = this.getASTPathForParsingUpFront();
        if (dummyName != null) {
            IIndexFileLocation dummyLoc = this.fResolver.resolveASTPath(dummyName);
            this.setIndexed(lang.getLinkageID(), dummyLoc);
            FileContent codeReader = FileContent.create(dummyName, code.toCharArray());
            return this.createAST(lang, codeReader, scanInfo, options, false, monitor);
        }
        return null;
    }

    private final IASTTranslationUnit createAST(Object tu, AbstractLanguage language, FileContent codeReader, IScannerInfo scanInfo, int options, boolean inContext, IProgressMonitor pm) throws CoreException {
        if (codeReader == null) {
            return null;
        }
        if (this.fResolver.isSourceUnit(tu)) {
            options |= 8;
        }
        return this.createAST(language, codeReader, scanInfo, options, inContext, pm);
    }

    private final IASTTranslationUnit createAST(AbstractLanguage language, FileContent codeReader, IScannerInfo scanInfo, int options, boolean inContext, IProgressMonitor pm) throws CoreException {
        if (this.fFileSizeLimit > 0L && this.fResolver.getFileSize(codeReader.getFileLocation()) > this.fFileSizeLimit) {
            if (this.fShowActivity) {
                this.trace("Indexer: Skipping large file " + codeReader.getFileLocation());
            }
            return null;
        }
        if (this.fCodeReaderFactory == null) {
            InternalFileContentProvider fileContentProvider = this.createInternalFileContentProvider();
            if (this.fIsFastIndexer) {
                IndexBasedFileContentProvider ibfcp = new IndexBasedFileContentProvider(this.fIndex, this.fResolver, language.getLinkageID(), fileContentProvider, this);
                ibfcp.setSupportFillGapFromContextToHeader(inContext);
                ibfcp.setFileSizeLimit(this.fFileSizeLimit);
                this.fCodeReaderFactory = ibfcp;
            } else {
                this.fCodeReaderFactory = fileContentProvider;
            }
        } else if (this.fIsFastIndexer) {
            ((IndexBasedFileContentProvider)this.fCodeReaderFactory).setLinkage(language.getLinkageID());
        }
        this.fCodeReaderFactory.setIncludeResolutionHeuristics(this.createIncludeHeuristics());
        try {
            IASTTranslationUnit ast = language.getASTTranslationUnit(codeReader, scanInfo, (IncludeFileContentProvider)this.fCodeReaderFactory, (IIndex)this.fIndex, options, this.getLogService());
            if (pm.isCanceled()) {
                return null;
            }
            IASTTranslationUnit iASTTranslationUnit = ast;
            return iASTTranslationUnit;
        }
        finally {
            if (this.fIsFastIndexer) {
                ((IndexBasedFileContentProvider)this.fCodeReaderFactory).cleanupAfterTranslationUnit();
            }
        }
    }

    private InternalFileContentProvider createInternalFileContentProvider() {
        IncludeFileContentProvider fileContentProvider = this.createReaderFactory();
        if (fileContentProvider instanceof InternalFileContentProvider) {
            return (InternalFileContentProvider)fileContentProvider;
        }
        throw new IllegalArgumentException("Invalid file content provider");
    }

    protected IParserLogService getLogService() {
        return ParserUtil.getParserLogService();
    }

    public final void runTask(IProgressMonitor monitor) throws InterruptedException {
        if (!this.fIndexFilesWithoutConfiguration) {
            this.fIndexHeadersWithoutContext = UnusedHeaderStrategy.skip;
        }
        this.fIndex = this.createIndex();
        if (this.fIndex == null) {
            return;
        }
        this.fTodoTaskUpdater = this.createTodoTaskUpdater();
        this.fASTOptions = 20;
        if (this.getSkipReferences() == SKIP_ALL_REFERENCES) {
            this.fASTOptions |= 1;
        }
        this.fIndex.resetCacheCounters();
        this.fIndex.acquireReadLock();
        try {
            try {
                try {
                    HashMap<Integer, List<Object>> files = new HashMap<Integer, List<Object>>();
                    ArrayList<IIndexFragmentFile> ifilesToRemove = new ArrayList<IIndexFragmentFile>();
                    this.extractFiles(files, ifilesToRemove, monitor);
                    this.setResume(true);
                    this.removeFilesInIndex(this.fFilesToRemove, ifilesToRemove, monitor);
                    this.parseFilesUpFront(monitor);
                    int[] nArray = this.getLinkagesToParse();
                    int n = nArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        int linkageID = nArray[n2];
                        this.parseLinkage(linkageID, files, monitor);
                        ++n2;
                    }
                    if (!monitor.isCanceled()) {
                        this.setResume(false);
                    }
                }
                finally {
                    this.fIndex.flush();
                }
            }
            catch (CoreException e) {
                this.logException(e);
                this.fIndex.releaseReadLock();
            }
        }
        finally {
            this.fIndex.releaseReadLock();
        }
    }

    private void setResume(boolean value) throws InterruptedException, CoreException {
        this.fIndex.acquireWriteLock(1);
        try {
            this.fIndex.getWritableFragment().setProperty("org.eclipse.cdt.internal.core.index.resume", String.valueOf(value));
        }
        finally {
            this.fIndex.releaseWriteLock(1);
        }
    }

    private void extractFiles(Map<Integer, List<Object>> files, List<IIndexFragmentFile> iFilesToRemove, IProgressMonitor monitor) throws CoreException {
        boolean forceAll = (this.fUpdateFlags & 1) != 0;
        boolean checkTimestamps = (this.fUpdateFlags & 2) != 0;
        boolean checkFileContentsHash = (this.fUpdateFlags & 0x10) != 0;
        boolean checkConfig = (this.fUpdateFlags & 4) != 0;
        int count = 0;
        int forceFirst = this.fForceNumberFiles;
        Object[] objectArray = this.fFilesToUpdate;
        int n = this.fFilesToUpdate.length;
        int n2 = 0;
        while (n2 < n) {
            Object tu = objectArray[n2];
            if (monitor.isCanceled()) {
                return;
            }
            boolean force = forceAll || --forceFirst >= 0;
            IIndexFileLocation ifl = this.fResolver.resolveFile(tu);
            if (ifl != null) {
                int n3;
                boolean isSourceUnit = this.fResolver.isSourceUnit(tu);
                boolean isExcludedSource = isSourceUnit && !this.fIndexFilesWithoutConfiguration && !this.fResolver.isFileBuildConfigured(tu);
                IIndexFragmentFile[] indexFiles = this.fIndex.getWritableFiles(ifl);
                if (isSourceUnit && !isExcludedSource || this.fIndexHeadersWithoutContext != UnusedHeaderStrategy.skip) {
                    AbstractLanguage[] langs;
                    AbstractLanguage[] abstractLanguageArray = langs = this.fResolver.getLanguages(tu, this.fIndexHeadersWithoutContext == UnusedHeaderStrategy.useBoth);
                    int n4 = langs.length;
                    n3 = 0;
                    while (n3 < n4) {
                        AbstractLanguage lang = abstractLanguageArray[n3];
                        int linkageID = lang.getLinkageID();
                        IIndexFragmentFile ifile = this.getFile(linkageID, indexFiles);
                        if (ifile == null || !ifile.hasContent()) {
                            this.store(tu, linkageID, isSourceUnit, files);
                            this.requestUpdate(linkageID, ifl, null);
                            ++count;
                        } else {
                            this.takeFile(ifile, indexFiles);
                            boolean update = false;
                            if (checkConfig) {
                                update = isSourceUnit ? this.isSourceUnitConfigChange(tu, ifile) : this.isHeaderConfigChange(tu, ifile);
                            }
                            boolean bl = update = update || force || this.isModified(checkTimestamps, checkFileContentsHash, ifl, tu, ifile);
                            if (update) {
                                this.requestUpdate(linkageID, ifl, ifile);
                                this.store(tu, linkageID, isSourceUnit, files);
                                ++count;
                            }
                        }
                        ++n3;
                    }
                }
                IIndexFragmentFile[] iIndexFragmentFileArray = indexFiles;
                n3 = indexFiles.length;
                int n5 = 0;
                while (n5 < n3) {
                    IIndexFragmentFile ifile = iIndexFragmentFileArray[n5];
                    if (ifile != null) {
                        IIndexInclude ctx = ifile.getParsedInContext();
                        if (ctx == null) {
                            iFilesToRemove.add(ifile);
                            ++count;
                        } else {
                            boolean update = false;
                            if (checkConfig) {
                                update = this.isHeaderConfigChange(tu, ifile);
                            }
                            boolean bl = update = update || force || this.isModified(checkTimestamps, checkFileContentsHash, ifl, tu, ifile);
                            if (update) {
                                int linkageID = ifile.getLinkageID();
                                this.requestUpdate(linkageID, ifl, ifile);
                                this.store(tu, linkageID, false, files);
                                ++count;
                            }
                        }
                    }
                    ++n5;
                }
            }
            ++n2;
        }
        this.updateRequestedFiles(count - this.fFilesToUpdate.length);
        this.fFilesToUpdate = null;
    }

    private boolean isModified(boolean checkTimestamps, boolean checkFileContentsHash, IIndexFileLocation ifl, Object tu, IIndexFragmentFile file) throws CoreException {
        boolean timestampDifferent;
        boolean bl = timestampDifferent = checkTimestamps && this.fResolver.getLastModified(ifl) != file.getTimestamp();
        if (timestampDifferent && checkFileContentsHash && this.computeFileContentsHash(tu) == file.getContentsHash()) {
            return false;
        }
        return timestampDifferent;
    }

    private void requestUpdate(int linkageID, IIndexFileLocation ifl, IIndexFragmentFile ifile) {
        FileKey key = new FileKey(linkageID, ifl.getURI());
        IndexFileContent info = this.fFileInfos.get(key);
        if (info == null) {
            info = this.createFileInfo(key, null);
        }
        info.fIndexFile = ifile;
        info.fRequestUpdate = true;
    }

    private void setIndexed(int linkageID, IIndexFileLocation ifl) {
        FileKey key = new FileKey(linkageID, ifl.getURI());
        IndexFileContent info = this.fFileInfos.get(key);
        if (info == null) {
            info = this.createFileInfo(key, null);
        }
        info.fIsUpdated = true;
        info.clearCaches();
    }

    private IndexFileContent createFileInfo(FileKey key, IIndexFile ifile) {
        IndexFileContent info = new IndexFileContent();
        this.fFileInfos.put(key, info);
        info.fIndexFile = ifile;
        return info;
    }

    private IndexFileContent getFileInfo(int linkageID, IIndexFileLocation ifl) {
        FileKey key = new FileKey(linkageID, ifl.getURI());
        return this.fFileInfos.get(key);
    }

    private boolean isSourceUnitConfigChange(Object tu, IIndexFragmentFile ifile) {
        return false;
    }

    private boolean isHeaderConfigChange(Object tu, IIndexFragmentFile ifile) {
        return false;
    }

    private IIndexFragmentFile getFile(int linkageID, IIndexFragmentFile[] indexFiles) throws CoreException {
        IIndexFragmentFile[] iIndexFragmentFileArray = indexFiles;
        int n = indexFiles.length;
        int n2 = 0;
        while (n2 < n) {
            IIndexFragmentFile ifile = iIndexFragmentFileArray[n2];
            if (ifile != null && ifile.getLinkageID() == linkageID) {
                return ifile;
            }
            ++n2;
        }
        return null;
    }

    private void takeFile(IIndexFragmentFile ifile, IIndexFragmentFile[] indexFiles) {
        int i = 0;
        while (i < indexFiles.length) {
            if (indexFiles[i] == ifile) {
                indexFiles[i] = null;
                return;
            }
            ++i;
        }
    }

    private void store(Object tu, int linkageID, boolean isSourceUnit, Map<Integer, List<Object>> files) {
        Integer key = this.getFileListKey(linkageID, isSourceUnit);
        List<Object> list = files.get(key);
        if (list == null) {
            list = new LinkedList<Object>();
            files.put(key, list);
        }
        list.add(tu);
    }

    private Integer getFileListKey(int linkageID, boolean isSourceUnit) {
        Integer key = new Integer(linkageID * 2 + (isSourceUnit ? 0 : 1));
        return key;
    }

    private void removeFilesInIndex(List<Object> filesToRemove, List<IIndexFragmentFile> ifilesToRemove, IProgressMonitor monitor) throws InterruptedException, CoreException {
        if (!filesToRemove.isEmpty() || !ifilesToRemove.isEmpty()) {
            this.fIndex.acquireWriteLock(1);
            try {
                for (Object tu : this.fFilesToRemove) {
                    IIndexFragmentFile[] ifiles;
                    if (monitor.isCanceled()) {
                        return;
                    }
                    IIndexFileLocation ifl = this.fResolver.resolveFile(tu);
                    if (ifl == null) continue;
                    IIndexFragmentFile[] iIndexFragmentFileArray = ifiles = this.fIndex.getWritableFiles(ifl);
                    int n = ifiles.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IIndexFragmentFile ifile = iIndexFragmentFileArray[n2];
                        this.fIndex.clearFile(ifile, null);
                        ++n2;
                    }
                    this.updateRequestedFiles(-1);
                }
                for (IIndexFragmentFile ifile : ifilesToRemove) {
                    if (monitor.isCanceled()) {
                        return;
                    }
                    this.fIndex.clearFile(ifile, null);
                    this.updateRequestedFiles(-1);
                }
            }
            finally {
                this.fIndex.releaseWriteLock(1);
            }
        }
        this.fFilesToRemove.clear();
    }

    private void parseFilesUpFront(IProgressMonitor monitor) throws CoreException {
        for (String upfront : this.fFilesUpFront) {
            if (monitor.isCanceled()) {
                return;
            }
            String filePath = upfront;
            if ((filePath = filePath.trim()).length() == 0) continue;
            Path path = new Path(filePath);
            String fileName = path.lastSegment();
            try {
                AbstractLanguage[] langs;
                monitor.subTask(this.getMessage(MessageKind.parsingFileTask, fileName, path.removeLastSegments(1).toString()));
                AbstractLanguage[] abstractLanguageArray = langs = this.getLanguages(fileName);
                int n = langs.length;
                int n2 = 0;
                while (n2 < n) {
                    AbstractLanguage lang = abstractLanguageArray[n2];
                    if (this.fShowActivity) {
                        this.trace("Indexer: " + lang.getName() + ": Parsing " + filePath + " up front");
                    }
                    int linkageID = lang.getLinkageID();
                    String code = "#include \"" + filePath + "\"\n";
                    IScannerInfo scanInfo = this.createDefaultScannerConfig(linkageID);
                    if (scanInfo != null) {
                        long start = System.currentTimeMillis();
                        IASTTranslationUnit ast = this.createAST(code, lang, scanInfo, this.fASTOptions, monitor);
                        this.fStatistics.fParsingTime = (int)((long)this.fStatistics.fParsingTime + (System.currentTimeMillis() - start));
                        if (ast != null) {
                            IIndexFileLocation ifl;
                            IndexFileContent fileinfo;
                            IASTPreprocessorIncludeStatement p;
                            String found;
                            IASTNode node;
                            if ((this.fShowActivity || this.fShowInclusionProblems) && (node = ast.getNodeSelector(null).findEnclosingNode(0, 6)) instanceof IASTPreprocessorIncludeStatement && (found = (p = (IASTPreprocessorIncludeStatement)node).getPath()) != null && (fileinfo = this.getFileInfo(linkageID, ifl = this.fResolver.resolveASTPath(found))) != null && fileinfo.fIndexFile != null) {
                                this.trace(String.valueOf(filePath) + " was not properly parsed up front for " + lang.getName());
                            }
                            this.writeToIndex(linkageID, ast, StreamHasher.hash(code), AbstractIndexerTask.computeHashCode(scanInfo), monitor);
                            this.updateFileCount(0, 0, 1);
                        }
                    }
                    ++n2;
                }
            }
            catch (Exception e) {
                this.swallowError((IPath)path, e);
            }
            catch (Error e) {
                this.swallowError((IPath)path, e);
            }
        }
        this.fFilesUpFront.clear();
    }

    private void parseLinkage(int linkageID, Map<Integer, List<Object>> fileListMap, IProgressMonitor monitor) throws CoreException, InterruptedException {
        List<Object> files = fileListMap.get(this.getFileListKey(linkageID, true));
        if (files != null) {
            for (Object tu : files) {
                IndexFileContent info;
                if (monitor.isCanceled()) {
                    return;
                }
                IIndexFileLocation ifl = this.fResolver.resolveFile(tu);
                if (ifl == null || (info = this.getFileInfo(linkageID, ifl)) == null || !info.fRequestUpdate || info.fIsUpdated) continue;
                info.fRequestIsCounted = false;
                IScannerInfo scannerInfo = this.fResolver.getBuildConfiguration(linkageID, tu);
                this.parseFile(tu, linkageID, ifl, scannerInfo, false, monitor);
                if (!info.fIsUpdated) continue;
                this.updateFileCount(1, 0, 0);
            }
            files.clear();
        }
        HashMap<IIndexFragmentFile, Object> contextMap = new HashMap<IIndexFragmentFile, Object>();
        files = fileListMap.get(this.getFileListKey(linkageID, false));
        if (files != null) {
            IndexFileContent info;
            IIndexFileLocation ifl;
            Object header;
            Iterator<Object> iter = files.iterator();
            while (iter.hasNext()) {
                if (monitor.isCanceled()) {
                    return;
                }
                header = iter.next();
                ifl = this.fResolver.resolveFile(header);
                info = this.getFileInfo(linkageID, ifl);
                if (info != null && info.fRequestUpdate && !info.fIsUpdated) {
                    Object tu;
                    if (info.fIndexFile == null || !this.fIndex.isWritableFile(info.fIndexFile) || (tu = this.findContext(linkageID, (IIndexFragmentFile)info.fIndexFile, contextMap)) == null) continue;
                    IScannerInfo scannerInfo = this.fResolver.getBuildConfiguration(linkageID, tu);
                    info.fRequestIsCounted = false;
                    this.parseFile(header, linkageID, ifl, scannerInfo, true, monitor);
                    if (!info.fIsUpdated) continue;
                    this.updateFileCount(0, 1, 1);
                    iter.remove();
                    continue;
                }
                iter.remove();
            }
            contextMap = null;
            iter = files.iterator();
            while (iter.hasNext()) {
                if (monitor.isCanceled()) {
                    return;
                }
                header = iter.next();
                ifl = this.fResolver.resolveFile(header);
                info = this.getFileInfo(linkageID, ifl);
                if (info == null || !info.fRequestUpdate || info.fIsUpdated) continue;
                info.fRequestIsCounted = false;
                IScannerInfo scannerInfo = this.fResolver.getBuildConfiguration(linkageID, header);
                this.parseFile(header, linkageID, ifl, scannerInfo, false, monitor);
                if (!info.fIsUpdated) continue;
                this.updateFileCount(0, 1, 1);
                iter.remove();
            }
        }
    }

    private Object findContext(int linkageID, IIndexFragmentFile ifile, HashMap<IIndexFragmentFile, Object> contextMap) {
        block6: {
            IIndexInclude contextInclude;
            Object context;
            block7: {
                Object cachedContext = contextMap.get(ifile);
                if (cachedContext != null) {
                    return cachedContext == NO_CONTEXT ? null : cachedContext;
                }
                context = this.fResolver.getInputFile(ifile.getLocation());
                if (context != null && this.fResolver.isSourceUnit(context)) {
                    contextMap.put(ifile, context);
                    return context;
                }
                contextMap.put(ifile, NO_CONTEXT);
                contextInclude = ifile.getParsedInContext();
                if (contextInclude == null) break block6;
                IndexFileContent info = this.getFileInfo(linkageID, contextInclude.getIncludedByLocation());
                if (info == null || !info.fRequestUpdate) break block7;
                return null;
            }
            try {
                IIndexFragmentFile contextIFile = (IIndexFragmentFile)contextInclude.getIncludedBy();
                context = this.findContext(linkageID, contextIFile, contextMap);
                if (context != null) {
                    contextMap.put(ifile, context);
                    return context;
                }
            }
            catch (CoreException e) {
                CCorePlugin.log((Throwable)e);
            }
        }
        return null;
    }

    private void parseFile(Object tu, int linkageID, IIndexFileLocation ifl, IScannerInfo scanInfo, boolean inContext, IProgressMonitor pm) throws CoreException, InterruptedException {
        IPath path = this.getPathForLabel(ifl);
        AbstractLanguage[] langs = this.fResolver.getLanguages(tu, this.fIndexHeadersWithoutContext == UnusedHeaderStrategy.useBoth);
        AbstractLanguage lang = null;
        AbstractLanguage[] abstractLanguageArray = langs;
        int n = langs.length;
        int n2 = 0;
        while (n2 < n) {
            AbstractLanguage lang2 = abstractLanguageArray[n2];
            if (lang2.getLinkageID() == linkageID) {
                lang = lang2;
                break;
            }
            ++n2;
        }
        if (lang == null) {
            return;
        }
        Object th = null;
        try {
            if (this.fShowActivity) {
                this.trace("Indexer: parsing " + path.toOSString());
            }
            pm.subTask(this.getMessage(MessageKind.parsingFileTask, path.lastSegment(), path.removeLastSegments(1).toString()));
            long start = System.currentTimeMillis();
            FileContent codeReader = this.fResolver.getCodeReader(tu);
            IASTTranslationUnit ast = this.createAST(tu, lang, codeReader, scanInfo, this.fASTOptions, inContext, pm);
            this.fStatistics.fParsingTime = (int)((long)this.fStatistics.fParsingTime + (System.currentTimeMillis() - start));
            if (ast != null) {
                this.writeToIndex(linkageID, ast, codeReader.getContentsHash(), AbstractIndexerTask.computeHashCode(scanInfo), pm);
            }
        }
        catch (CoreException e) {
            th = e;
        }
        catch (RuntimeException e) {
            th = e;
        }
        catch (PDOMNotImplementedError e) {
            th = e;
        }
        catch (StackOverflowError e) {
            th = e;
        }
        catch (AssertionError e) {
            th = e;
        }
        catch (OutOfMemoryError e) {
            th = e;
        }
        if (th != null) {
            this.swallowError(path, (Throwable)th);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void writeToIndex(int linkageID, IASTTranslationUnit ast, long fileContentsHash, int configHash, IProgressMonitor pm) throws CoreException, InterruptedException {
        enteredFiles = new HashSet<IIndexFileLocation>();
        orderedIFLs = new ArrayList<IIndexFileLocation>();
        topIfl = this.fResolver.resolveASTPath(ast.getFilePath());
        enteredFiles.add(topIfl);
        tree = ast.getDependencyTree();
        var15_11 = inclusions = tree.getInclusions();
        var14_12 = inclusions.length;
        var13_14 = 0;
        while (var13_14 < var14_12) {
            inclusion = var15_11[var13_14];
            this.collectOrderedIFLs(linkageID, inclusion, enteredFiles, orderedIFLs);
            ++var13_14;
        }
        info = this.getFileInfo(linkageID, topIfl);
        if (info != null && IndexFileContent.access$4(info) && !IndexFileContent.access$5(info)) {
            orderedIFLs.add(topIfl);
        }
        ifls = orderedIFLs.toArray(new IIndexFileLocation[orderedIFLs.size()]);
        try {
            this.addSymbols(ast, ifls, this.fIndex, 1, false, fileContentsHash, configHash, this.fTodoTaskUpdater, pm);
        }
        finally {
            var18_18 = ifls;
            var17_20 = ifls.length;
            var16_22 = 0;
            ** while (var16_22 < var17_20)
        }
lbl-1000:
        // 1 sources

        {
            ifl = var18_18[var16_22];
            info = this.getFileInfo(linkageID, ifl);
            Assert.isNotNull((Object)info);
            IndexFileContent.access$2(info, true);
            ++var16_22;
            continue;
        }
lbl34:
        // 1 sources

    }

    private void collectOrderedIFLs(int linkageID, IASTTranslationUnit.IDependencyTree.IASTInclusionNode inclusion, HashSet<IIndexFileLocation> enteredFiles, ArrayList<IIndexFileLocation> orderedIFLs) throws CoreException {
        IASTPreprocessorIncludeStatement id = inclusion.getIncludeDirective();
        if (id.isActive() && id.isResolved()) {
            IASTTranslationUnit.IDependencyTree.IASTInclusionNode[] nested;
            IIndexFileLocation ifl = this.fResolver.resolveASTPath(id.getPath());
            boolean isFirstEntry = enteredFiles.add(ifl);
            IASTTranslationUnit.IDependencyTree.IASTInclusionNode[] iASTInclusionNodeArray = nested = inclusion.getNestedInclusions();
            int n = nested.length;
            int n2 = 0;
            while (n2 < n) {
                IASTTranslationUnit.IDependencyTree.IASTInclusionNode element = iASTInclusionNodeArray[n2];
                this.collectOrderedIFLs(linkageID, element, enteredFiles, orderedIFLs);
                ++n2;
            }
            if (isFirstEntry && this.needToUpdateHeader(linkageID, ifl)) {
                orderedIFLs.add(ifl);
            }
        }
    }

    public final boolean needToUpdateHeader(int linkageID, IIndexFileLocation ifl) throws CoreException {
        boolean needUpdate;
        IndexFileContent info = this.getFileInfo(linkageID, ifl);
        if (info == null) {
            IIndexFile ifile = null;
            if (this.fResolver.canBePartOfSDK(ifl)) {
                ifile = this.fIndex.getFile(linkageID, ifl);
            } else {
                IIndexFragmentFile fragFile = this.fIndex.getWritableFile(linkageID, ifl);
                if (fragFile != null && fragFile.hasContent()) {
                    ifile = fragFile;
                }
            }
            info = this.createFileInfo(new FileKey(linkageID, ifl.getURI()), ifile);
            if (ifile == null) {
                info.fRequestIsCounted = false;
                info.fRequestUpdate = true;
            }
        }
        boolean bl = needUpdate = !info.fIsUpdated && info.fRequestUpdate;
        if (needUpdate && info.fRequestIsCounted) {
            this.updateFileCount(0, 1, 0);
            info.fRequestIsCounted = false;
        }
        return needUpdate;
    }

    private IPath getPathForLabel(IIndexFileLocation ifl) {
        String fullPath = ifl.getFullPath();
        if (fullPath != null) {
            return new Path(fullPath);
        }
        IPath path = IndexLocationFactory.getAbsolutePath(ifl);
        if (path != null) {
            return path;
        }
        URI uri = ifl.getURI();
        return new Path(FileSystemUtilityManager.getDefault().getPathFromURI(uri));
    }

    private void swallowError(IPath file, Throwable e) throws CoreException {
        IStatus s;
        if (e instanceof CoreException) {
            Throwable masked;
            s = ((CoreException)e).getStatus();
            if (s.getCode() == 4 && "org.eclipse.cdt.core".equals(s.getPlugin())) {
                throw (CoreException)e;
            }
            Throwable exception = s.getException();
            if (exception != null && (masked = this.getMaskedException(exception)) != exception) {
                e = exception;
                exception = null;
            }
            if (exception == null) {
                s = new Status(s.getSeverity(), s.getPlugin(), s.getCode(), s.getMessage(), e);
            }
        } else {
            e = this.getMaskedException(e);
            s = this.createStatus(this.getMessage(MessageKind.errorWhileParsing, file), e);
        }
        this.logError(s);
        if (++this.fStatistics.fErrorCount > 500) {
            throw new CoreException(this.createStatus(this.getMessage(MessageKind.tooManyIndexProblems, new Object[0])));
        }
    }

    private Throwable getMaskedException(Throwable e) {
        if (e instanceof OutOfMemoryError || e instanceof StackOverflowError || e instanceof AssertionError) {
            return new InvocationTargetException(e);
        }
        return e;
    }

    protected void logError(IStatus s) {
        CCorePlugin.log((IStatus)s);
    }

    protected void logException(Throwable e) {
        CCorePlugin.log((Throwable)e);
    }

    private static int computeHashCode(IScannerInfo scannerInfo) {
        String[] a;
        int result = 0;
        Map<String, String> macros = scannerInfo.getDefinedSymbols();
        if (macros != null) {
            for (Map.Entry<String, String> entry : macros.entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                result = AbstractIndexerTask.addToHashcode(result, key);
                if (value == null || value.length() <= 0) continue;
                result = AbstractIndexerTask.addToHashcode(result, value);
            }
        }
        if ((a = scannerInfo.getIncludePaths()) != null) {
            String[] stringArray = a;
            int n = a.length;
            int key = 0;
            while (key < n) {
                String element = stringArray[key];
                result = AbstractIndexerTask.addToHashcode(result, element);
                ++key;
            }
        }
        if (scannerInfo instanceof IExtendedScannerInfo) {
            String element;
            String[] stringArray;
            IExtendedScannerInfo esi = (IExtendedScannerInfo)scannerInfo;
            a = esi.getIncludeFiles();
            if (a != null) {
                stringArray = a;
                int n = a.length;
                int n2 = 0;
                while (n2 < n) {
                    element = stringArray[n2];
                    result = AbstractIndexerTask.addToHashcode(result, element);
                    ++n2;
                }
            }
            if ((a = esi.getLocalIncludePath()) != null) {
                stringArray = a;
                int n = a.length;
                int n3 = 0;
                while (n3 < n) {
                    element = stringArray[n3];
                    result = AbstractIndexerTask.addToHashcode(result, element);
                    ++n3;
                }
            }
            if ((a = esi.getMacroFiles()) != null) {
                stringArray = a;
                int n = a.length;
                int n4 = 0;
                while (n4 < n) {
                    element = stringArray[n4];
                    result = AbstractIndexerTask.addToHashcode(result, element);
                    ++n4;
                }
            }
        }
        return result;
    }

    private static int addToHashcode(int result, String key) {
        return result * 31 + key.hashCode();
    }

    private long computeFileContentsHash(Object tu) {
        FileContent codeReader = this.fResolver.getCodeReader(tu);
        return codeReader != null ? codeReader.getContentsHash() : 0L;
    }

    public final IndexFileContent getFileContent(int linkageID, IIndexFileLocation ifl) throws CoreException {
        if (!this.needToUpdateHeader(linkageID, ifl)) {
            IndexFileContent info = this.getFileInfo(linkageID, ifl);
            Assert.isNotNull((Object)info);
            if (info.fIndexFile == null) {
                info.fIndexFile = this.fIndex.getFile(linkageID, ifl);
                if (info.fIndexFile == null) {
                    return null;
                }
            }
            return info;
        }
        return null;
    }

    protected String getMessage(MessageKind kind, Object ... arguments) {
        switch (kind) {
            case parsingFileTask: {
                return NLS.bind((String)Messages.AbstractIndexerTask_parsingFileTask, (Object[])arguments);
            }
            case errorWhileParsing: {
                return NLS.bind((String)Messages.AbstractIndexerTask_errorWhileParsing, (Object[])arguments);
            }
            case tooManyIndexProblems: {
                return Messages.AbstractIndexerTask_tooManyIndexProblems;
            }
        }
        return null;
    }

    protected int[] getLinkagesToParse() {
        return PDOMManager.IDS_FOR_LINKAGES_TO_INDEX;
    }

    private static class FileKey {
        final URI fUri;
        final int fLinkageID;

        public FileKey(int linkageID, URI uri) {
            this.fUri = uri;
            this.fLinkageID = linkageID;
        }

        public int hashCode() {
            return this.fUri.hashCode() * 31 + this.fLinkageID;
        }

        public boolean equals(Object obj) {
            FileKey other = (FileKey)obj;
            return this.fLinkageID == other.fLinkageID && this.fUri.equals(other.fUri);
        }
    }

    public static class IndexFileContent {
        private IIndexFile fIndexFile = null;
        private boolean fRequestUpdate = false;
        private boolean fRequestIsCounted = true;
        private boolean fIsUpdated = false;
        private Object[] fPreprocessingDirectives;
        private ICPPUsingDirective[] fDirectives;

        public Object[] getPreprocessingDirectives() throws CoreException {
            if (this.fPreprocessingDirectives == null) {
                if (this.fIndexFile == null) {
                    return new Object[0];
                }
                this.setPreprocessorDirectives(this.fIndexFile.getIncludes(), this.fIndexFile.getMacros());
            }
            return this.fPreprocessingDirectives;
        }

        public ICPPUsingDirective[] getUsingDirectives() throws CoreException {
            if (this.fDirectives == null) {
                if (this.fIndexFile == null) {
                    return ICPPUsingDirective.EMPTY_ARRAY;
                }
                this.setUsingDirectives(this.fIndexFile.getUsingDirectives());
            }
            return this.fDirectives;
        }

        public void setPreprocessorDirectives(IIndexInclude[] includes, IIndexMacro[] macros) throws CoreException {
            this.fPreprocessingDirectives = IndexFileContent.merge(includes, macros);
        }

        public void setUsingDirectives(ICPPUsingDirective[] usingDirectives) {
            this.fDirectives = usingDirectives;
        }

        public void clearCaches() {
            this.fPreprocessingDirectives = null;
            this.fDirectives = null;
        }

        public static Object[] merge(IIndexInclude[] includes, IIndexMacro[] macros) throws CoreException {
            Object[] merged = new Object[includes.length + macros.length];
            int i = 0;
            int m = 0;
            int ioffset = IndexFileContent.getOffset(includes, i);
            int moffset = IndexFileContent.getOffset(macros, m);
            int k = 0;
            while (k < merged.length) {
                if (ioffset <= moffset) {
                    merged[k] = includes[i];
                    ioffset = IndexFileContent.getOffset(includes, ++i);
                } else {
                    merged[k] = macros[m];
                    moffset = IndexFileContent.getOffset(macros, ++m);
                }
                ++k;
            }
            return merged;
        }

        private static int getOffset(IIndexMacro[] macros, int m) throws CoreException {
            if (m < macros.length) {
                return macros[m].getFileLocation().getNodeOffset();
            }
            return Integer.MAX_VALUE;
        }

        private static int getOffset(IIndexInclude[] includes, int i) throws CoreException {
            if (i < includes.length) {
                return includes[i].getNameOffset();
            }
            return Integer.MAX_VALUE;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum MessageKind {
        parsingFileTask,
        errorWhileParsing,
        tooManyIndexProblems;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum UnusedHeaderStrategy {
        skip,
        useDefaultLanguage,
        useAlternateLanguage,
        useBoth;

    }
}

