/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.pldt.common.actions;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ptp.pldt.common.CommonPlugin;
import org.eclipse.ptp.pldt.common.actions.Messages;
import org.eclipse.ptp.pldt.common.actions.RunAnalyseHandler;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.handlers.HandlerUtil;

public class AnalysisDropdownHandler
extends AbstractHandler
implements ISelectionListener {
    protected static RunAnalyseHandler lastAnalysisHandler = null;
    protected static IStructuredSelection lastAnalysisSelection = null;
    protected IStructuredSelection lastSelection = null;
    protected static AnalysisDropdownHandler instance = null;
    private static final boolean traceOn = false;

    public AnalysisDropdownHandler() {
        String projExpID;
        ISelection apSel;
        assert (instance == null);
        instance = this;
        ISelectionService ss = null;
        try {
            ss = CommonPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getSelectionService();
            ss.addSelectionListener((ISelectionListener)this);
            ISelection sel = ss.getSelection();
            if (sel instanceof IStructuredSelection) {
                this.lastSelection = (IStructuredSelection)sel;
            }
        }
        catch (Exception e) {
            Throwable t = e.getCause();
            String msg = "(no cause)";
            if (t != null) {
                msg = t.getMessage();
            }
            System.out.println("AnalysisDropdownHandler <init> " + e.getMessage() + " cause: " + msg);
        }
        if (this.lastSelection == null && (apSel = ss.getSelection(projExpID = "org.eclipse.ui.navigator.ProjectExplorer")) != null & apSel instanceof IStructuredSelection && !apSel.isEmpty()) {
            this.lastSelection = (IStructuredSelection)apSel;
        }
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (lastAnalysisHandler != null) {
            lastAnalysisHandler.execute(event);
        } else {
            String msg = Messages.AnalysisDropdownHandler_9;
            MessageDialog.openInformation(null, (String)Messages.AnalysisDropdownHandler_10, (String)msg);
        }
        return null;
    }

    public static void setLastHandledAnalysis(RunAnalyseHandler handler, IStructuredSelection selection) {
        lastAnalysisHandler = handler;
        if (selection != null) {
            lastAnalysisSelection = selection;
        }
    }

    public static IStructuredSelection getLastAnalysisSelection() {
        return lastAnalysisSelection;
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            this.lastSelection = (IStructuredSelection)selection;
        }
    }

    public IStructuredSelection getLastSelection() {
        return this.lastSelection;
    }

    public static AnalysisDropdownHandler getInstance() {
        if (instance == null) {
            instance = new AnalysisDropdownHandler();
        }
        return instance;
    }
}

