/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.core.refactoring;

import java.util.HashSet;
import java.util.List;
import java.util.TreeSet;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.photran.internal.core.analysis.binding.Definition;
import org.eclipse.photran.internal.core.analysis.binding.ScopingNode;
import org.eclipse.photran.internal.core.lexer.Token;
import org.eclipse.photran.internal.core.parser.ASTArrayDeclaratorNode;
import org.eclipse.photran.internal.core.parser.ASTArraySpecNode;
import org.eclipse.photran.internal.core.parser.ASTAttrSpecNode;
import org.eclipse.photran.internal.core.parser.ASTAttrSpecSeqNode;
import org.eclipse.photran.internal.core.parser.ASTCommonStmtNode;
import org.eclipse.photran.internal.core.parser.ASTDimensionStmtNode;
import org.eclipse.photran.internal.core.parser.ASTEntityDeclNode;
import org.eclipse.photran.internal.core.parser.ASTFunctionStmtNode;
import org.eclipse.photran.internal.core.parser.ASTFunctionSubprogramNode;
import org.eclipse.photran.internal.core.parser.ASTInitializationNode;
import org.eclipse.photran.internal.core.parser.ASTInterfaceBlockNode;
import org.eclipse.photran.internal.core.parser.ASTMainProgramNode;
import org.eclipse.photran.internal.core.parser.ASTSaveStmtNode;
import org.eclipse.photran.internal.core.parser.ASTSavedEntityNode;
import org.eclipse.photran.internal.core.parser.ASTSubroutineStmtNode;
import org.eclipse.photran.internal.core.parser.ASTSubroutineSubprogramNode;
import org.eclipse.photran.internal.core.parser.ASTTypeDeclarationStmtNode;
import org.eclipse.photran.internal.core.parser.ASTTypeSpecNode;
import org.eclipse.photran.internal.core.parser.IASTListNode;
import org.eclipse.photran.internal.core.parser.IASTNode;
import org.eclipse.photran.internal.core.parser.IBodyConstruct;
import org.eclipse.photran.internal.core.parser.ISpecificationStmt;
import org.eclipse.photran.internal.core.refactoring.infrastructure.FortranEditorRefactoring;
import org.eclipse.photran.internal.core.refactoring.infrastructure.Reindenter;
import org.eclipse.photran.internal.core.refactoring.infrastructure.SourcePrinter;
import org.eclipse.photran.internal.core.vpg.PhotranTokenRef;
import org.eclipse.photran.internal.core.vpg.PhotranVPG;
import org.eclipse.rephraserengine.core.vpg.refactoring.VPGRefactoring;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MoveSavedToCommonBlockRefactoring
extends FortranEditorRefactoring {
    private static final String EOL = System.getProperty("line.separator");
    private static final String SELECT_SUBPROGRAM_WARNING = "Please select a subroutine or a function (place the cursor in its statement).";
    private static final String SELECT_NON_INTERFACE_SUBPROGRAM_WARNING = "The subroutine's or the function's statement should not be the interface declaration.";
    private String subprogramName = null;
    private ScopingNode subprogramNode = null;
    private IASTListNode<IBodyConstruct> subprogramBodyNode = null;
    private ASTMainProgramNode mainProgramNode = null;

    public String getName() {
        return "Move Saved Variables to COMMON Block";
    }

    protected void doCheckInitialConditions(RefactoringStatus status, IProgressMonitor pm) throws VPGRefactoring.PreconditionFailure {
        ASTSubroutineStmtNode subroutineStmtNode;
        this.ensureProjectHasRefactoringEnabled(status);
        Token token = MoveSavedToCommonBlockRefactoring.findEnclosingToken(this.astOfFileInEditor, this.selectedRegionInEditor);
        if (token == null) {
            this.fail(SELECT_SUBPROGRAM_WARNING);
        }
        if (token.findNearestAncestor(ASTInterfaceBlockNode.class) != null) {
            this.fail(SELECT_NON_INTERFACE_SUBPROGRAM_WARNING);
        }
        if ((subroutineStmtNode = token.findNearestAncestor(ASTSubroutineStmtNode.class)) == null) {
            ASTFunctionStmtNode functionStmtNode = token.findNearestAncestor(ASTFunctionStmtNode.class);
            if (functionStmtNode == null) {
                this.fail(SELECT_SUBPROGRAM_WARNING);
            }
            this.subprogramName = functionStmtNode.getFunctionName().getFunctionName().getText();
            this.subprogramNode = (ASTFunctionSubprogramNode)functionStmtNode.getParent();
            this.subprogramBodyNode = ((ASTFunctionSubprogramNode)this.subprogramNode).getBody();
        } else {
            this.subprogramName = subroutineStmtNode.getSubroutineName().getSubroutineName().getText();
            this.subprogramNode = (ASTSubroutineSubprogramNode)subroutineStmtNode.getParent();
            this.subprogramBodyNode = ((ASTSubroutineSubprogramNode)this.subprogramNode).getBody();
        }
        ScopingNode enclosingScope = this.subprogramNode.getEnclosingScope();
        if (!(enclosingScope instanceof ASTMainProgramNode)) {
            this.fail("The current implementation handles only subprograms that are in the CONTAINS section of the PROGRAM.");
        }
        this.mainProgramNode = (ASTMainProgramNode)enclosingScope;
    }

    protected void doCheckFinalConditions(RefactoringStatus status, IProgressMonitor pm) throws VPGRefactoring.PreconditionFailure {
    }

    protected void doCreateChange(IProgressMonitor progressMonitor) throws CoreException, OperationCanceledException {
        assert (this.subprogramNode != null);
        assert (this.subprogramBodyNode != null);
        assert (this.subprogramName != null);
        assert (this.mainProgramNode != null);
        try {
            if (this.subprogramBodyNode == null) {
                return;
            }
            try {
                TreeSet<Definition> savedVariableDefinitions = this.getSavedVariableDefinitions();
                StringBuffer globalVariableDeclarations = new StringBuffer();
                StringBuffer commonBlockVariables = new StringBuffer();
                for (Definition definition : savedVariableDefinitions) {
                    String globalTypeDeclarationString = this.constructGlobalTypeDeclarationFor(definition);
                    if (globalTypeDeclarationString == null) continue;
                    globalVariableDeclarations.append(EOL).append(globalTypeDeclarationString).append(EOL);
                    commonBlockVariables.append(definition.getTokenRef().findToken().getText()).append(",");
                }
                if (globalVariableDeclarations.length() > 0) {
                    this.createGlobalCommonBlock(globalVariableDeclarations, commonBlockVariables);
                }
                this.addChangeFromModifiedAST(this.fileInEditor, progressMonitor);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        finally {
            ((PhotranVPG)this.vpg).releaseAllASTs();
        }
    }

    private void createGlobalCommonBlock(StringBuffer globalVariableDeclarations, StringBuffer commonBlockVariables) {
        String commonBlockName = this.generateUniqueCommonBlockName();
        String commonBlock = String.valueOf(EOL) + "COMMON /" + commonBlockName + "/ " + commonBlockVariables.toString().substring(0, commonBlockVariables.length() - 1) + EOL;
        globalVariableDeclarations.append(commonBlock);
        IASTListNode<IBodyConstruct> mainProgramListNode = MoveSavedToCommonBlockRefactoring.parseLiteralStatementSequence(globalVariableDeclarations.toString());
        this.mainProgramNode.getBody().addAll(MoveSavedToCommonBlockRefactoring.findIndexToInsertTypeDeclaration(this.mainProgramNode.getBody()), mainProgramListNode);
        IASTListNode<IBodyConstruct> subprogramListNode = MoveSavedToCommonBlockRefactoring.parseLiteralStatementSequence(commonBlock);
        this.subprogramBodyNode.addAll(MoveSavedToCommonBlockRefactoring.findIndexToInsertTypeDeclaration(this.subprogramBodyNode), subprogramListNode);
        Reindenter.reindent(mainProgramListNode, this.astOfFileInEditor);
        Reindenter.reindent(subprogramListNode, this.astOfFileInEditor);
    }

    private String generateUniqueCommonBlockName() {
        String commonBlockName = String.valueOf(this.subprogramName) + "_common1";
        int counter = 1;
        while (this.isConflictingOrShadowing(this.mainProgramNode.findFirstToken(), commonBlockName)) {
            commonBlockName = String.valueOf(this.subprogramName) + "_common" + ++counter;
        }
        return commonBlockName;
    }

    private Definition getUniqueDefinitionOrFail(Token variableName) throws VPGRefactoring.PreconditionFailure {
        List<Definition> variableDefinitions = variableName.resolveBinding();
        if (variableDefinitions.size() > 1 || variableDefinitions.size() == 0) {
            this.fail("Absent or ambiguous definition for variable \"" + variableName.getText() + "\".");
        }
        return variableDefinitions.get(0);
    }

    private void collectSaveStmtVariableDefinitions(ASTSaveStmtNode saveNode, TreeSet<Definition> savedVariableDefinitions) throws VPGRefactoring.PreconditionFailure {
        IASTListNode<ASTSavedEntityNode> variableList = saveNode.getVariableList();
        if (variableList == null) {
            savedVariableDefinitions.addAll(this.subprogramNode.getAllDefinitions());
        } else {
            for (ASTSavedEntityNode savedVariable : variableList) {
                savedVariableDefinitions.add(this.getUniqueDefinitionOrFail(savedVariable.getVariableName()));
            }
        }
        saveNode.removeFromTree();
    }

    private void collectTypeDeclarationVariableDefinitions(ASTTypeDeclarationStmtNode typeDeclaration, TreeSet<Definition> savedVariableDefinitions) throws VPGRefactoring.PreconditionFailure {
        IASTListNode<ASTAttrSpecSeqNode> attrSpecSeq = typeDeclaration.getAttrSpecSeq();
        if (attrSpecSeq != null) {
            for (ASTAttrSpecSeqNode attrSpecSeqNode : attrSpecSeq) {
                ASTAttrSpecNode attrSpecNode = attrSpecSeqNode.getAttrSpec();
                if (attrSpecNode == null || !attrSpecNode.isSave()) continue;
                IASTListNode<ASTEntityDeclNode> entityDeclList = typeDeclaration.getEntityDeclList();
                for (ASTEntityDeclNode variableDeclaration : entityDeclList) {
                    savedVariableDefinitions.add(this.getUniqueDefinitionOrFail(variableDeclaration.getObjectName().getObjectName()));
                }
                attrSpecSeq.remove(attrSpecSeqNode);
                return;
            }
        }
        IASTListNode<ASTEntityDeclNode> entityDeclList = typeDeclaration.getEntityDeclList();
        for (ASTEntityDeclNode variableDeclaration : entityDeclList) {
            if (variableDeclaration.getInitialization() == null) continue;
            savedVariableDefinitions.add(this.getUniqueDefinitionOrFail(variableDeclaration.getObjectName().getObjectName()));
        }
    }

    private TreeSet<Definition> getSavedVariableDefinitions() throws VPGRefactoring.PreconditionFailure {
        TreeSet<Definition> savedVariableDefinitions = new TreeSet<Definition>();
        for (IASTNode iASTNode : this.subprogramBodyNode.getChildren()) {
            if (iASTNode instanceof ASTSaveStmtNode) {
                this.collectSaveStmtVariableDefinitions((ASTSaveStmtNode)iASTNode, savedVariableDefinitions);
                continue;
            }
            if (!(iASTNode instanceof ASTTypeDeclarationStmtNode)) continue;
            this.collectTypeDeclarationVariableDefinitions((ASTTypeDeclarationStmtNode)iASTNode, savedVariableDefinitions);
        }
        return savedVariableDefinitions;
    }

    private String constructGlobalTypeDeclarationFor(Definition variableDefinition) throws VPGRefactoring.PreconditionFailure {
        if (variableDefinition.isSubprogramArgument()) {
            return null;
        }
        StringBuffer result = new StringBuffer();
        HashSet<String> usedSpecs = new HashSet<String>();
        String variableInitAndArraySpec = this.processOriginalTypeDeclaration(variableDefinition, result, usedSpecs);
        if (variableInitAndArraySpec == null) {
            return null;
        }
        String newVariableName = this.generateUniqueVariableNameAndUpdateDefinition(variableDefinition);
        this.processSpecifications(newVariableName, variableDefinition, result, usedSpecs);
        result.append(" :: ").append(newVariableName).append(variableInitAndArraySpec);
        return result.toString();
    }

    private String processOriginalTypeDeclaration(Definition variableDefinition, StringBuffer result, HashSet<String> usedSpecs) throws VPGRefactoring.PreconditionFailure {
        Token definitionToken = variableDefinition.getTokenRef().findToken();
        ASTTypeDeclarationStmtNode typeDeclaration = definitionToken.findNearestAncestor(ASTTypeDeclarationStmtNode.class);
        if (typeDeclaration == null) {
            result.append("TYPE(UNKNOWN)");
        } else {
            ASTTypeSpecNode typeSpecNode = typeDeclaration.getTypeSpec();
            if (typeSpecNode == null) {
                this.fail("Could not find type specification node for variable \"" + variableDefinition.getCanonicalizedName() + "\".");
            }
            result.append(SourcePrinter.getSourceCodeFromASTNode(typeSpecNode).trim().toUpperCase());
            IASTListNode<ASTAttrSpecSeqNode> attrSpecSeq = typeDeclaration.getAttrSpecSeq();
            if (attrSpecSeq != null) {
                for (ASTAttrSpecSeqNode attrSpecSeqNode : attrSpecSeq) {
                    ASTAttrSpecNode attrSpecNode = attrSpecSeqNode.getAttrSpec();
                    if (attrSpecNode == null) continue;
                    if (attrSpecNode.isParameter()) {
                        return null;
                    }
                    String spec = SourcePrinter.getSourceCodeFromASTNode(attrSpecNode).trim().toUpperCase();
                    result.append(", ").append(spec);
                    usedSpecs.add(spec);
                }
            }
        }
        return this.processEntityDeclNode(variableDefinition);
    }

    private String processEntityDeclNode(Definition variableDefinition) throws VPGRefactoring.PreconditionFailure {
        ASTArraySpecNode arraySpecNode;
        ASTInitializationNode initializationNode;
        StringBuffer returnString = new StringBuffer();
        Token definitionToken = variableDefinition.getTokenRef().findToken();
        ASTEntityDeclNode declarationNode = definitionToken.findNearestAncestor(ASTEntityDeclNode.class);
        if (declarationNode == null) {
            this.fail("Could not find declaration node for variable \"" + variableDefinition.getCanonicalizedName() + "\".");
        }
        if ((initializationNode = declarationNode.getInitialization()) != null) {
            returnString.append(SourcePrinter.getSourceCodeFromASTNode(initializationNode));
            declarationNode.setInitialization(null);
        }
        if ((arraySpecNode = declarationNode.getArraySpec()) != null) {
            returnString.append("(").append(SourcePrinter.getSourceCodeFromASTNode(arraySpecNode).trim()).append(")");
        }
        return returnString.toString();
    }

    private void processSpecifications(String newVariableName, Definition variableDefinition, StringBuffer result, HashSet<String> usedSpecs) throws VPGRefactoring.PreconditionFailure {
        for (PhotranTokenRef tokenReference : variableDefinition.findAllReferences(false)) {
            String spec;
            tokenReference.findToken().setText(newVariableName);
            ISpecificationStmt enclosingSpecStmt = tokenReference.findToken().findNearestAncestor(ISpecificationStmt.class);
            if (enclosingSpecStmt == null) continue;
            if (enclosingSpecStmt instanceof ASTDimensionStmtNode) {
                ASTArrayDeclaratorNode arrayDeclaratorNode = tokenReference.findToken().findNearestAncestor(ASTArrayDeclaratorNode.class);
                ASTArraySpecNode arraySpec = null;
                if (arrayDeclaratorNode == null || (arraySpec = arrayDeclaratorNode.getArraySpec()) == null) {
                    this.fail("Could not find array declaration for DIMENSION specification of variable \"" + variableDefinition.getCanonicalizedName() + "\".");
                }
                result.append(", DIMENSION(").append(SourcePrinter.getSourceCodeFromASTNode(arraySpec)).append(")");
                continue;
            }
            if (enclosingSpecStmt instanceof ASTSaveStmtNode || enclosingSpecStmt instanceof ASTCommonStmtNode || usedSpecs.contains(spec = enclosingSpecStmt.findFirstToken().getText().trim().toUpperCase())) continue;
            result.append(", ").append(spec);
            usedSpecs.add(spec);
        }
    }

    private String generateUniqueVariableNameAndUpdateDefinition(Definition variableDefinition) {
        Token definitionToken = variableDefinition.getTokenRef().findToken();
        String newVariableName = String.valueOf(variableDefinition.getCanonicalizedName()) + "_xxx1";
        int counter = 1;
        while (this.isConflictingOrShadowing(definitionToken, newVariableName)) {
            newVariableName = String.valueOf(variableDefinition.getCanonicalizedName()) + "_xxx" + ++counter;
        }
        definitionToken.setText(newVariableName);
        return newVariableName;
    }

    private boolean isConflictingOrShadowing(Token baseToken, String newVariableName) {
        Token.FakeToken fakeToken = new Token.FakeToken(baseToken, newVariableName);
        List<PhotranTokenRef> conflictingDef = this.subprogramNode.manuallyResolve(fakeToken);
        conflictingDef.addAll(this.mainProgramNode.manuallyResolve(fakeToken));
        for (ScopingNode importingScope : this.subprogramNode.findImportingScopes()) {
            conflictingDef.addAll(importingScope.manuallyResolve(fakeToken));
        }
        for (ScopingNode importingScope : this.mainProgramNode.findImportingScopes()) {
            conflictingDef.addAll(importingScope.manuallyResolve(fakeToken));
        }
        return !conflictingDef.isEmpty();
    }
}

